/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834cmd1.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/834cmd1.c_v  $
 * 
 *    Rev 1.6   08 Nov 1993 15:22:22   vinay
 * fixed accepting of garbage after show brg traffic 1 
 * 
 *    Rev 1.5   12 Oct 1993 10:17:12   vinay
 * added showmem routine
 * 
 *    Rev 1.4   05 Oct 1993 17:23:08   vinay
 * fixed the accepting of garbage at end of line
 * for the command show br tr <interval>
 * 
 *    Rev 1.3   22 Sep 1993 09:19:48   vinay
 * not printing the PORT for User specified filter.
 * 
 *    Rev 1.2   08 Sep 1993 10:04:26   vinay
 * showing the ring number on the status screen
 * 
 *    Rev 1.1   24 May 1993 18:31:12   vinay
 * commented out the printf's for fddi-enet status screen
 * 
 *    Rev 1.0   04 May 1993 16:03:46   franks
 * Initial revision.
 * 
 *    Rev 1.5   13 May 1992 14:29:56   franks
 * 1). Changed the main status screen. Bootp field and the AUI fields.
* 
*    Rev 1.4   04 May 1992 12:16:24   franks
*    No change.
* 
*    Rev 1.3   17 Apr 1992 16:17:44   franks
*    No change.
* 
*    Rev 1.2   16 Apr 1992 14:46:54   franks
*    No change.
* 
*    Rev 1.1   14 Apr 1992 13:06:06   franks
*    1). Modified the main status screen so that the tranceiver module type 
*        is displayed.
* 
*    Rev 1.0   30 Mar 1992 17:48:00   pvcs
*    Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/


#include <types.h>
#include <target.h>
#include <bridges.h>
#include <filter.h>
#include <utility.h>
#include <prcadr.h> 
#include <krnl.h>
#include <prcctl.h>
#include <sncvar.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include <stp.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <ascii.h>
#include <param.h>
#include <834parser.h>
#include <cpb.h>
#include <834error.h>
#include <rlog.h>

/* EXTERNAL VARIABLE DEFINITIONS */
extern char *APPLSOFTVERSION;
extern IP IPDevice[];
extern PRCCTL prc;
extern NVR_BSTATUS *BridgeStatus;
extern ERRORLOG ErrorLogTable[];
extern Port_data port_info[];
extern Bridge_data bridge_info;
extern void BitmaskStatusScreen();
extern TIMER IntervalTimer;
extern TIMER InactivityTimer;
extern MBOX TrRcvMBox;
extern tcpip *_initp;
extern unsigned long InitTimeSeconds;
extern unsigned long InitDateSeconds;
extern long GmtOffset;
extern UDPDIR *udpdir;
extern uint Ports;           /* Bitmask of port list enterd on cmd line */
extern uint ConsoleActive; 
extern RAM_PIT rampit;

int TimedOut();

/******************************************************************************/
							/*	Start Save()  */
Save( CPB_P pcpb ) {

	SaveStaticRecs();

	return( 0 );
}
/* End Save() */

/******************************************************************************/
						/* Start ShowAlarmMgr() */

ShowAlarmMgr( CPB_P cpb) {
	int i;

	Header();
	printf("\n\n\nThe snmp managers for this bridge are:\n\n");
	printf("No.\t\t IP ADDRESS\n\n");
	for (i = 0; i < 2; i++)
	{
		printf("%d\t\t", i+1);
		PrintIPAddress(  BridgeStatus->SnmpMgr[i] );
	}
	Scroll(13);
	return( 0 );
}

/******************************************************************************/

ShowBrgStatus(CPB_P pcpb) {

	/* Are there parameters after "show bridge" */
	if( pcpb->cl_idx < pcpb->cmdlen )
		return( 0 );
	/* No more paramters */
	else {
		Header();
		Copyright();
		printf("\t\t\t\t\t\t\t\t%s\n\n","MAIN BRIDGE STATUS");
		MainStatusScreen();
		Scroll(1);
		return( 0 );
	}
}
/******************************************************************************/

ShowBitMask(CPB_P pcpb) {

	Header();
	putchar('\n');
	BitmaskStatusScreen();
	Scroll(2);
	return( 0 );
}
/******************************************************************************/

ShowBrgContact( CPB_P pcpb ) {

	Header();
	Scroll(4);
	printf("\n\nThe network administrator for this bridge:\n\n");
	/**** 2.24.92	K Kong
	printf("%s\n", strupr(BridgeStatus->Contact));
	******/
	printf("%s\n", BridgeStatus->Contact);
	Scroll(13);
	return( 0 );
}

/******************************************************************************/
							/* ShowBrgIP() */
ShowBrgIP( CPB_P pcpb ) {

	EEP_BOOT *BootRec = &eep_boot_rec;
	int  i;
	char *ipa;

	Header();
	Scroll(3);

	ipa = (char *)GetEepIpAddr( MYIPADDR );
	if( ipa == 0L )
		printf ("%-15s %s\n\n", "IP Address", NA);
	else	
		printf ("%-15s %s\n\n", "IP Address", ipa);

	ipa = (char *)GetEepIpAddr( IPMASK );
	if( ipa == 0L )
		printf ("%-15s %s\n\n", "IP Mask", NA);
	else	
		printf ("%-15s %s\n\n", "IP Mask", ipa);

	printf("%-15s\n", "IP Routers:");
	ipa = (char *) inet_ntoa( BootRec->eep_RouterIP[0] );
	if( BootRec->eep_RouterIP[0] == 0 )
		ipa = NA;
	printf("%-15s %s\n","PRIMARY",ipa);

	ipa = (char *) inet_ntoa( BootRec->eep_RouterIP[1] );
	if( BootRec->eep_RouterIP[1] == 0 )
		ipa = NA;
	printf("%-15s %s\n","SECONDARY",ipa);
	Scroll(9);
}

/******************************************************************************/

ShowBrgLocation( CPB_P pcpb ) {

	Header();
	Scroll(4);
	printf("\n\nBridge Location:\n\n");
	/*** K Kong	2.24.92
	printf("%s\n", strupr(BridgeStatus->Location));
	*******/
	printf("%s\n", BridgeStatus->Location);
	Scroll(13);
	return( 0 );
}

/******************************************************************************/

ShowBrgLog( CPB_P pcpb ) {

    Header();
	Copyright();
	printf("\t\t\t\t\t\t\t\t\tRESET LOG\n\n");

	printf("%-6s%-13s%-13s%-27s%s\n\n",
		   "NO.","DATE","TIME","REASON","ELAPSED TIME");

	ShowRstLog();
	Scroll(5);
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowBrgName( CPB_P pcpb ) {

	Header();
	Scroll(4);
	printf("\n\nBridge Name:\n\n");
	/**** K Kong	2.24.92
	printf("%s\n", strupr(BridgeStatus->Name));
	*****/
	printf("%s\n", BridgeStatus->Name);
	Scroll(13);
	return( 0 );
}

/******************************************************************************/

ShowBrgRLog( CPB_P pcpb ) {

	char *arg;
    uint total;

    Header();
	Copyright();

	if( pcpb->cl_idx < pcpb->cmdlen ) {

		arg = &pcpb->cmd[pcpb->cl_idx];
		if( strncmp(arg, "status", strlen(arg)) == NULL )  {

	        printf("\t\t\t\t\t\t\t\tRELEARN LOG STATUS\n\n");
			/* rlog_full is the log wrap count */
			total = relearnlog.rlog_count + (relearnlog.rlog_full*RLOG_COUNT);

			printf("\n\nAddresses relearned: %d\n\n", total);
	        printf("Table Capacity:      %d \n\n", RLOG_COUNT);
			Scroll(13);
        }
    }		
    else {

	    printf("\t\t\t\t\t\t\t\t\tRELEARN LOG\n\n");
	    printf("Table Capacity: %d entries\n\n", RLOG_COUNT);
	    printf("%-6s%-13s%-13s%-18s%s\n\n",
		       "NO.","DATE","TIME","NODE ADDRESS","DESCRIPTION");
	    ShowRelearnLog();
    }

	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowBrgSNMP( CPB_P pcpb ) {

	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t %s\n\n\n", SNMPScreen);
	SNMPStatusScreen();
	Scroll(2);
	return( 0 );
}

/******************************************************************************/
                        /* Start ShowBrgTftp() */

ShowBrgTftp( CPB_P pcpb )  {

	char *ipa;
	
	Header();
	Scroll(4);
	printf("Image File:            %s\n\n",  GetImageFile());
	printf("Request File:          %s\n\n",   GetRqstFile());
	printf("Configuration File:    %s\n\n", GetConfigFile());

	printf("TFTP Server Address: ");
	
	ipa = (char *)GetEepIpAddr( TFTPSERVER );
	if( ipa == 0L )
		printf (" %s",  NA);
	else	
		printf (" %s", ipa);

	Scroll(12);
}

/******************************************************************************/

ShowBrgTraffic( CPB_P pcpb ) {

	RAM_PIT *pram = &rampit;
	extern SEM RemoteDisconnected;
	extern SEM SwUpdateFromSnmp; 
	uint Term = BridgeStatus->TermType;
	uint TimeOut = BridgeStatus->TimeOut;
	uint value = 0;
	uint i;
	uint length;
	uint StartTicks = 0;
	uint ElapsedTime = 0;
	char *kw;
	int  ch;

	/* If there are more parameters */
	if( pcpb->cl_idx < pcpb->cmdlen ) {
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		if(!atod(kw,&value))
			return KW_UN_AMB;
   		pcpb->cl_idx += length;
		if( pcpb->cl_idx < pcpb->cmdlen ) 
			return KW_UN_AMB;
/*
		sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &value);	
*/
		if( value > 6000 )
			return(OUT_OF_RANGE);
		StartTicks = RealTimeTicks();
		StopTimer(&InactivityTimer);
	}

	if( Term == VT100 ) {
		TermCrsOff();
		TermClrScr();
		TermHome();
	}

	do {
		SHOWSCREEN:
		MainTrafficScreen();

		/* Check if telnet session has been terminated */
		if( AcptSignal( &RemoteDisconnected ) ) {
			Scroll(25);
			pram->mode = PASSWORDMODE;
	        ConsoleActive = FALSE;
			printf("Traffic Screen Update Terminated By Console\n\n");
			return(0);
		}

		if( AcptSignal( &SwUpdateFromSnmp ) != 0 ) {
		SwUpdateMsg();
	        return( TFTP_LOADER );
        }

		if( value > 0 && Term == VT100 ) {

			printf("\n\nInterval: %d %-6s    ",value,"sec" ); 
			printf("Elapsed Time: %d %-8s",((RealTimeTicks()-StartTicks)/100),
					"sec");
			printf("\n\n\t\t\t\t\t     ");
			TermRevVid();
			printf("**** Press  C to Clear ****\n");
			TermNormVid();
			printf("\t\t\t\t\t     ");
			TermRevVid();
			printf("**** Press ESC to quit ****");
			TermNormVid();
			TermHome();
			StartTimer( &IntervalTimer, (25), &TrRcvMBox ); 
		}
		else
		if( value > 0 ) {

			printf("\n\nInterval: %d sec     ", value); 
			printf("Elapsed Time: %d %-8s",((RealTimeTicks()-StartTicks)/100),
					"sec");
			printf("\n\n\t\t\t\t\t     ");
			printf("**** Press  C to Clear ****\n");
			printf("\t\t\t\t\t     ");
			printf("**** Press ESC to quit ****");
		    putchar('\n');
			StartTimer( &IntervalTimer, (25), &TrRcvMBox ); 
		}
		else
			Scroll(3);
		
		while( ElapsedTime < (value*4) ) {

            ch = getch();
		    do {

		        if( ch == ESC ) {
			        if( Term == VT100 ) {
			        	StopTimer( &IntervalTimer ); 
			        	TermClrScr();
			        	TermHome();
			        	TermCrsOn();
			        	TermCrsBlock();
			        	StartTimerCall(&InactivityTimer,(TimeOut*60*100),
									   (void *)TimedOut, (int)pram);
			        	return(0);
			        }
			        else {
			        	StopTimer( &IntervalTimer );
			        	Scroll(4);
			        	StartTimerCall(&InactivityTimer,(TimeOut*60*100),
									   (void *)TimedOut, (int)pram);
			        	return(0);
			        }
		        }
	    	    else
	    	    if( ch == 'c' || ch == 'C' ) {
	    	    	ClearMainTrScrn();
	    	        StartTicks = RealTimeTicks();
					ElapsedTime=0;
                    StopTimer( &IntervalTimer );
					goto SHOWSCREEN;
	    	    }
			    ch = getch();
            } while( ch != -1 );

			RcvMessage(&TrRcvMBox);
		    StartTimer( &IntervalTimer, (25), &TrRcvMBox ); 
			ElapsedTime++;
		}
		ElapsedTime=0;
        StopTimer( &IntervalTimer );
	} while(  value > 0 );

	if( Term == VT100 ) {
		TermCrsOn();
	}
	return( 0 );

}

/******************************************************************************/
						/*	Start ShowBrgUDPFilter()  */
ShowBrgUDPFilter( CPB_P pcpb ) {

	uint i;
	uint bit;
	uint type;
	uint PortNum;
	
	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t\t%s\n\n\n", "USER SPECIFIED PROTOCOLS");

	printf("%-12s\t\t%-4s\t\t\t%-8s\t\t\n\n","INDEX","VALUE","NAME");
	for( i=0; i < MAXUSRTYPE; i++ )  {
		type = udpdir[i].UProtTyp;
		printf("%-12d\t\t",i+1);   
		if( type == 0 )
		    printf("    \t\t\t%-8s\t\t",  udpdir[i].UProtStr);
		else {
			bswap(&type);
		    printf("%-4x\t\t\t%-8s\t\t", type , udpdir[i].UProtStr);
		}

		for(bit=1, PortNum=1; bit <= MAXPORTBIT; bit <<= 1, PortNum++) {
			if( bit & udpdir[i].PrtSet )
				printf("%d ", PortNum);
		}
		putchar('\n');
	}
	pcpb->cl_idx = pcpb->cmdlen;
	Scroll(6);
	return(0);
}


/******************************************************************************/
								/*	Start Exit()  */
Exit()
{
	RAM_PIT *pram = &rampit;

	StopTimer(&InactivityTimer);
	ConsoleActive = FALSE;
	CloseTelnet();
	AdmConClose(0);
	Scroll(21);
	pram->mode = PASSWORDMODE;
	return (0);
}
/*	End Exit()  */

/******************************************************************************/
								/*	StartTelnetExit()  */
TelnetExit()
{
	RAM_PIT *pram = &rampit;

	StopTimer(&InactivityTimer);
	ConsoleActive = FALSE;
	Scroll(21);
	WaitForPassword();
	StartTimerCall(&InactivityTimer,(BridgeStatus->TimeOut*60*100),
				   (void *)TimedOut, (int)pram);
	return (0);
}
/*	End TelnetExit()  */

/******************************************************************************/
/*	Start MainStatusScreen()  */
MainStatusScreen()
{
	PRCCTL *prcctl = &prc;
	uint days, hours, mins;
	uint hr, mn, sec;
	uint day, mon, yr;
	int Prt4St;
	char *ipa;

	/* 
	printf ("%-21s %-10d", "Console Speed", sys.sys_baud);
	printf ("             ");
	*/
	if(GetDate(&day, &mon, &yr)) 
		printf ("%-21s %02d-%02d-%02d", "Date", 1, 1, 1991); /* bad date */
	else
		printf ("%-21s %02d-%02d-%02d", "Date", mon, day, yr); /* good date */

	printf ("                       ");

	printf("%-12s %-10s\n", "VT100Mode", 
		        BridgeStatus->TermType == VT100 ? "ENABLED" : "DISABLED");

	if(GetTime(&hr, &mn, &sec))
		printf ("%-21s %02d:%02d:%02d", "Time", 0, 0, 0); /* Bad Time */
	else
		printf ("%-21s %02d:%02d:%02d", "Time", hr, mn, sec); /* Good Time */

	printf ("                         ");

	printf ("%-12s %-10s\n", "STP Mode", (prcctl->Prc_StpMode == (byte)STP_MODE_ENABLE) ? ENABLESTRING : DISABLESTRING);

	GetUpTime(&days, &hours, &mins);
	printf ("%-21s %02d %-s %02d %-s %02d %-s", 
		   "Up Time", days,"days", hours,"hrs", mins, "mins");

	printf("           ");

	/* If Local Config is enabled then Auto Config is disabled */
	printf("%-12s %-10s\n", "Bootp", (eep_boot_rec.eep_LocalConfig ? DISABLESTRING : ENABLESTRING));
	
	/* Removed from the Ether/Ether bridge 
	printf ("%-12s %-10s\n", "Message Log", (BridgeStatus->Miscellaneous & MESSAGELOG) ? ENABLESTRING : DISABLESTRING);
    */

	ipa = (char *)GetEepIpAddr( MYIPADDR );
	if( ipa == 0L )
		printf ("%-21s %-15s", "IP Address", NA);
	else	
		printf ("%-21s %-15s", "IP Address", ipa);

	printf ("                  ");
	printf ("%-12s %-10s\n", "Symbolic", (BridgeStatus->Miscellaneous & SYMBOLIC) ? ENABLESTRING : DISABLESTRING);

	printf("%-21s %-15d", "Serial Number", eep_mfg_rec.eep_srlno);
	printf ("                  ");
	if(BridgeStatus->TimeOut == 0)
	    printf("%-12s %-10s\n", "TimeOut", DISABLESTRING);
	else
	    printf("%-12s %-2d mins\n", "TimeOut", BridgeStatus->TimeOut);

	printf("%-21s %-15s\n", "Software Version", APPLSOFTVERSION);
	printf("%-22s%d\n","Backplane Ring #",get_ring_number());
	Prt4St = Port4Status();
/******** Removed for FDDI-ENET 
	printf ("                  \n");
	printf("%-12s %-10s\n", "Ext Port", (Prt4St == ENABLE_THINET) ? "TRNSCVR" : "AUI");

    printf("%-21s %-15s", "Transceiver Module", PrintTransType());
********************************/
	Scroll(4);
	PortHeader();

	printf ("%-22s", "PortState");
	PrintPortState();
	putchar('\n');

	printf ("%-22s", LEARNING);
	PrintBitSetOrNot(&BridgeStatus->Learning, ENABLESTRING, DISABLESTRING);
	putchar ('\n');

	printf ("%-22s", PACKETSIZE);
	PrintBitSetOrNot(&BridgeStatus->PacketSize, EXTENDSTRING, STANDARDSTRING);


#ifdef THRESHHOLD
	printf ("%-22s", "Transmit Threshold");
	PrintThreshhold(BridgeStatus->TxThreshhold);
	putchar ('\n');

	printf ("%-22s", "Receive Threshold");
	PrintBitSetOrNot(&BridgeStatus->RxThreshhold, ENABLESTRING, DISABLESTRING);
#endif

	printf("\n\n%-22s", "Name:");
	printf("%s\n", BridgeStatus->Name);

	printf("%-22s", "Location:");
	printf("%s\n", BridgeStatus->Location);
}
/*	End MainStatusScreen()  */


/******************************************************************************/
/*	Start ProtocolStatusScreen()  */
void ProtocolStatusScreen()
{
    int PortNum;
    int RetVal1;  /* These two return values are used to format the output */
    int RetVal2;
    unsigned PortSelect = 1;

    for( PortNum=1; PortNum <=(ACTUALMAXPORT); PortNum++, PortSelect<<=1 ) {

         printf("\nPort %d: ",PortNum);
		 if( isPDProt( PortSelect ) || isUDProt( PortSelect )) {

                printf("%s\n", GetPFMode(PortSelect) );
                printf("        ");
         		RetVal1 = PrintPDProt( PortSelect );
        	    RetVal2 = PrintUDProt( PortSelect, RetVal1 );
		 }
		 else
             printf("None\n");
		
         putchar('\n');
    }
/*   UNCOMMENT WHEN USING 5 PORTS 
    printf("\nHSB:    ");
    printf("%s\n", GetPFMode(PortNum, PortSelect) );
    printf("        ");
    RetVal1 = PrintPDProt( PortSelect );
    RetVal2 = PrintUDProt( PortNum, RetVal1 );
    if( (RetVal1 == FALSE) && (RetVal2 == FALSE) )
             printf("None");
*/
    Scroll(5);
}
/*	End ProtocolStatusScreen()  */

/******************************************************************************/

					/*	Start STPStatusScreen()  */
void STPStatusScreen()
{
	int i;
	NID *PortNid;
	char *StrPtr;
	register PRCCTL *prcctl = &prc;
	uint StpMode = (uint)prcctl->Prc_StpMode;

	Header();
	printf ("\t\t\t\t\t\t%s\n\n", STPScreen);

	printf ("%-20s   %-5d", "Bridge's Priority",
			bridge_info.bridge_id.priority);

	printf ("            ");

	if( StpMode ) {
		printf ("%-20s    ", "Designated Root");
		PrintSymAdr(&bridge_info.designated_root.stp_address[0]);
		putchar('\n');
	}
	else
		printf ("%-20s    %-s\n", "Designated Root",NA);
		
	printf ("%-20s   %-8s", "STP Mode", (prcctl->Prc_StpMode == (byte)STP_MODE_ENABLE) ? ENABLESTRING : DISABLESTRING);

	printf ("         ");

	if( StpMode ) {
		printf ("%-20s    %d\n", "Root Path Cost", bridge_info.root_path_cost);
		printf("                                        ");
		printf ("%-20s    %s%d\n", "Direction To Root", "Port No. ", 
			bridge_info.root_port);
	}
	else {
		printf ("%-20s    %s\n", "Root Path Cost", NA);
		printf("                                        ");
		printf ("%-20s    %s\n", "Direction To Root", NA); 
	}

	putchar ('\n');

	printf ("%-16s", "Bridge Timer (secs)");
	printf ("                     ");
	printf ("%-16s", "Actual Timer (secs)");
	putchar ('\n');

	printf ("  ");
	printf ("%-18s   %-2d ", "Hello Time", bridge_info.bridge_hello_time);
	printf ("                 ");
	if( StpMode )
		printf ("%-18s   %-2d", "Root Hello Time", bridge_info.hello_time);
	else
		printf ("%-18s   %s", "Root Hello Time", NA);
	putchar ('\n');

	printf ("  ");
	printf ("%-18s   %-2d", "Info Lifetime", bridge_info.bridge_max_age);
	printf ("                  ");
	if( StpMode )
		printf ("%-18s   %d", "Root Info Lifetime", bridge_info.max_age);
	else
		printf ("%-18s   %s", "Root Info Lifetime", NA);
	putchar ('\n');

	printf ("  ");
	printf ("%-18s   %-2d", "Forward Delay", bridge_info.bridge_forward_delay);
	printf ("                  ");
	if( StpMode )
		printf ("%-18s   %d", "Root Forward Delay", bridge_info.forward_delay);
	else
		printf ("%-18s   %s", "Root Forward Delay", NA);
	putchar ('\n');

	putchar ('\n');

	STPPrintPortHeader();
	if( StpMode )
		printf ("%-14s%-10s   %-10s   %-10s   %-10s   \n",
				STATE,
				STPState(port_info[1].state),
				STPState(port_info[2].state),
				STPState(port_info[3].state),
				STPState(port_info[4].state));
			/*	STPState(port_info[5].state)); 5PORT -- Uncomment for 5 ports */
	else
		printf ("%-14s%-10s   %-10s   %-10s   %-10s   \n",
				STATE,
				NA,
				NA,
				NA,
				NA);
			/*	NA; 5PORT -- Uncomment for 5 ports */
		
	printf ("%-14s%-10d   %-10d   %-10d   %-10d   \n",
			PATHCOST,
			port_info[1].path_cost,
			port_info[2].path_cost,
			port_info[3].path_cost,
			port_info[4].path_cost);
/*			port_info[5].path_cost); 5PORT -- Uncomment for 5 ports */

	printf ("%-14s%-10d   %-10d   %-10d   %-10d   \n",
			PORTPRIORITY,
			port_info[1].port_id >> 8,
			port_info[2].port_id >> 8,
			port_info[3].port_id >> 8,
			port_info[4].port_id >> 8);
/*			port_info[5].port_id) >> 8; 5PORT -- Uncomment for 5 ports */

	printf ("%-14s", "Physical Addr");
	for( i = 0; i < ACTUALMAXPORT; i++) {
		PortNid = (NID *) MyNid( i ); 
		PrintSymAdr( (char *) PortNid );
		printf(" "); 
	}
	putchar('\n');

	printf ("Designated\n");

	printf ("%-14s", "  Bridge");
	if( StpMode )
		for (i = 1; i <= ACTUALMAXPORT; i++)
		{
			PrintSymAdr( &port_info[i].designated_bridge.stp_address[0] );
			printf(" ");
		}
	else
		for (i = 1; i <= ACTUALMAXPORT; i++)
		{
			printf ("%-12s ",
					NA);
		}
	putchar ('\n');

	if( StpMode )
		printf ("%-14s%-10d   %-10d   %-10d   %-10d\n",
				"  Priority",
				port_info[1].designated_bridge.priority,
				port_info[2].designated_bridge.priority,
				port_info[3].designated_bridge.priority,
				port_info[4].designated_bridge.priority);
   			/*	port_info[5].designated_bridge.priority); 5PORT -- Uncomment */
	else
		printf ("%-14s%-10s   %-10s   %-10s   %-10s\n",
				"  Priority",
				NA, NA, NA, NA );

	Scroll(3);
}
/*	End STPStatusScreen()  */

/******************************************************************************/
/* Start PktUtil() */
PktUtil()   {
	return( PACMON_PROG );
} 
/* End PktUtil() */

/******************************************************************************/
/* Start Tester() */
Tester()   {
    if(IsAdmConOpened(0) || IsTelnetActive() ){
        printf("\nTester can only be invoked directly from the console\n");
        return(0);
    }
    else{
       disable_stp(); /* disable stp first */
       return( TESTER_PROG );
    }
}
/* End Tester() */

/******************************************************************************/
/* Start Tftp() */
Tftp()   {

	return( TFTP_LOADER );
} 
/* End TFTP() */

/*******************************************************************************
**
**                     SHOW PORT SERVICE ROUTINES
**
*******************************************************************************/

ShowPortFilAddr( CPB_P pcpb ) {

	Header();
	Copyright();
	printf("\t\t\t\t\t\t\tADDRESS FILTERING STATUS\n\n\n");
	AddressStatusScreen();
	Scroll(11);
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowPortFilBitmask( CPB_P pcpb ) {

	Header();
	Scroll(1);
	BitmaskStatusScreen();
	pcpb->cl_idx = pcpb->cmdlen;
	Scroll(2);
	return(0);
}

/******************************************************************************/

ShowPortFilProt( CPB_P pcpb ) {

	Header();
	Copyright();
	printf("\t\t\t\t\t\t\t PROTOCOL FILTERING STATUS\n\n");
	ProtocolStatusScreen();
	Scroll(2);
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowPortLearn( CPB_P pcpb ) {

	PRCCTL *prcctl = &prc;
	Header();
	Scroll(4);
	PortHeader();
	printf ("%-22s", "Learning");
	PrintPrcBitSetOrNot(&prcctl->Prc_Learning, ENABLESTRING, DISABLESTRING);
	Scroll(17);
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowPortPacSize( CPB_P pcpb ) {
 
	PRCCTL *prcctl = &prc;
	Header();
	Scroll(4);
	PortHeader();
	printf ("%-22s", "Packet Size");
	PrintPrcBitSetOrNot(&prcctl->Prc_PacketSize,EXTENDSTRING,STANDARDSTRING);
	Scroll(17);
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowPortState( CPB_P pcpb ) {

	Header();
	Scroll(4);
	PortHeader();
	printf ("%-22s", "Port State");
	PrintPortState();
	Scroll(17);
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/
ShowPortStatus( CPB_P pcpb ) {


	uint length;
	uint PortMask;
	char *state;
	char *CmdLine;

	
	/* If no more parameters follow the 'status' command */
	if( pcpb->cl_idx >= pcpb->cmdlen ) {
		Header();
		Copyright();
		PortStatusScreen();
		Scroll(2);
	}
	else {

		length = 0;
		CmdLine = &pcpb->cmd[pcpb->cl_idx];

		/* Get the port list from the command line and store it */
		PortList( &CmdLine, &PortMask, &length );

		/* Adjust the command line pointer */
		pcpb->cl_idx += length;

		/* Print info for each port seperatly */
		PortInfo(&PortMask);
		Scroll(1);
	}
	return( 0 );
}

/******************************************************************************/

ShowPortThreshold( CPB_P pcpb ) {

	uint i;

	Header();
	Scroll(4);
	PortHeader();

	printf ("%-22s", TXTHRESHHOLD);
	PrintThreshhold(BridgeStatus->TxThreshhold);
	putchar('\n');

	printf ("%-22s",RXTHRESHHOLD);
	for( i = 1; i <= MAXPORTBIT; i <<= 1)
	    printf("%-11s", PortBitSetOrNot(&BridgeStatus->RxThreshhold, i,
		   "ENABLED", DISABLESTRING));
	Scroll(16);

	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}

/******************************************************************************/

ShowMemory(CPB_P lcpb)
{
        byte    *addr,*bp;
        int     i,j;
        char    *kw, dot;
        int     kw_sz;
        int     size,count;
	extern char *memory_parm[];

        kw_sz = pick_a_kw(&lcpb->cmd[lcpb->cl_idx],&kw,CASE_SENSITIVE);
        if( ! atoh(kw, &addr))
                return KW_UN_AMB;
        lcpb->cl_idx += kw_sz;
        if(lcpb->cl_idx >= lcpb->cmdlen)
        {
                size = 40;
                j = 0;
        }
        else
        {
                kw_sz = pick_a_kw(&lcpb->cmd[lcpb->cl_idx],&kw,CASE_SENSITIVE);
                if((j = chk_parm(kw,memory_parm)) == -1)
                        return(KW_UN_AMB);
                lcpb->cl_idx += kw_sz;
                if(lcpb->cl_idx >= lcpb->cmdlen)
                        size = (4 << j) * 10;
                else
                {
                        kw_sz = pick_a_kw(&lcpb->cmd[lcpb->cl_idx],&kw,CASE_SENSITIVE);

                        if( ! atoh(kw, &size))
                                return KW_UN_AMB;
                        lcpb->cl_idx += kw_sz;
                }
        }
        count = 4 << j;
        if(j == 0)
                addr = (byte *)((int)addr & ~3);
        else
                addr = (byte *)((int)addr & ~1);
        while(size >= 0)
        {
                printf("%8x: ",addr);
                bp = (byte *)addr;
                for(i = 0; i < count ; i++)
                {

                       switch(j)
                        {
                        case    0:
                                printf("%08x ",*(int *)addr);
                                addr += 4;
                                break;

                        case    1:
                                printf("%04x ",*(u_short *)addr);
                                addr += 2;
                                break;

                        case    2:
                                printf("%02x ",*(byte *)addr);
                                addr += 1;
                                break;
                        }
                }
                if(j == 2)
                {
                        printf("  ");
                        for(i = 0; i < count; i++,bp++)
                        {
                                if(*bp < 0x20 || *bp > 0x7f)
                                {
                                        dot = '.';
                                        printf("%c",dot);
                                }
                                else
                                        printf("%c",*bp);
                        }
                }
                size -= count;
                printf("\n");
        }
        printf("\n");
        return 0;
}

