/******************************************************************/
/* 		Copyright (c) 1990, Intel Corporation

   Intel hereby grants you permission to copy, modify, and 
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice 
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of 
   Intel Corporation not be used in advertising or publicity 
   pertaining to distribution of the software or the documentation 
   without specific, written prior permission.  

   Intel Corporation does not warrant, guarantee or make any 
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness, 
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own 
   risk.							  */
/******************************************************************/

/*****************************************************************************
 * $Id: evca_ibr.c,v 1.2 90/11/02 14:17:47 sherm Exp $
 *
 * This file defines the ibr, ROM (boot) prcb, and ROM (boot)
 * control table for the CADIC board.
 *
 * The file is #ifdef'd to produce EITHER the ibr OR the other two
 * data structures.  This is because:
 *
 *	(1) it is easier to link and build a ROM image with the GNU/960
 *	    tools if the data structures are in separate files, but
 *
 *	(2) the structures need to share a definition of the REGION F
 *	    bus configuration.
 *
 *****************************************************************************/

#include "bus.h"

extern unsigned long rom_fault_table[];
extern unsigned long int_stack[];
extern unsigned long rom_int_table[];
extern unsigned long * const rom_prcb[];
extern unsigned long sys_proc_table[];
extern int start();		/* Reset address */

#define NOMEM 	(BUS_WIDTH_8 | NWAD(8) | NRAD(8) | NXDA(1))

#define SRAM	(BUS_WIDTH_32 | NWDD(1) | NWAD(1) | PIPELINE_ENABLE | BURST_ENABLE)

#define DRAM	(BUS_WIDTH_32 | READY_ENABLE | BURST_ENABLE)

#define SHRAM	(BUS_WIDTH_32 | READY_ENABLE)

#define LANR	(BUS_WIDTH_16 | READY_ENABLE)

#define SCCTMR	(BUS_WIDTH_8 | NWAD(8) | NRAD(8) | NXDA(3))

#define PIO	(BUS_WIDTH_16 | NWAD(3) | NRAD(3) | NXDA(1))

#define ADMINMEM (BUS_WIDTH_8 | READY_ENABLE )

#define NVRAM	(BUS_WIDTH_8 | NWAD(6) | NRAD(6) | NXDA(1))

#define FEPROM	(BUS_WIDTH_8 | NWAD(6) | NRAD(6) | NXDA(1))

#define EPROM	(BUS_WIDTH_8 | NWAD(6) | NRAD(6) | NXDA(1))

#ifdef notdef
#define FDDIC	(BUS_WIDTH_8 | NWAD(14) | NXDA(3) | NRAD(14) | READY_ENABLE)
#endif
#define FDDIC	(BUS_WIDTH_8 | NXDA(3) | READY_ENABLE )
#define CAM		(BUS_WIDTH_16 | NWAD(12) | NXDA(3) | NRAD(4))


#define  REGION_0	NOMEM
#define  REGION_1	NOMEM
#define  REGION_2	SRAM
#define  REGION_3	DRAM
#define  REGION_4	DRAM
#define  REGION_5	SHRAM
#define  REGION_6	FDDIC
#define  REGION_7	LANR
#define  REGION_8	SCCTMR
#define  REGION_9	PIO
#define  REGION_A	ADMINMEM	
#define  REGION_B	NOMEM
#define  REGION_C	NVRAM
#define  REGION_D	CAM
#define  REGION_E	FEPROM
#define  REGION_F	EPROM


#ifdef PRCB

unsigned long
const
rom_control_table[] = {
	/* -- Group 0 -- Breakpoint Registers */
	0,		/* IPB0 IP Breakpoint Reg 0 */
	0,		/* IPB1 IP Breakpoint Reg 1 */
	0,		/* DAB0 Data Adr Bkpt Reg 0 */
	0,		/* DAB1 Data Adr Bkpt Reg 1 */
	
	/* -- Group 1 -- Interrupt Map Registers */
	0,		/* IMAP0 Interrupt Map Reg 0 */
	0,		/* IMAP1 Interrupt Map Reg 1 */
	0,		/* IMAP2 Interrupt Map Reg 2 */
	0xcffc,		/* ICON Reg (initially disabled) */

	/* -- Group 2 -- Bus Configuration Registers */
	REGION_0,	/* Region  0 */
	REGION_1,	/* Region  1 */
	REGION_2,	/* Region  2 */
	REGION_3,	/* Region  3 */
 	/* -- Group 3 -- */
	REGION_4,	/* Region  4 */
	REGION_5,	/* Region  5 */
	REGION_6,	/* Region  6 */
	REGION_7,	/* Region  7 */
 	/* -- Group 4 -- */
	REGION_8,	/* Region  8 */
	REGION_9,	/* Region  9 */
	REGION_A,	/* Region 10 */
	REGION_B,	/* Region 11 */
	/* -- Group 5 -- */
	REGION_C,	/* Region 12 */
	REGION_D,	/* Region 13 */
	REGION_E,	/* Region 14 */
	REGION_F,	/* Region 15 */

	/* -- Group 6 -- Breakpoint, Trace and Bus Control Registers */ 
	0,		/* BPCON (BreakPoint CONtrol)	*/
	0,		/* TC (Trace Control)		*/
	0,		/* Reserved			*/
	1		/* BCON (Bus CONtrol)		*/
};


unsigned long *
const
rom_prcb[] = {
	rom_fault_table,		/* Addr of fault table		*/
	(unsigned long*)rom_control_table,
					/* Addr of control_table (rom)	*/
	(unsigned long *)0x00001000,	/* AC reg mask overflow fault	*/
	(unsigned long *)0x00000001,	/* Flt - Mask Unaligned fault	*/
	rom_int_table,			/* Interrupt Table Address	*/
	sys_proc_table,			/* System Procedure Table	*/
	(unsigned long *)0,		/* Reserved			*/
	int_stack,			/* Interrupt Stack Pointer	*/
	(unsigned long *)0x00000000,	/* Inst.Cache - enable cache for now */
	(unsigned long *)10		/* Reg.Cache: 15 sets cached	*/
};


#else	/* not PRCB  */

/*****************************************************************************
 *
 *   Initialization Boot Record for 80960CA on EV80960CA board.
 *
 *   The initialization boot record must be loacated at address
 *   0xffffff00 by the linker.
 *
 *			+--+--+--+--+
 *	0xffffff00	|__|__|__|nn| --
 *			|__|__|__|nn|   | 4 bytes used in 960CA
 *			|__|__|__|nn|   |  bus configuration
 *			|__|__|__|nn| --   not used in chksum calc)
 *			+--+--+--+--+
 *	0xffffff10	| Instr Ptr |
 *			+-----------+
 *	0xffffff14	| PRCB Ptr  |
 *			+-----------+
 *	0xffffff18	|  Six      |
 *			|  32-bit   |
 *			|  checksum |
 *			|  words    |
 *			+-----------+
 *
 *****************************************************************************/
extern int cs6;
  
static
const
unsigned long
ibr[] = {
	BYTE_0(REGION_F),
	BYTE_1(REGION_F),
	BYTE_2(REGION_F),
	BYTE_3(REGION_F),
	(unsigned long) start,
	(unsigned long) rom_prcb,
	-2,			/* Checksum word #1 */
	0,			/* Checksum word #2 */
	0,			/* Checksum word #3 */
	0,			/* Checksum word #4 */
	0,			/* Checksum word #5 */
	(unsigned long) &cs6	/* Checksum word #6= -(start+rom_prcb)
				 *	(calculated @ link time)
				 */
};

#endif /* PRCB */
