/**			       
*
*	Program Name:	BOOTER
*
*	Filename:	flash.h
*
*	$Log:   /b/gregs/bridge/booter/main/flash.h_v  $
 * 
 *    Rev 1.0   16 Jul 1993 17:26:42   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:09:02   pvcs
 * Initial revision.
*
*	Creation Date:	3.28.91
*
*	Date:		9.16.91
*
*	Version:	1.1
*
*	Programmers:	K Kong
*
*	Modifications:	1.1	K Kong	9.16.91
*			The data bus is 16 bits.
*
*	Comments:	Some constants for the flash eproms
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#define FLASH_BANK_NO	2		/* 2 banks of flash */
#define	INTEL		0x89		/* manufacture code for intel	*/
#define	AMD		0x01		/* manufacture code for amd	*/
/*
 *	device type for inter flash
 */
#define	INTEL_256	0xB9		/* 32 k x 8			*/
#define	INTEL_512	0xB8		/* 64 k x 8			*/
#define	INTEL_1024	0xB4		/* 128 k x 8			*/
#define	INTEL_2048	0xBD		/* 256 k x 8			*/
/*
 *	device type for AMD flash
 */
#define	AMD_256		0xA1		/* 32 k x 8			*/
#define	AMD_512		0x25		/* 64 k x 8			*/
#define	AMD_1024	0xA7		/* 128 k x 8			*/
#define	AMD_2048	0x2A		/* 256 k x 8			*/


/*
 *	Command code for the flash
 *	for Single flash
 */
#define	SCMD_MANU_ID	0x90		/* read manufacturer's id	*/
#define	SCMD_RESET	0xff		/* reset the flash		*/
#define	SCMD_SET_READ	0x00		/* reset for read operations	*/


/*
 *	Command code for the flash
 *	for Multiple flashes (2)
 */

#define	MCMD_WRITE	0x4040	/* program command for the flash */
#define	MCMD_WRITE_STOP	0xc0c0	/* stop program command		*/
#define	MCMD_ERASE	0x2020	/* erase command		*/
#define	MCMD_ERASE_STOP	0xa0a0	/* stop erase command		*/
#define	MCMD_RESET	0xffff	/* reset the flash		*/
#define	MCMD_SET_READ	0x0000	/* reset for read operations	*/

/*
 *	Retries
 */
#define	MAX_RETRIES_WRITE	25	/* retry times for programming	*/
#define	MAX_RETRIES_ERASE_INTEL	3000	/* retry times for erase (intel)*/
#define	MAX_RETRIES_ERASE_AMD	1000	/* retry times for erase (amd)	*/

/*
 *	timeouts
 */
#define	TIME_WRITE		10	/* micro seconds		*/
#define	TIME_VERIFY		6	/* micro seconds		*/
#define	TIME_ERASE		10	/* 10 mini seconds		*/
/*
 *	If the flash eprom has been erased, the value of the content
 *	will be 0xffffffff
 */
#define	ERASED_PATTERN		0xff
/*
 *	These are the types of flash eprom we can support
 *	and number of different devices we can support right now 
 */
#define	NUM_DEVICES	4


/*
* record which follows an image written to the flash eprom
* this record has the name of the last image written,
* the date and time of the write, and the number of times the flash has been
* written. The time is in two formats.  the number of seconds since 1/1/70
* and the regular ascii date and time
*/
struct flash_info
	{
	char marker[8];		/* "FLASH   " */
	u_int checksum;		/* for compressed data plus this record   */
	int info_size;		/* size of this record  */
	int comp_size;		/* compressed size of data after this record */
				/* comp_size does not include this record */
	int decomp_size;	/* decompressed size of code */
	int burn_cycles;	/* number of times the flash has been burned */
	ulong seconds;		/* time of creation (unix style) */
	int load_type;		/* how the file is stored in the flash */
	int options;		/* currently not used */
	int flags;		/* currently not used */
	char copyright[64];	/* Copyright Notice */
	char board_name[32];	/* board name */
	char file_name[64];	/* ascii filename */
	char version[8];	/* ascii version */
	char burn_date[8];	/* ascii date */
	char burn_time[8];	/* ascii time */
	};

/*
* load_type definitions
*/
#define UNCOMPRESSED		1
#define UNIX_COMPRESSION	2

/*
* return and error codes for the compression routines
*/
#define OK          0           /* Result codes from functions:         */
#define NOMEM       2           /*   Ran out of memory                  */
#define TOKTOOBIG   3           /*   Token longer than MAXTOKLEN chars  */
#define READERR     4           /*   I/O error on input                 */
#define WRITEERR    5           /*   I/O error on output                */
#define INFILEBAD   6           /*   Infile not in compressed format    */
#define CODEBAD     7           /*   Infile contained a bad token code  */
#define TABLEBAD    8           /*   The tables got corrupted (!)       */
#define NOSAVING    9           /*   no saving in file size             */
#define NOTOPENED  10           /*   output file couldn't be opened     */

/*
* flash functions
*/
int open_flash(void);
int close_flash(void);
int erase_flash(void *, int, int);
int write_flash(byte *, byte);
