/**			       
*
*	Program Name:	nim960 bridge
*
*	Filename:	autoconf.c
*
*	Creation Date:	12.5.91
*
*	Date:		
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	The Bootp sequence in the booter.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>
#include <dips.h>
#include <eeprecs.h>
#include <led.h>
#include <netbuf.h>
#include <error.h>
#include <sys.h>
#include <tcpip.h>
#include <udp.h>
#include <tftpboot.h>
#include <tftp.h>
#include <bootp.h>

#define	MANUAL_COMFIG_TIMEOUT	1000	/* 10 seconds	*/
#define	CONFIG_RESET_TIMEOUT	30000	/* 5 minutes	*/

int UpdateImage(int mode);


static int	SameHubSlotId(void);
static int	ConsoleConfig(int src);
static void	CopyBootpInfo(void);
static int	BootpReqSend(EEP_BOOT *boot_rec);

/*
 *	The auto-configuration sequence
 */
UpdateImage(int FromTester)

	{
	int	BootpOK;
	int	mode;

#ifdef 0
	LoadEeprom();
#endif
	TftpInit();


	/* this sets up the programming of flash eprom. If the image is
	** to be downloaded from FLASH, this point is not reached. This
	** point is reached only if the flash is bad or the application
	** asks specifically to download the image from network.  */

	if((FromTester & UPDATE_FLASH) || (FromTester == LOAD_FROM_FLASH))
		FromTester = 1;
	else if(FromTester == 0)
		FromTester = 0;
		
BootpAgain:
	BootpOK = 0;

	set_leds(LED_BI, LED_RDY | LED_ACT, LED_RDY_GRN | LED_ACT_RED);
	if (!eep_boot_rec.eep_LocalConfig)
		{
		/*
		 *	We have to do a bootp request,
		 *	and save the record if bootp returns ok.
		 */
		BootpOK = BootpReqSend(&eep_boot_rec);
		}
	if (BootpOK || SameHubSlotId())
		{
		mode = TFTP_MODE_AUTO;
		tftpmain(mode, FromTester); 	/* This returns only if it fails */
		}
	else
		mode = TFTP_MODE_MANUAL;
	for (;;)
		{
		if (TRUE)  /* Always Do This */
			{
			if (!ConsoleConfig(FromTester))
				goto BootpAgain;
			}
		else
			{
			if (mode == TFTP_MODE_MANUAL)
				tftpmain(mode, FromTester);
			return;
			}
		tftpmain(TFTP_MODE_MANUAL, FromTester);
	}
	}
/*
 *	Check if I am in the same Hub and Slot as before.
 */
static int SameHubSlotId()
	{
	if (!IsStandalone())
		{
		if (GetHubID() != eep_boot_rec.eep_hubid || 
			GetSlotID() != eep_boot_rec.eep_slotid)
			{
			return 0;
			}
		}
	return 1;
	}
/*
 *	Ask the user if he/she wants to config. the module 
 *	manually or start the auto-config sequence again.
 *	If there is no response after 5 min., it times out and return.
 */
static int ConsoleConfig(int src)
	{
	int	ticks;	/*	for 5 minutes time out	*/
	int	PromptTicks;	/* for 10 seconds time out	*/
	int	ch;
	int	prompt = 1;

	ticks = RealTimeTicks();
	PromptTicks = ticks;
	for (;;)
		{
		if ((RealTimeTicks() - PromptTicks) > MANUAL_COMFIG_TIMEOUT)
			{
			prompt = 1;
			PromptTicks = RealTimeTicks();
			}
		if (prompt)
			{
#ifdef REM
			/* 
			** if the program in FLASH is corrupted this point is
			** is not reached.
			*/
			if(!(sys.sys_switch & DIP_TESTER))
				printf("\n\nError: The program in the flash prom is corrupted\n");
#endif

			printf("Do you want to tftp manually or Load from FLASH [f/y/n] ?\n"); 
			printf("[f] to download from FLASH\n");
			printf("[y] to jump to the manual tftp loader\n");
			printf("[n] to re-start the auto download sequence ==>");
			prompt = 0;
			}
		if ((RealTimeTicks() - ticks) > CONFIG_RESET_TIMEOUT)
			{
			printf("\nConsole prompt times out, auto download is re-started\n\n");
			return FALSE;
			}
		ch = getch();
		if (ch != -1)
			{
			putchar(ch);
			putchar('\n');
			if (ch == 'y' || ch == 'Y')
				return TRUE;
			if (ch == 'N' || ch == 'n')
				return FALSE;
			if (ch == 'F' || ch == 'f')
			{
				/*
				** load application from FLASH
				*/
				eep_boot_rec.eep_ThinNet = LOAD_FROM_FLASH;
				SaveEepBoot();
				load_application();
			}

			ticks = RealTimeTicks();
			PromptTicks = RealTimeTicks();
			prompt = 1;
			}
		ReSchedule();
		}
	}

/*
 *	copy info returned from bootp to my data structure and the
 *	eeprom.
 */
static void CopyBootpInfo()

	{
	int	i;

	_initp->in_me = bootpinfo.yiaddr;
	eep_boot_rec.eep_IP = _initp->in_me;
	eep_boot_rec.eep_ServerIP = bootpinfo.siaddr;
	eep_boot_rec.eep_BootpServer = bootpinfo.siaddr;
	eep_boot_rec.eep_NetMask = bootpinfo.NetMask;
	_initp->net_mask = bootpinfo.NetMask;
	for (i = 0;  i < BP_MAX_IP; i++)
		{
		if (bootpinfo.Router[i] != 0)
			eep_boot_rec.eep_RouterIP[i] = bootpinfo.Router[i];
		}
	if (bootpinfo.Router[0] != 0)
		_initp->net_gway = bootpinfo.Router[0];
	if (bootpinfo.Router[1] != 0)
		_initp->net_gway2 = bootpinfo.Router[1];
	strcpy(eep_boot_rec.eep_config_file, bootpinfo.file);
	eep_boot_rec.eep_OffsetGMT = bootpinfo.TimeOffset;
	eep_boot_rec.eep_TimeServer = bootpinfo.TimeServer[0];
	}

static int BootpReqSend(EEP_BOOT *boot_rec)

	{
	in_name	myip = _initp->in_me;
	int	ret;

	_initp->in_me = 0;
	printf("Sending BOOTP request file %s\n", 
		boot_rec->eep_request_file[0] == NULL ? "(NULL)" :
		boot_rec->eep_request_file);

	if (udpboot(0, 0, boot_rec->eep_request_file) != FALSE)
		{
		/*
		 *	We have a reply.
		 */
		printf("BOOTP reply received\n");
		CopyBootpInfo();
		ret = TRUE;
		}
	else
		{
		_initp->in_me = myip;
		printf("Warning: No response from BOOTP server\n");
		ret = FALSE;
		}
	return ret;
	}

TimeDelay10Ms(int counter)

	{
	unsigned ticks;

	ticks = RealTimeTicks();
	while((RealTimeTicks() - ticks) < counter)
		ReSchedule();
	}
