/**			       
*
*	Program Name:	nim960 bridge
*
*	Filename:	readconf.c
*
*	Creation Date:	12.3.91
*
*	Date:		
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	Get the configuration file and extract  
*			a line at a time and passes the line to
*			the parser.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <krnl.h>
#include <types.h>

static int	ConfRcvPacket();
static int	BufferGetline(char buffer[], char packet[], int length);

static int	(*ConfigHandler)();


/*----------------------------------------------------------------
	This function performs the system configuration through
	the a configuration file.  The configuration file name
	is determined with the BOOTP protocol.
  ----------------------------------------------------------------*/
readconfig(ip, filename, LineHandler)
in_name	ip;
char	*filename;
int	(*LineHandler)();

	{
	ConfigHandler = LineHandler;
	return TftpLoadFile(ip, filename, "netascii", ConfRcvPacket);
	}

/*----------------------------------------------------------------
	Function that handles the TFTP packet reception for the
	configuration file.
  ----------------------------------------------------------------*/
static ConfRcvPacket(int BlockNumber, char *Packet, int PacketLength)

	{
	static char	line[120];	/* a line from Packet	*/
	static char	*next = line;
	int	length;

	while (PacketLength > 0)
		{
		length = BufferGetline(next, Packet, PacketLength);
		PacketLength -= length;
		Packet += length;
		/*
		 *	Check if we have a whole line or not.
		 */
		if (strchr(next, '\n') != NULL)
			{
			(*ConfigHandler)(line);
			next = line;
			}
		else
			{
			/*
			 *	We have reached the end of
			 *	the buffer. We have to save
			 *	the partial line and get the rest
			 *	of the line from the next tftp packet.
			 */
			next = line + strlen(line);
			}
		}
	return TRUE;
	}

/*
 * name		BufferGetline
 *
 * synopsis	BufferGetline(buffer, packet, length)
 *		char	buffer[]; <<	extract a line and put it in here
 *		char	packet[]; <<	extract a line from here
 *		int	length; <<	of data in packet.
 *
 * description	It extracts a line from "packet" and puts it in
 *		"buffer". A line is a string which is terminated with
 *		the end of line termainator. the line terminator is a
 *		'\r', '\n' or "\r\n" sequence.
 *		The line returned in "buffer" is terminated with a '\n' and
 *		'\0' if a whole line has been extracted from "packet".
 *		If a partial line has been extracted, then the line returned
 *		in "buffer" is terminated with a '\0'.
 *
 * returns	number of bytes that have been extracted from "packet".
 *		Note: 	This is not the same as strlen(buffer) if the line 
 *			terminator(s) in "packet" is "\r\n".
 */

static BufferGetline(char buffer[], char packet[], int length)

	{
	int	c;
	char	*p = packet;

	/*
	 *	extract a line from the packet. A line can be 
 	 *	terminated by '\r', '\n', or '\r\n'.
	 */
	while (length-- > 0 && (c = *buffer++ = *packet++) != '\r' && c != '\n')
		{
		continue;
		}
	packet--;
	/*
	 *	terminate the line with a '\0'.
	 */
	*buffer = '\0';
	/*
	 *	If we see a '\r' and the following character is
	 *	'\n', then we extract '\n' from the "packet".
	 *	We will replace '\r' with a '\n'.
	 */
	if (c == '\r')
		{
		*(buffer - 1) = '\n';
		if (length >= 0 && *(packet + 1) == '\n')
			packet++;
		}
	return packet - p + 1;
	}

