/**			       
*
*	Program Name:	stanley - auto-config
*
*	Filename:	getload.c
*
*	Creation Date:	12.4.91
*
*	Date:		
*
*	Version:	1.0
*
*	Programmers:	K Kong
*
*	Modifications:
*
*	Comments:	It gets the image file name from the tftp server. 
*			The parser is based on the nindy user interface.
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#include <types.h>
#include <eeprecs.h>

extern	char *strrchr();

#define	MAXARGS		4

static struct cmd * lookup_cmd();
static int get_args(char *p, char *argv[], int max);
static int ExtractLoadFile();
static int ConfigLineParse();

getloadfile(in_name ip, char *file)

	{
	return readconfig(ip, file, ConfigLineParse);
	}

/************************************************************************
 * COMMAND TABLE
 *
 * The following table describes the keyboard commands.
 * The fields in each entry have the following meanings:
 *
 * cmd_name
 *	Name of keyword as a '\0'-terminated string.  Only the number of
 *	leading characters required for a match with user-entered input
 *	appear here,
 *
 * cmd_action
 *	Function that actually performs the command.  It should be
 *	invoked with the following arguments, in order:
 *		- the number of following arguments that are valid on
 *			this call.
 *		- one or more arguments, already parsed
 *			according to the corresponding cmd_argtypes.
 *
 * cmd_argtypes
 *	A '\0'-terminated list of characters describing the legal
 *	to the command.  The ascii version
 *	of each argument should be translated into the corresponding
 *	type before it is passed to the action function.  Valid types are:
 *
 *	D  The text should be a decimal constant.
 *
 *	I  The text should be a ip address.
 *
 *	S  The ASCII string should be passed unchanged to the action function.
 *
 ************************************************************************/
struct cmd
	{
	char *cmd_name;			/* command name */
	int (*cmd_action)();		/* command function */
	char cmd_argtypes[MAXARGS + 1];	/* up to MAXARGS */
	};

/*----------------------------------------------------------------
	Command function argument types.
  ----------------------------------------------------------------*/
union pargv 
	{
	char	chval;			/* char */
	int	intval;			/* integer */
	unsigned long longval;		/* long */
	in_name	ipval;			/* ip	*/
	char	*ptrval;		/* character pointer */
	};

static struct cmd	cmd_table[] = 
	{
		{"load", ExtractLoadFile, "S"},
		{0}
	};

/************************************************/
/* Look up a command in the command table	*/
/************************************************/
static
struct cmd *
lookup_cmd( cmd )
char *cmd;
{
struct cmd *cp;

	for ( cp = (struct cmd *)cmd_table; cp->cmd_name != NULL; cp++ ){
		if ( strcmp(cmd, cp->cmd_name) == 0 ){
			return cp;
		}
	}
	return NULL;
}

static int ConfigLineParse(char *linebuff)

	{
	struct cmd	*cp;
	union pargv	pargs[MAXARGS];
	char	*args[MAXARGS]; /* Pointers to the individual words in linebuff.
			 	* Each word is '\0'-terminated.
				*/
	int	nargs;		/* Number of meaningful entries in 'args' */
	char	*p;
	int	i;
	int	c;
	int	invalid_arg;

	/*
	 *	replace the line terminator '\n' with '\0'
	 */
	if ((p = strrchr(linebuff, '\n')) != NULL)
		*p = '\0';

	/* Break individual arguments out of command
	 */
	nargs = get_args(linebuff, args, 4);
	/*
	 *	check for comment line or empty line
	 */
	if (*args[0] == '#' || nargs == 0)
		{	
		return;
		}

	/* Check for valid command and number of arguments
	*/
	for ( p = args[0]; *p; p++ )
		{
        	if ( isupper(*p) )
			{
                        *p = tolower(*p);
                        }
                }
	/*
	 *	I don't understand the keyword.
	 */
 	if ( (cp = lookup_cmd(args[0])) == NULL )
		{
		return;
		}
	if ( nargs > ( i = strlen(cp->cmd_argtypes) + 1) )
		{
		/*
		 *	It is ok if the extra argument is the comment
		 */
		if (*args[i] != '#')
			return;
		else
			nargs = i;
		}

	/* Parse arguments according to types stored in command table
	 */
	p = cp->cmd_argtypes;
	invalid_arg = 0;
	for ( i = 1; i < nargs; i++, p++ )
		{
		switch ( *p )
			{
		case 'D':
			if (sscanf(args[i], "%d%c", &pargs[i].intval) != 1)
				{
				/*
				 *	The data is invalid.
				 */
				invalid_arg = 1;
				}
			break;

		case 'S':
			pargs[i].ptrval = args[i];
			break;

		case 'I':
			if ((pargs[i].ipval = inet_addr(args[i])) == -1)
				{
				/*
				 *	The ip address is invalid.
				 */
				invalid_arg = 1;
				}
			break;
		default:
			invalid_arg = 1;
			break;
			}	
		}
	/* Make sure all required arguments were present.
	 * If so, call action function.
	 */
	if (!invalid_arg && *p == NULL)
		{
		cp->cmd_action(pargs[1], args[2], pargs[3]);
		}
			
	}

/*----------------------------------------------------------------
	get_args breaks individual words out of a command.
	Synopsis:
		argc = get_args( p, argv, max);
	Parameters:
		p		pointer to space separated line.
		argv		array of pointers where to put the
				addreses of each of the argument values.
		max		maximum number of arguments to parse.

	On Return:
		argv		argv[0] is left pointing to first word
				in command (command name), argv[1]
				points to 2nd word (first argument),
				etc.  All argumnets are '\0'-terminated.
				Words are separated by whitespace.
				Unused entries in 'argv' are zeroed.
		argc 		Number of words in list.

  ----------------------------------------------------------------*/
static int get_args(p, argv, max )
char	*p;
char	*argv[];
int	max;

	{
        int	n;         /* Number of argv found */
	int	comment = FALSE;

        for ( n = 0; n < max; n++ )
		{
                argv[n] = NULL;
        	}

        n = 0;

        while ( *p != '\0')
		{
                /* Skip lead white space */
                while ( *p == ' ' || *p == '\t')
			{
                        p++;
                	}
		if ( *p == '"' )	/* treat this as one argument */
			{
	     		p++;
			comment = TRUE;
			}

                if ( *p == '\0' )
			{
                        break;
                	}

                if ( n++ < max )
			{
                        argv[n - 1] = p;
                	}

                /* Find end of word */
		if ( ! comment )
			{
	                while ( *p != ' ' && *p != '\t' && *p != '\0' )
				{
                	        p++;
                		}
			}
		else
	                while ( *p != '"' && *p != '\0' )
                	        p++;

                /* Terminate word */
                if ( *p != '\0' )
			{
                        *p++ = '\0';
                	}
        	}
        return n;
	} 

static int  ExtractLoadFile(char *file)

	{
	/*
	 *	save the load file if it is not the same as 
	 *	what we thought.
	 */
	if (strcmp(eep_boot_rec.eep_image_file, file) != 0)
		{
		strcpy(eep_boot_rec.eep_image_file, file);
		SaveEepBoot();
		}
	}





