100 DIM I.TAB%(512),I.BUF%(1920) '*Dimension tables
102 GOSUB 50000 		 '*Initialize P variables
899 END
50000 REM Initialize CXI interface variables	'!INIT - CXICAPI Rev 1.00
50001 RESTORE 50018				' Point to initial values
50002 READ I.CRD%,I.CWR%,I.CAC%,I.CCL%,I.CKY%	' Load command numbers
50003 READ I.CSP%,I.CXP%,I.CMD%,I.CTA%,I.CIM%
50004 READ I.MAX%,I.MTG%,I.MKY%,I.MXX%,I.MPR%	' Main status masks
50005 READ I.MCC%,I.MDI%,I.MCM%
50006 READ I.MXX%,I.MPO%,I.MAL%,I.MDD%,I.MCI%	' Aux status masks
50007 READ I.MRC%,I.MBC%,I.MCK%
50008 READ I.RG0%,I.RG1%,I.RG2%,I.RG3%		' Communication registers
50009 READ I.RST%,I.RAK%,I.RAF%
50010 READ I.MAT%,I.MBS%		       ' Handshake masks
50011 READ I.VER%,I.VST%,I.VRO%,I.VCL%,I.VMS%	' General variables
50012 READ I.VVL%,I.VFG%,I.VST$,I.VFL%,I.VT0%
50013 READ I.VT1%,I.VT2%,I.VT3%,I.VS0$,I.VS1$
50014 READ I.VAX%,I.VS2$,I.VS3$,I.VS4$,I.VS5$
50015 READ I.VS6$,I.VS7$,I.VS8$,I.VS9$,I.VT4%
50016 READ I.VT5%,I.VCB%,I.VCE%,I.VT8%,I.VT9%
50017 READ I.VOO%,I.VRR%,I.VFS%,I.VTO%
50018 DATA 0,1,2,3,4,5,6,7,8,9
50019 DATA 128,64,32,16,8,4,2,1
50020 DATA 128,64,32,16,8,4,2,1
50021 DATA &H220,&H221,&H222,&H223
50022 DATA &H226,&H227,&H227
50023 DATA 128,64
50024 DATA 0,0,0,0,0,0,0,"",0,0,0,0,0,"",""
50025 DATA 0,"","","","","","","","",0
50026 DATA 0,0,0,0,0,0,0,0,5
50027 DEF SEG
50028 BLOAD "CXICAPI.OVR",VARPTR(I.TAB%(0))
50030 REM Check whether PX in resident mode
50031 DEF SEG=0
50032 I.VT0%=PEEK(444)+256*PEEK(445)   'Calculate address of "CXI",offset
50034 I.VT1%=PEEK(446)+256*PEEK(447)   'Low address byte first, segment
50036 DEF SEG=I.VT1%
50037 I.VT3%=PEEK(I.VT0%-3)	       'To see whether "CXI" is there
50038 IF I.VT3%<>ASC("C") GOTO 50043   'PX is not resident
50039 I.VT4%=PEEK(I.VT0%-2)
50040 IF I.VT4%<>ASC("X") GOTO 50043
50041 I.VT5%=PEEK(I.VT0%-1)
50042 IF I.VT5%=ASC("I")  GOTO 50050
50043 PRINT "Control unit terminal program must be in resident mode "
50044 PRINT "before you can run these API subroutines."
50045 GOTO 899				'Terminate program execution
50050 REM Check PX version No., PX version No. must be 1.2 or later
50052 I.VT0%=14
50054 CALL CXIASM(I.VT1%,I.VT2%,I.VT0%)  'Get PX release No.
50056 IF I.VT2%< 257 THEN 50060 	  'Version 1.0 or 1.1
50059 GOSUB 58000: RETURN		 'Version 1.2 or later, to init status word
50060 I.VT0%=(I.VT2% AND &HFF)		  'In version 1.0 or earlier,Release No.
50061 I.VT1%=I.VT2%\&H100		  'In version 1.0 or earlier,Level No.
50062 I.VS0$=STR$(I.VT0%) : I.VS3$=MID$(I.VS0$,2,1)
50064 I.VS1$=STR$(I.VT1%) : I.VS4$=MID$(I.VS1$,2,1)
50066 I.VS2$="."
50068 PRINT "The PX version number is ";
50070 PRINT USING "!";I.VS3$;I.VS2$;I.VS4$
50072 PRINT "You have to use PX version 1.2 or later"
50073 PRINT "in order to use these subroutines."
50074 GOTO 899				'Terminate program execution
50100 REM Power_on_reset simulation
50101 I.VT0%=9
50102 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50120 I.VER%=0				'Reset error flag
50122 I.VT1%=1
50124 I.VT0%=0				'Configuration parameter is to remain unchanged
50126 I.VT9%=11
50130 CALL CXIASM(I.VT0%,I.VT2%,I.VT1%)  'Reset interface
50140 CALL CXIASM(I.VT0%,I.VT2%,I.VT9%)  'Update screen buffer
50150 I.VST%=I.VST% OR I.MCI%		  'Emulate IRMA's unit_reset_by_controller bit
50152 I.VST1%=I.VST%			  'Save I.VST% value
50190 RETURN
50200 REM Get slave status
50201 I.VT0%=9
50202 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50210 I.VER%=0				'Reset error flag
50212 I.VT6%=I.VST%			'Save original main status
50214 I.VT7%=I.VAX%			'Save original AUX status
50216 GOSUB 58000			'Get current status
50220 I.VT2%=I.VT7% XOR I.VAX%		'Check whether AUX status changed
50222 IF I.VT2% <> 0 THEN I.VST%=I.VST% OR I.MXX%  'Set AUX_status_change bit
50223 REM PX resets buffer_modified bit automatically, but IRMA does not
50224 I.VT2%=I.VST% AND I.MBC%		'Check buffer_modified bit
50226 I.VT3%=I.VT6% AND I.MBC%		'Check original buffer_modified bit
50230 IF (I.VT2%<>0) OR (I.VT3%<>0) THEN I.VST%=I.VST% OR I.MBC% 'To emulate IRMA
50233 REM IRMA does not reset buffer_modified bit automatically
50234 I.VT2%=I.VST% AND I.MCK%		'Check buffer_pointer bit
50236 I.VT3%=I.VT6% AND I.MCK%		'Check original buffer_pointer bit
50240 IF (I.VT2%<>0) OR (I.VT3%<>0) THEN I.VST%=I.VST% OR I.MCK%  'To emulate IRMA
50242 REM PX resets unit_reset_by_controller bit automatically, but IRMA does not
50244 I.VT2%=I.VST% AND I.MCI%		'Check unit_reset_by_controller bit
50246 I.VT3%=I.VT6% AND I.MCI%		'Check original unit_reset_by_controller bit
50248 IF (I.VT2%<>0) OR (I.VT3%<>0) THEN I.VST%=I.VST% OR I.MCI% 'To emulate IRMA
50249 REM IRMA does not reset trigger_occurred_bit automatically
50250 I.VT2%=I.VST% AND I.MPO%		'Check trigger_occurred bit
50251 I.VT3%=I.VT6% AND I.MPO%		'Check original trigger_occurred bit
50252 IF (I.VT2%<>0) OR (I.VT3%<>0) THEN I.VST%=I.VST% OR I.MPO% 'To emulate IRMA
50253 REM IRMA does not reset aux_status_changed bit automatically
50254 I.VT2%=I.VST% AND I.MXX%		'Check aux_status_changed bit
50255 I.VT3%=I.VT6% AND I.MXX%		'Check original aux_status_changed bit
50256 IF (I.VT2%<>0) OR (I.VT3%<>0) THEN I.VST%=I.VST% OR I.MXX% 'To emulate IRMA
50257 REM PX resets sound_alarm bit automatically
50258 IF (I.VAX1%<>1) OR ( (I.VT7% AND I.MAL%)=0) THEN 50260 'Sound alarm has not occurred
50259 I.VAX%=I.VAX% OR I.MAL%		'Set sound_alarm bit
50260 I.VAX1%=0 			'Reset sound_alarm flag
50264 I.VST1%=I.VST%			'Save I.VST%
50292 RETURN
50300 REM Reset slave status bits
50301 I.VT0%=9
50302 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50310 I.VER%=0				'Reset error flag
50312 I.VT0%=3
50314 CALL CXIASM(I.VT1%,I.VT2%,I.VT0%) 'To reset 3 bits in AH
50316 I.VT1% = not I.VST%		 'Get complement of I.VST%
50318 I.VST1% = I.VST1% and I.VT1%	  'Reset bits
50320 I.VST% =I.VST1%			  'Restore I.VST% after reset
50392 RETURN
50400 REM Set trigger event & address
50401 I.VT0%=9
50402 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50410 I.VER%=0				'Reset error flag
50416 I.VVL%=I.TAB%(I.VVL%+&H100)	'Translate buffer code to ASCII code
50420 IF (I.VRO%<0) OR (I.VRO%>24) THEN I.VER%=2  'Check row value
50422 IF (I.VCL%<1) OR (I.VCL%>80) THEN I.VER%=3  'Check column value
50423 IF I.VER%<>0 THEN RETURN		'Error if bad input
50424 IF ( (I.VVL% OR I.VMS%) AND &HFF00 ) <>0 THEN I.VER%=4 'Bad byte
50426 IF I.VER%<>0 THEN RETURN
50440 I.VAD%=(I.VCL%-1) + (I.VRO% * 80) 'Calculate buffer address for WTRIG
50482 RETURN
50500 REM WAIT FOR TRIGGER EVENT
50501 I.VT0%=9
50502 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50510 I.VER%=0				'Reset error flag
50511 I.VS0$ = TIME$			'Record current time
50512 I.VT3%=5
50514 IF I.VTO% <= 0 THEN  GOTO 50582	'Timeout
50520 I.VT1%=7
50530 I.VT2%=8
50531 CALL CXIASM(I.VTO%,I.VT8%,I.VT1%) 'Set timeout value
50532 CALL CXIASM(I.VAD%,I.VT9%,I.VT3%) 'Read char caught
50533 I.VT8% = I.VVL% XOR I.VT9%	'Compared with trigger value
50534 I.VT9% = I.VT8% AND I.VMS%	'Mask it
50535 IF I.VT9% = 0 THEN 50554		'The trigger waited
50536 CALL CXIASM(I.VAD%,I.VT8%,I.VT2%) 'Wait trigger
50540 IF I.VT8%<>0 THEN 50557		'Wait trigger failed
50542 CALL CXIASM(I.VAD%,I.VT9%,I.VT3%) 'Read char caught
50550 I.VT8% = I.VVL% XOR I.VT9%	'Compared with trigger value
50552 I.VT9% = I.VT8% AND I.VMS%	'Mask it
50553 IF I.VT9% <>0 THEN 50557		'Not the trigger waited
50554 I.VST% = I.VST% OR I.MPO% 	'Set trigger_occurred bit
50555 I.VST1%=I.VST%			 'Save I.VST% value
50556 RETURN				'All done
50557 I.VS1$ = TIME$			'Current time
50558 I.VS2$ = MID$(I.VS0$,4,2) 	'Original minute value
50560 I.VS3$ = MID$(I.VS1$,4,2) 	'Current minute value
50562 I.VT4% = VAL(I.VS2$)		'Convert to integer value
50564 I.VT5% = VAL(I.VS3$)		'Same as above
50566 I.VT8% = (I.VT5% - I.VT4%)* 60	'Seconds elapsed
50568 I.VS2$ = MID$(I.VS0$,7,2) 	'Original second value
50570 I.VS3$ = MID$(I.VS1$,7,2) 	'Current second value
50572 I.VT4% = VAL(I.VS2$)		'Convert to integer value
50574 I.VT5% = VAL(I.VS3$)		'Same as above
50575 I.VT8% = I.VT5% - I.VT4% + I.VT8% 'Seconds elapsed
50577 I.VTO% = I.VTO% - I.VT8%		'Seconds left
50578 IF I.VTO% <= 0 THEN  50582	'Timeout
50580 I.VS0$ = I.VS1$			'Save current time
50581 GOTO 50530			'Loop to wait trigger
50582 CALL CXIASM(I.VAD%,I.VT9%,I.VT3%) 'Read char caught
50583 I.VT8% = I.VVL% XOR I.VT9%	'Compared with trigger value
50584 I.VT9% = I.VT8% AND I.VMS%	'Mask it
50585 IF I.VT9% = 0 THEN 50554		'The trigger waited
50586 I.VER% = 10			' Waiting fails
50590 RETURN
50600 REM Send keystroke from I.VST$
50601 I.VT0%=9
50602 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50608 I.VT9%=LEN(I.VST$)		'String length
50610 I.VT3%=6
50616 FOR I.VT1%=1 TO I.VT9%		'Send char one by one
50618 I.VT8%=ASC(MID$(I.VST$,I.VT1%,1)) 'Get char ASCII value
50620 IF I.VT8% > 0 THEN 50630		'Not an extended code
50622 I.VT1% = I.VT1% + 1		'If I.VT8%=0 then next char is an extended code
50624 IF I.VT1% > I.VT9% THEN 50640	'Index out of bound
50626 I.VT8%=ASC(MID$(I.VST$,I.VT1%,1))+256 'Get extended ASCII value
50630 CALL CXIASM(I.VT8%,I.VT7%,I.VT3%) 'Send char
50640 NEXT
50642 I.VT3%=11
50644 CALL CXIASM(I.VT8%,I.VT7%,I.VT3%) 'Update screen buffer
50690 I.VER%=0
50692 RETURN
50700 REM Find field I.VFL%
50701 I.VER%=0				'Reset error flag
50702 I.VT0%=9
50703 CALL CXIASM(I.VT1%,I.VT2%,I.VT0%) 'Inhibit display
50704 IF (I.VFL%<1) OR (I.VFL%>1920) THEN I.VER%=7: RETURN 'Bad field No.
50705 I.VCB%=80 			'Initilization
50706 I.VCE%=80
50707 I.BUF%(0)=&HC0
50708 I.VFS%=0
50709 I.VRO%=1
50710 I.VCL%=1
50711 I.VT3%=5
50712 I.VT8%=&HC0C0			'Mask value, search value
50713 I.VT9%=&HE0C0			'Mask value, search value
50714 CALL CXIASM(I.VCB%,I.BUF%(0),I.VT3%) 'Read char at upper left corner
50715 REM If the upper left corner char is an attribute char
50716 REM whether this field is protected or unprotected
50717 REM If I.VFL=1, then all output variables will have initilization values
50718 IF (I.BUF%(0)>=&HC0) AND (I.VFL%=1) THEN I.BUF%(0)=&HC0: RETURN
50719 REM If the upper left corner char is not an attribute char
50720 REM whether this field is protected or unprotected
50721 REM If I.VFL=1, this field will regarded as first unprotected field
50722 REM all output variables, except I.VCE% and I.VFS%, will have initilization vales
50723 IF (I.BUF%(0)<&HC0) AND (I.VFL%=1) THEN I.BUF%(0)=&HC0: GOTO 50748
50724 REM The first real unprotected field can be found with I.VFL% = 2
50725 REM The first field is protected or char at upper left corner is a data char
50726 I.VT0%=2
50727 IF (I.BUF%(0)>=&HC0) AND ((I.BUF%(0) AND I.MKY%)=0) THEN	I.VT0%=3 'Field unprotected
50728 REM If the first field is unprotected and I.VFL%=2,the loop won't be executed at all
50729 FOR I.VT1%=I.VT0% TO I.VFL%
50730 I.VCE%=I.VCB%+1			'Increment pointer
50732 I.VT5%=18
50734 CALL CXIASM(I.VCE%,I.VT2%,I.VT5%): IF I.VT2%<>1 THEN 50790  'Set cursor position
50736 I.VT5%=33
50738 CALL CXIASM(I.VT9%,I.VCE%,I.VT5%) 'Masked search forward,next unprotected field
50742 IF (I.VCE% <= I.VCB% ) THEN I.VER%=7: RETURN 'PX can wrap around
50744 I.VCB%=I.VCE%			'Point to next unprotected field
50746 NEXT I.VT1%
50747 REM Now we reach (I.VFL-1)th  unprotected field
50748 I.VCE%=I.VCB%+1			'Increment pointer
50750 I.VT5%=18
50752 CALL CXIASM(I.VCE%,I.VT2%,I.VT5%): IF I.VT2%<>1 THEN GOTO 50790 'Set cursor position
50754 I.VT5%=33
50756 CALL CXIASM(I.VT8%,I.VCE%,I.VT5%) 'Masked search forward, next field
50764 IF (I.VCE% <= I.VCB% ) THEN I.VCE%=2000  'Last field may wrap arround
50766 I.VFS%= I.VCE%- I.VCB% - 1	'Field length
50768 IF I.VFL%>1 THEN I.VT2% = I.VCB%+1 ELSE I.VT2%=I.VCB%  'First data char
50770 IF (I.VT2% >= 2000) THEN I.VER%=7: RETURN 'First data char position out of range
50772 I.VRO% = I.VT2%\80		'Calculate row number
50774 I.VCL% = (I.VT2% MOD 80) + 1	'Calculate column number
50776 IF I.VFL%<>1 THEN CALL CXIASM(I.VCB%,I.BUF%(0),I.VT3%) 'Get attribute char
50789 RETURN
50790 IF (I.VT2%=0) THEN GOTO 50050
50791 IF (I.VT2%=2) THEN I.VER%=1:  RETURN
50792 IF (I.VT2%=4) THEN I.VER%=14: RETURN
50793 IF (I.VT2%=&H81) THEN I.VER%=15: RETURN
50800 REM Find next field I.VFL%+1
50801 I.VT0%=9
50802 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50803 I.VER%=0				'Reset error flag
50804 I.VFL%=I.VFL%+1			'Point to the next field
50806 IF I.VCE%<80 THEN I.VER%=11: RETURN 'Error
50808 IF I.VCE%>=2000 THEN I.VER%=7: RETURN 'Error
50809 I.VT3% = 5
50810 CALL CXIASM(I.VCE%,I.VT0%,I.VT3%) 'Get attribute char
50812 IF I.VT0%<&HC0 THEN I.VER%=11: RETURN 'Not an attribute, something wrong
50814 I.VT0%=I.VFL%
50816 I.VCB%=I.VCE%
50818 GOTO 50701			'Use FIND to find next field
50900 REM Read field
50901 I.VT0%=9
50902 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
50903 I.VER%=0				'Reset error flag
50904 I.VT2%=0
50905 I.VT3%=5
50906 IF I.VCB%=80 THEN 50930		'Special case of upper corner
50907 IF I.VCB%<80 THEN I.VER%=11: RETURN 'Error
50908 IF I.VCB%>=2000 THEN I.VER%=11: RETURN 'Error
50920 CALL CXIASM(I.VCB%,I.BUF%(0),I.VT3%)  'Get attribute char
50922 IF (I.BUF%(0) AND &HE0)<>&HC0 THEN I.VER%=5: RETURN 'Protected field
50924 GOTO 50940			'Skip special case
50930 I.VT2%=1				'Increment pointer to 1 as IRMA
50932 I.BUF%(0)=&HC0			'Set attribute char default value
50934 I.VT3%=38
50940 WHILE I.VT2%<=I.VFS%
50942 I.VT9%=I.VT2%+I.VCB%		'Read pointer
50944 IF I.VT9%>2000 THEN I.VER%=11: GOTO 50950 'skip out the loop
50946 CALL CXIASM(I.VT9%,I.VT8%,I.VT3%) 'Read untranslated char
50948 GOTO 50956
50950 I.VT2%=9999
50952 GOTO 50970
50956 I.BUF%(I.VT2%)=I.VT8%		'Put char in internal buffer
50962 I.VT2%=I.VT2%+1			'Increment read pointer
50970 WEND
50974 RETURN
51000 REM Write field
51001 I.VT0%=9
51002 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
51003 I.VER%=0				'Reset error flag
51004 I.VT3%=5
51005 IF I.VCB%<80 THEN I.VER%=11: RETURN 'Error
51006 IF I.VCB%>=2000 THEN I.VER%=11: RETURN 'Error
51008 IF I.VCB%+I.VFS%>2000 THEN I.VER%=12: RETURN 'Error
51010 CALL CXIASM(I.VCB%,I.VT0%,I.VT3%) 'Get attribute char to verify
51012 IF (I.VT0% AND &HFE)<>(I.BUF%(0) AND &HFE) THEN I.VER%=13: RETURN
51014 I.BUF%(0)=I.BUF%(0) OR 1		'Set modified_data_tag bit of attribute
51018 IF (I.BUF%(0) AND &H10)=0 THEN 51039 'Check whether numeric field
51020 I.VT2%=1				'If numeric field
51022 WHILE I.VT2%<=I.VFS%		'Check char one by one
51024 I.VT8%=I.BUF%(I.VT2%) AND &HFF	'Get data char
51026 IF (I.VT8%>=&H20) AND (I.VT8%<=&H29) THEN 51036 'Digit 0 - 9
51028 IF I.VT8%=&H31 THEN 51036 	' " - "
51030 IF I.VT8%=&H32 THEN 51036 	' " . "
51032 IF I.VT8%=&H35 THEN 51036 	' " + "
51034 I.VER%=6: I.VT2%=9999		'Not a numeric char
51036 I.VT2%=I.VT2%+1
51038 WEND
51039 IF I.VER%<>0 THEN RETURN		'Error
51042 I.VOO%=1				'Point to first data char
51043 REM PX function 19 needs a char string as input variable
51044 GOSUB 51100			'Convert buffer code to a char string
51050 I.VT2%=18
51052 CALL CXIASM(I.VCB%,I.VT1%,I.VT2%) 'Set write pointer
51054 IF I.VT1%=0 THEN I.VER%=1: RETURN  'Error
51056 IF I.VT1%=2 THEN I.VER%=1: RETURN  'Error
51058 IF I.VT1%=4 THEN I.VER%=11: RETURN 'Error
51060 I.VT2%=5
51062 CALL CXIASM(I.VCB%,I.VT1%,I.VT2%) 'Read attribute char
51066 I.VT1%=I.VT1% OR 1		'Set modified_data_tag bit
51068 I.VT2%=19
51070 CALL CXIASM(I.VT1%,I.VT0%,I.VT2%) 'Let PX know this field is modified
51071 I.VT0%=I.VCB%+1			'Point to first data char position
51072 I.VT2%=18
51073 CALL CXIASM(I.VT0%,I.VT1%,I.VT2%) 'Set write pointer
51074 IF I.VT1%=0 THEN I.VER%=1: RETURN  'Error
51075 IF I.VT1%=2 THEN I.VER%=1: RETURN  'Error
51076 IF I.VT1%=4 THEN I.VER%=11: RETURN 'Error
51077 I.VT2%=19
51078 FOR I.VT1%=1 TO LEN(I.VST$)
51079 I.VT8%=ASC(MID$(I.VST$,I.VT1%,1))  'Get ASCII value of each char in the string
51080 CALL CXIASM(I.VT8%,I.VT0%,I.VT2%) 'Write data char with echo
51081 NEXT
51085 REM PX function 19 sets buffer_modified bit, but IRMA subroutine WRFLD
51086 REM does not, we use function 3 to reset the bit.
51088 I.VT0%=3
51089 CALL CXIASM(I.VT1%,I.VT2%,I.VT0%)
51090 REM Record unit_reset_by_controller bit
51091 IF (I.VT2% AND &H800) <>0 THEN I.VST%=I.VST% OR I.MCI% : I.VST1%=I.VST%
51092 REM Record sound_alarm bit and set sound alarm flag
51094 IF (I.VT2% AND &H2000) <>0 THEN I.VAX%=I.VAX% OR I.MAL%: I.VAX1%=1
51097 RETURN
51100 REM Get String from PC internal buffer
51101 I.VT0%=9
51102 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
51103 I.VER%=0				'Reset error flag
51104 I.VT2%=0
51105 IF I.VOO%>1920 THEN I.VER%=12: RETURN 'Error
51110 IF I.VOO%<0 THEN I.VER%=12: RETURN 'Error
51112 I.VST$=""                         'Initilize output char string
51114 WHILE (I.VOO%<=I.VFS%) AND (I.VT2%=0) 'While read pointer not out of bound
51115 REM Convert buffer code to ASCII char, then concatenate char to string
51116 I.VST$=I.VST$+CHR$(I.TAB%((I.BUF%(I.VOO%) AND &HFF)+&H100))
51118 I.VOO%=I.VOO%+1			'Increment offset
51120 IF LEN(I.VST$)=254 THEN I.VT2%=1	'Maximun char string length allowed
51122 WEND
51192 RETURN
51200 REM Put string into PC internal buffer
51201 I.VT0%=9
51202 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
51203 I.VER%=0				'Reset error flag
51204 IF I.VOO%+LEN(I.VST$)-1>I.VFS% THEN I.VER%=12: RETURN 'Error
51206 I.VT3%=LEN(I.VST$)		'Get string length
51208 IF I.VT3%=0 THEN RETURN		'Zero length string, done already
51210 I.VT2%=0
51212 WHILE I.VT2%<I.VT3%		'Translate one by one
51214  I.VT0%=ASC(MID$(I.VST$,I.VT2%+1,1)) 'Get char ASCII value
51216  I.BUF%(I.VOO%+I.VT2%)=I.TAB%(I.VT0%) 'Translate ASCII to buffer code
51218  I.VT2%=I.VT2%+1			'Increment pointer
51220 WEND
51224 I.VOO%=I.VOO%+I.VT2%
51292 RETURN
51300 REM Read absolute screen (NOTE: Field attribute is translated too)
51301 REM RDABS can read protected or unprotected field.
51302 REM RDFLD can only read one unprotected field each time.
51305 I.VT0%=9
51308 CALL CXIASM(I.VT1%,I.VT2%,I.VT0%) 'Inhibit display
51314 I.VT0%=11
51318 CALL CXIASM(I.VT1%,I.VT2%,I.VT0%) 'Update screen buffer
51320 I.VER%=0				'Reset error flag
51322 I.VT3%=5
51324 I.VT0%=I.VRO%*80 + I.VCL% - 1	'Calculate buffer address
51326 IF I.VT0%<0 THEN I.VER%=11	'Illegal internal buffer pointer
51328 IF I.VT0%>=2000 THEN I.VER%=11	'Illegal internal buffer pointer
51330 IF I.VT0%+I.VRR%>2000 THEN I.VER%=12 'String is too long
51332 IF I.VER%<>0 THEN RETURN		'Error
51334 I.VT1%=I.VT0%+I.VRR%-1		'Last position to be read
51336 I.VST$=""                         'ASCII form of screen data
51338 I.VS0$=""                         'EAB data, we put 0 there
51340 FOR I.VT2%=I.VT0% TO I.VT1%	'Read one by one
51341	CALL CXIASM(I.VT2%,I.VT8%,I.VT3%) 'Get char
51342	I.VT9%=I.VT8% \ &H100		'EAB byte
51343	I.VT8%=I.VT8% AND &HFF		'Data byte
51344	REM If data char, we get ASCII value of the char
51345	REM Note: PCOXTABS 256H -- 511H is not a pure BUFFER code -> ASCII
51346	REM translation table.
51347	IF (I.VT8% < &HC0 ) THEN I.VST$=I.VST$+CHR$(I.TAB%(I.TAB%(I.VT8%)+&H100)): GOTO 51351
51349	REM If attrbute char, we get buffer code, it needs to be translated
51350	I.VST$=I.VST$+CHR$(I.TAB%(I.VT8%+&H100))
51351	I.VS0$=I.VS0$+CHR$(I.VT9%)	'EAB data string
51352 NEXT I.VT2%
51354 I.VRO%=(I.VT1%+1)\80		'New row position
51356 I.VCL%=((I.VT1%+1) MOD 80) + 1	'New column position
51392 RETURN
51400 REM Read cursor position
51401 I.VT0%=9
51402 CALL CXIASM(I.VT9%,I.VT8%,I.VT0%) 'Inhibit display
51422 I.VER%=0				'Reset error flag
51424 I.VT3%=4
51430 CALL CXIASM(I.VT0%,I.VT1%,I.VT3%) 'Read cursor position
51432 I.VRO%=I.VT1%\80			'Calculate row position
51434 I.VCL%=(I.VT1% MOD 80) + 1	'Calculate column position
51482 RETURN
58000 REM Get slave status
58010 I.VER%=0			'Reset error flag
58012 I.VT3%=3
58014 I.VT0%=0
58016 CALL CXIASM(I.VT0%,I.VT1%,I.VT3%) 'Get status
58020 I.VT8%=I.VT1% AND &HFF	'Low byte
58022 I.VT9%=I.VT1% \ &H100	'High byte
58024 I.VST%=&H0		'Initilize status word
58025 I.VST1%=&H0
58026 I.VAX%=&H0
58030 I.VT0%=I.VT8% AND I.MCK% 	'Cursor blinking or not
58032 I.VT0%=I.VT0% * 2		'Shift to left by one bit
58034 I.VT1%=I.VT8% AND I.MBC% 	'Cursor reversed or not
58036 I.VT1%=I.VT1% * 2		'Shift to left by one bit
58038 I.VT2%=I.VT8% AND I.MRC% 	'Cursor inhibited or not
58040 I.VT2%=I.VT2% * 2		'Shift to left by one bit
58042 I.VT3%=I.VT8% AND I.MCI% 	'Display inhibited or not
58044 I.VT3%=I.VT3% * 2		'Shift
58052 I.VAX%=I.VAX% OR I.VT0%	'Record cursor_blink bit
58054 I.VAX%=I.VAX% OR I.VT1%	'Record reversed_cursor bit
58056 I.VAX%=I.VAX% OR I.VT2%	'Record cursor_inhibit bit
58057 I.VAX%=I.VAX% OR I.VT3%	'Record display_inhibit bit
58058 I.VT3%=I.VT9% AND I.MCI% 	'Get unit_reset_by_controller bit
58060 I.VT4%=I.VT9% AND I.MDD% 	'Get buffer_modified bit
58062 I.VT4%=I.VT4% / 8		'Right shift by 3 bits
58063 REM To emulate IRMA buffer_pointer bit
58064 I.VT0%=I.VT4% / 2		'Get buffer_pointer bit
58066 I.VT5%=I.VT9% AND I.MAL% 	'Get sound_alarm bit
58068 I.VAX%=I.VAX% OR I.VT5%	'Record sound_alarm bit
58070 I.VST%=I.VST% OR I.VT3%	'Record unit_reset_by_controller bit
58072 I.VST%=I.VST% OR I.VT4%	'Record buffer_modified bit
58074 I.VST%=I.VST% OR I.VT0%	'Record buffer_pointer bit
58076 I.VST1%=I.VST%		'Save I.VST% value
58092 RETURN
