;
; REGISTER B   = CURRENT LIGHT CONTENTS
; REGISTER C   = SWITCH DEBOUNCE INDICATOR
;                (HAVE SWITCHES CHANGED SINCE LAST LIGHT SHIFT)
;                 0 = NO, HAVE NOT CHANGED, CHANGES WILL BE RECOGNIZED
;                 1 = YES, ONE CHG OCCURED, FURTHER CHANGES IGNORED
; REGISTER D   = LAST SWITCH SETTING
; REGISTER E   = CURRENT SWITCH SETTING
; REGISTER H,L = DELAY COUNTER
; REGISTER SP  = DELAY COUNTER INCREMENT
;
        ORG     0
;
START:  XRA     A               ;A=0
        MOV     H,A             ;SET DELAY COUNTER TO ZERO
        IN      0FFH            ;READ THE SWITCHES
        MOV     L,A             ;SAVE THE INCREMENT VALUE AS INITIAL VALUE
        SPHL                    ;SAVE THE INCREMENT IN SP
;
; SEE IF SWITCHES HAVE CHANGED SINCE LAST LIGHT SHIFT (BASED ON FLAG IN C)
;
; ONLY ONCE SWITCH CHANGE (THE FIRST) PER LIGHT SHIFT IS RECOGNIZED, 
; FURTHER SWITCH CHANGES ARE IGNORED
;
LOOP:   XRA     A               ;A=0
        ADD     C               ;A=C, THE DEBOUNCE FLAG
        JNZ     TESTROT         ;DEBOUNCING, IGNORE SW CHGS, TEST FOR ROTATE
;
; SWITCHES HAVE NOT CHANGED SINCE LAST LIGHT SHIFT,  GET THE SWITCH VALUE
; AND SEE IF THEY HAVE CHANGED
;
GETSW:  MOV     D,E             ;LAST SWITCH SETTING = CURRENT SWITCH SETTING
        IN      0FFH            ;READ SWITCHES
        MOV     E,A             ;NEW CURRENT SWITCH SETTING
        XRA     D               ;IS NEW SAME AS LAST ?
        JNZ     CHANGED         ;NO, SWITCHES HAVE CHANGED
;
; SWITCHE CHGS BEING IGNORED, SEE IF IT'S TIME TO ROTATE THE LIGHTS
;
TESTROT:DAD     SP              ;ADD INCREMENT IN SP TO COUNTER IN H,L
        JNC     LOOP            ;DID THE COUNTER OVERFLOW ?
;
; IT'S TIME TO SHIFT THE LIGHTS LEFT
;
ROTATE: MOV     A,B             ;GET THE LIGHT PATTERN
        RLC                     ;SHIFT IT LEFT
        MOV     B,A             ;SAVE IT AS THE NEW LIGHT PATTERN
        OUT     0FFH            ;WRITE THE LIGHTS
        XRA     A               ;GET A ZERO
        MOV     C,A             ;SHOW NO SWITCH CHGS SINCE LAST SHIFT
        JMP     LOOP            ;CONTINUE
;
;THE SWITCHES HAVE CHANGED, REVISE THE DISPLAY AND CONTINUE
;
CHANGED:XRA     B               ;FORM THE NEW DISPLAY
        MOV     B,A             ;SAVE IT
        OUT     0FFH            ;WRITE IT TO THE LIGHTS
        XRA     A               ;NOW A=0
        MOV     H,A             ;CLEAR DELAY COUNTER
        CMA                     ;NOW A=0FFH
        MOV     C,A             ;SHOW THAT SWITCHES JUST CHANGED
        JMP     LOOP            ;GO TO DEBOUNCE LOOP
;
        END     START
