/*
 * Definitions for Printing VERSION 3 NUMBER 4.
 */
#ifndef __Printing3
#define __Printing3
#include <xnscourier/courier.h>
#include <xnscourier/courierconnection.h>


/*
 * Definitions from DEPENDS UPON BulkData inclusion
 * (must be linked with BulkData1_support.c also)
 */
#include <xnscourier/BulkData1.h>

/*
 * Definitions from DEPENDS UPON Authentication inclusion
 * (must be linked with Authentication1_support.c also)
 */
#include <xnscourier/Authentication1.h>

/*
 * Definitions from DEPENDS UPON Time inclusion
 * (must be linked with Time2_support.c also)
 */
#include <xnscourier/Time2.h>
typedef LongCardinal Printing3_Time;
#define sizeof_Printing3_Time sizeof_LongCardinal
#define clear_Printing3_Time clear_LongCardinal
#define externalize_Printing3_Time externalize_LongCardinal
#define internalize_Printing3_Time internalize_LongCardinal


typedef Unspecified Printing3_RequestID[5];

#define sizeof_Printing3_RequestID(p) 5

#define clear_Printing3_RequestID(p)

typedef enum {
	Printing3_printObjectName = 0,
	Printing3_printObjectCreateDate = 1,
	Printing3_senderName = 2
} T_d4_3_9;
#define sizeof_T_d4_3_9 sizeof_enumeration
#define clear_T_d4_3_9 clear_enumeration
#define externalize_T_d4_3_9 externalize_enumeration
#define internalize_T_d4_3_9 internalize_enumeration


extern struct Printing3_T_s4_3_11;
typedef struct Printing3_T_s4_3_11 Printing3_T_s4_3_11;

struct Printing3_T_s4_3_11 {
	T_d4_3_9 designator;
	union {
		String u_Printing3_printObjectName;
#define Printing3_printObjectName_case u.u_Printing3_printObjectName
		LongCardinal u_Printing3_printObjectCreateDate;
#define Printing3_printObjectCreateDate_case u.u_Printing3_printObjectCreateDate
		String u_Printing3_senderName;
#define Printing3_senderName_case u.u_Printing3_senderName
	} u;
};

typedef struct {
	Cardinal length;
	Printing3_T_s4_3_11 *sequence;
} Printing3_PrintAttributes;

typedef enum {
	Printing3_unknown = 0,
	Printing3_knownSize = 1,
	Printing3_otherSize = 2
} T_d4_3_12;
#define sizeof_T_d4_3_12 sizeof_enumeration
#define clear_T_d4_3_12 clear_enumeration
#define externalize_T_d4_3_12 externalize_enumeration
#define internalize_T_d4_3_12 internalize_enumeration


extern struct Printing3_Paper;
typedef struct Printing3_Paper Printing3_Paper;

typedef enum {
	Printing3_usLetter = 1,
	Printing3_usLegal = 2,
	Printing3_a0 = 3,
	Printing3_a1 = 4,
	Printing3_a2 = 5,
	Printing3_a3 = 6,
	Printing3_a4 = 7,
	Printing3_a5 = 8,
	Printing3_a6 = 9,
	Printing3_a7 = 10,
	Printing3_a8 = 11,
	Printing3_a9 = 12,
	Printing3_a10 = 35,
	Printing3_isoB0 = 13,
	Printing3_isoB1 = 14,
	Printing3_isoB2 = 15,
	Printing3_isoB3 = 16,
	Printing3_isoB4 = 17,
	Printing3_isoB5 = 18,
	Printing3_isoB6 = 19,
	Printing3_isoB7 = 20,
	Printing3_isoB8 = 21,
	Printing3_isoB9 = 22,
	Printing3_isoB10 = 23,
	Printing3_jisB0 = 24,
	Printing3_jisB1 = 25,
	Printing3_jisB2 = 26,
	Printing3_jisB3 = 27,
	Printing3_jisB4 = 28,
	Printing3_jisB5 = 29,
	Printing3_jisB6 = 30,
	Printing3_jisB7 = 31,
	Printing3_jisB8 = 32,
	Printing3_jisB9 = 33,
	Printing3_jisB10 = 34
} Printing3_T_c4_3_14;
#define sizeof_Printing3_T_c4_3_14 sizeof_enumeration
#define clear_Printing3_T_c4_3_14 clear_enumeration
#define externalize_Printing3_T_c4_3_14 externalize_enumeration
#define internalize_Printing3_T_c4_3_14 internalize_enumeration


typedef struct {
	Cardinal width;
	Cardinal length;
} Printing3_T_c4_3_15;

#define sizeof_Printing3_T_c4_3_15(p) 2

#define clear_Printing3_T_c4_3_15(p)

struct Printing3_Paper {
	T_d4_3_12 designator;
	union {
		NilRecord u_Printing3_unknown;
#define Printing3_unknown_case u.u_Printing3_unknown
		Printing3_T_c4_3_14 u_Printing3_knownSize;
#define Printing3_knownSize_case u.u_Printing3_knownSize
		Printing3_T_c4_3_15 u_Printing3_otherSize;
#define Printing3_otherSize_case u.u_Printing3_otherSize
	} u;
};

typedef enum {
	Printing3_paper = 0
} T_d4_3_16;
#define sizeof_T_d4_3_16 sizeof_enumeration
#define clear_T_d4_3_16 clear_enumeration
#define externalize_T_d4_3_16 externalize_enumeration
#define internalize_T_d4_3_16 internalize_enumeration


extern struct Printing3_Medium;
typedef struct Printing3_Medium Printing3_Medium;

struct Printing3_Medium {
	T_d4_3_16 designator;
	union {
		Printing3_Paper u_Printing3_paper;
#define Printing3_paper_case u.u_Printing3_paper
	} u;
};

typedef struct {
	Cardinal length;
	Printing3_Medium *sequence;
} Printing3_Media;

typedef enum {
	Printing3_printObjectSize = 0,
	Printing3_recipientName = 1,
	Printing3_message = 2,
	Printing3_copyCount = 3,
	Printing3_pagesToPrint = 4,
	Printing3_mediumHint = 5,
	Printing3_priorityHint = 6,
	Printing3_releaseKey = 7,
	Printing3_staple = 8,
	Printing3_twoSided = 9
} T_d4_3_18;
#define sizeof_T_d4_3_18 sizeof_enumeration
#define clear_T_d4_3_18 clear_enumeration
#define externalize_T_d4_3_18 externalize_enumeration
#define internalize_T_d4_3_18 internalize_enumeration


extern struct Printing3_T_s4_3_20;
typedef struct Printing3_T_s4_3_20 Printing3_T_s4_3_20;

typedef struct {
	Cardinal beginningPageNumber;
	Cardinal endingPageNumber;
} Printing3_T_c4_3_21;

#define sizeof_Printing3_T_c4_3_21(p) 2

#define clear_Printing3_T_c4_3_21(p)

typedef enum {
	Printing3_low = 0,
	Printing3_normal = 1,
	Printing3_high = 2
} Printing3_T_c4_3_22;
#define sizeof_Printing3_T_c4_3_22 sizeof_enumeration
#define clear_Printing3_T_c4_3_22 clear_enumeration
#define externalize_Printing3_T_c4_3_22 externalize_enumeration
#define internalize_Printing3_T_c4_3_22 internalize_enumeration


struct Printing3_T_s4_3_20 {
	T_d4_3_18 designator;
	union {
		LongCardinal u_Printing3_printObjectSize;
#define Printing3_printObjectSize_case u.u_Printing3_printObjectSize
		String u_Printing3_recipientName;
#define Printing3_recipientName_case u.u_Printing3_recipientName
		String u_Printing3_message;
#define Printing3_message_case u.u_Printing3_message
		Cardinal u_Printing3_copyCount;
#define Printing3_copyCount_case u.u_Printing3_copyCount
		Printing3_T_c4_3_21 u_Printing3_pagesToPrint;
#define Printing3_pagesToPrint_case u.u_Printing3_pagesToPrint
		Printing3_Medium u_Printing3_mediumHint;
#define Printing3_mediumHint_case u.u_Printing3_mediumHint
		Printing3_T_c4_3_22 u_Printing3_priorityHint;
#define Printing3_priorityHint_case u.u_Printing3_priorityHint
		Cardinal u_Printing3_releaseKey;
#define Printing3_releaseKey_case u.u_Printing3_releaseKey
		Boolean u_Printing3_staple;
#define Printing3_staple_case u.u_Printing3_staple
		Boolean u_Printing3_twoSided;
#define Printing3_twoSided_case u.u_Printing3_twoSided
	} u;
};

typedef struct {
	Cardinal length;
	Printing3_T_s4_3_20 *sequence;
} Printing3_PrintOptions;

typedef enum {
	Printing3_ppmedia = 0,
	Printing3_ppstaple = 1,
	Printing3_pptwoSided = 2
} T_d4_3_23;
#define sizeof_T_d4_3_23 sizeof_enumeration
#define clear_T_d4_3_23 clear_enumeration
#define externalize_T_d4_3_23 externalize_enumeration
#define internalize_T_d4_3_23 internalize_enumeration


extern struct Printing3_T_s4_3_25;
typedef struct Printing3_T_s4_3_25 Printing3_T_s4_3_25;

struct Printing3_T_s4_3_25 {
	T_d4_3_23 designator;
	union {
		Printing3_Media u_Printing3_ppmedia;
#define Printing3_ppmedia_case u.u_Printing3_ppmedia
		Boolean u_Printing3_ppstaple;
#define Printing3_ppstaple_case u.u_Printing3_ppstaple
		Boolean u_Printing3_pptwoSided;
#define Printing3_pptwoSided_case u.u_Printing3_pptwoSided
	} u;
};

typedef struct {
	Cardinal length;
	Printing3_T_s4_3_25 *sequence;
} Printing3_PrinterProperties;

typedef enum {
	Printing3_spooler = 0,
	Printing3_formatter = 1,
	Printing3_printer = 2,
	Printing3_media = 3
} T_d4_3_32;
#define sizeof_T_d4_3_32 sizeof_enumeration
#define clear_T_d4_3_32 clear_enumeration
#define externalize_T_d4_3_32 externalize_enumeration
#define internalize_T_d4_3_32 internalize_enumeration


extern struct Printing3_T_s4_3_34;
typedef struct Printing3_T_s4_3_34 Printing3_T_s4_3_34;

typedef enum {
	Printing3_available = 0,
	Printing3_busy = 1,
	Printing3_disabled = 2,
	Printing3_full = 3
} Printing3_T_c4_3_35;
#define sizeof_Printing3_T_c4_3_35 sizeof_enumeration
#define clear_Printing3_T_c4_3_35 clear_enumeration
#define externalize_Printing3_T_c4_3_35 externalize_enumeration
#define internalize_Printing3_T_c4_3_35 internalize_enumeration


typedef enum {
	Printing3_available4_3_26 = 0,
	Printing3_busy4_3_27 = 1,
	Printing3_disabled4_3_28 = 2
} Printing3_T_c4_3_36;
#define sizeof_Printing3_T_c4_3_36 sizeof_enumeration
#define clear_Printing3_T_c4_3_36 clear_enumeration
#define externalize_Printing3_T_c4_3_36 externalize_enumeration
#define internalize_Printing3_T_c4_3_36 internalize_enumeration


typedef enum {
	Printing3_available4_3_29 = 0,
	Printing3_busy4_3_30 = 1,
	Printing3_disabled4_3_31 = 2,
	Printing3_needsAttention = 3,
	Printing3_needsKeyOperator = 4
} Printing3_T_c4_3_37;
#define sizeof_Printing3_T_c4_3_37 sizeof_enumeration
#define clear_Printing3_T_c4_3_37 clear_enumeration
#define externalize_Printing3_T_c4_3_37 externalize_enumeration
#define internalize_Printing3_T_c4_3_37 internalize_enumeration


struct Printing3_T_s4_3_34 {
	T_d4_3_32 designator;
	union {
		Printing3_T_c4_3_35 u_Printing3_spooler;
#define Printing3_spooler_case u.u_Printing3_spooler
		Printing3_T_c4_3_36 u_Printing3_formatter;
#define Printing3_formatter_case u.u_Printing3_formatter
		Printing3_T_c4_3_37 u_Printing3_printer;
#define Printing3_printer_case u.u_Printing3_printer
		Printing3_Media u_Printing3_media;
#define Printing3_media_case u.u_Printing3_media
	} u;
};

typedef struct {
	Cardinal length;
	Printing3_T_s4_3_34 *sequence;
} Printing3_PrinterStatus;

typedef enum {
	Printing3_status = 0,
	Printing3_statusMessage = 1
} T_d4_3_39;
#define sizeof_T_d4_3_39 sizeof_enumeration
#define clear_T_d4_3_39 clear_enumeration
#define externalize_T_d4_3_39 externalize_enumeration
#define internalize_T_d4_3_39 internalize_enumeration


extern struct Printing3_T_s4_3_41;
typedef struct Printing3_T_s4_3_41 Printing3_T_s4_3_41;

typedef enum {
	Printing3_pending = 0,
	Printing3_inProgress = 1,
	Printing3_completed = 2,
	Printing3_completedWithWarning = 3,
	Printing3_unknown4_3_38 = 4,
	Printing3_rejected = 5,
	Printing3_aborted = 6,
	Printing3_canceled = 7,
	Printing3_held = 8
} Printing3_T_c4_3_42;
#define sizeof_Printing3_T_c4_3_42 sizeof_enumeration
#define clear_Printing3_T_c4_3_42 clear_enumeration
#define externalize_Printing3_T_c4_3_42 externalize_enumeration
#define internalize_Printing3_T_c4_3_42 internalize_enumeration


struct Printing3_T_s4_3_41 {
	T_d4_3_39 designator;
	union {
		Printing3_T_c4_3_42 u_Printing3_status;
#define Printing3_status_case u.u_Printing3_status
		String u_Printing3_statusMessage;
#define Printing3_statusMessage_case u.u_Printing3_statusMessage
	} u;
};

typedef struct {
	Cardinal length;
	Printing3_T_s4_3_41 *sequence;
} Printing3_RequestStatus;
typedef Cardinal Printing3_UndefinedProblem;
#define sizeof_Printing3_UndefinedProblem sizeof_Cardinal
#define clear_Printing3_UndefinedProblem clear_Cardinal
#define externalize_Printing3_UndefinedProblem externalize_Cardinal
#define internalize_Printing3_UndefinedProblem internalize_Cardinal


typedef enum {
	Printing3_noRoute = 0,
	Printing3_noResponse = 1,
	Printing3_transmissionHardware = 2,
	Printing3_transportTimeout = 3,
	Printing3_tooManyLocalConnections = 4,
	Printing3_tooManyRemoteConnections = 5,
	Printing3_missingCourier = 6,
	Printing3_missingProgram = 7,
	Printing3_missingProcedure = 8,
	Printing3_protocolMismatch = 9,
	Printing3_parameterInconsistency = 10,
	Printing3_invalidMessage = 11,
	Printing3_returnTimedOut = 12,
	Printing3_otherCallProblem = 0177777
} Printing3_ConnectionProblem;
#define sizeof_Printing3_ConnectionProblem sizeof_enumeration
#define clear_Printing3_ConnectionProblem clear_enumeration
#define externalize_Printing3_ConnectionProblem externalize_enumeration
#define internalize_Printing3_ConnectionProblem internalize_enumeration


typedef enum {
	Printing3_aborted4_3_43 = 0,
	Printing3_formatIncorrect = 2,
	Printing3_noRendezvous = 3,
	Printing3_wrongDirection = 4
} Printing3_TransferProblem;
#define sizeof_Printing3_TransferProblem sizeof_enumeration
#define clear_Printing3_TransferProblem clear_enumeration
#define externalize_Printing3_TransferProblem externalize_enumeration
#define internalize_Printing3_TransferProblem internalize_enumeration


#define Printing3_Busy (ERROR_OFFSET+0)
#define Printing3_BusyArgs T_cn4_3_44

#define Printing3_InsufficientSpoolSpace (ERROR_OFFSET+1)
#define Printing3_InsufficientSpoolSpaceArgs T_cn4_3_45

#define Printing3_InvalidPrintParameters (ERROR_OFFSET+2)
#define Printing3_InvalidPrintParametersArgs T_cn4_3_46

#define Printing3_MasterTooLarge (ERROR_OFFSET+3)
#define Printing3_MasterTooLargeArgs T_cn4_3_47

#define Printing3_ServiceUnavailable (ERROR_OFFSET+4)
#define Printing3_ServiceUnavailableArgs T_cn4_3_48

#define Printing3_MediumUnavailable (ERROR_OFFSET+5)
#define Printing3_MediumUnavailableArgs T_cn4_3_49

#define Printing3_SpoolingDisabled (ERROR_OFFSET+6)
#define Printing3_SpoolingDisabledArgs T_cn4_3_50

#define Printing3_SpoolingQueueFull (ERROR_OFFSET+7)
#define Printing3_SpoolingQueueFullArgs T_cn4_3_51

#define Printing3_SystemError (ERROR_OFFSET+8)
#define Printing3_SystemErrorArgs T_cn4_3_52

#define Printing3_TooManyClients (ERROR_OFFSET+9)
#define Printing3_TooManyClientsArgs T_cn4_3_53

typedef struct {
	Cardinal problem;
} T_cn4_3_54;

#define sizeof_T_cn4_3_54(p) 1

#define clear_T_cn4_3_54(p)

#define Printing3_Undefined (ERROR_OFFSET+10)
#define Printing3_UndefinedArgs T_cn4_3_54

typedef struct {
	Printing3_ConnectionProblem problem;
} T_cn4_3_55;

#define sizeof_T_cn4_3_55(p) 1

#define clear_T_cn4_3_55(p)

#define Printing3_ConnectionError (ERROR_OFFSET+11)
#define Printing3_ConnectionErrorArgs T_cn4_3_55

typedef struct {
	Printing3_TransferProblem problem;
} T_cn4_3_56;

#define sizeof_T_cn4_3_56(p) 1

#define clear_T_cn4_3_56(p)

#define Printing3_TransferError (ERROR_OFFSET+12)
#define Printing3_TransferErrorArgs T_cn4_3_56

typedef struct {
	Printing3_RequestID printRequestID;
} Printing3_PrintResults;

#define sizeof_Printing3_PrintResults(p) 5

#define clear_Printing3_PrintResults(p)

extern Printing3_PrintResults Printing3_Print();

typedef struct {
	Printing3_PrinterProperties properties;
} Printing3_GetPrinterPropertiesResults;

extern Printing3_GetPrinterPropertiesResults Printing3_GetPrinterProperties();

typedef struct {
	Printing3_RequestStatus status;
} Printing3_GetPrintRequestStatusResults;

extern Printing3_GetPrintRequestStatusResults Printing3_GetPrintRequestStatus();

typedef struct {
	Printing3_PrinterStatus status;
} Printing3_GetPrinterStatusResults;

extern Printing3_GetPrinterStatusResults Printing3_GetPrinterStatus();

#endif __Printing

