/*
 * StubOps.c
 *
 * Last Edited on Fri Dec  6 14:45:46 PST 1985
 *
 */

#include <sys/types.h>

#include <signal.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sysexits.h>

#include "NetworkStream.h"
#include "StubOps.h"

extern struct ns_addr *(GetXNSAddr());
extern char *getenv();

/*
 * StubAbort
 *
 * If stderr has not been replaced, print error message,
 * print an error message.
 * Exit.
 */

static int stdErrOpen = TRUE;
char stubErrMsgBuf[200];

int
StubAbort(exitCode, fmt, arg1, arg2, arg3)
    int exitCode;
    char *fmt;
    int arg1, arg2, arg3;
{
    char buf[1024];

    if( stdErrOpen ) {
	sprintf( buf, fmt, arg1, arg2, arg3 );
        write(STDERR, "Error: ", 7);
        write(STDERR, buf, strlen(buf));
        write(STDERR, "\n", 1);
    }
    if( exitCode ) exit( exitCode );
    return(0);
}


/*
 * ReplaceStdTTYs
 *
 * Replace standard ttys by named new file.
 *
 * If newFileName is NULL, this just closes them.
 *
 * If setControl is TRUE, any old control tty association is
 * deleted; when a new [pt]ty is opened, it becomes the control tty.
 * Note the process group of the newly-opened tty is NOT set.
 */
int
ReplaceStdTTYs(newFileName, setControl)
    int newFileName;
    int setControl;
{
    int t;
    int mypgrp;

    if( setControl ) {
	(void)(signal( SIGTTIN, SIG_IGN ));
	(void)(signal( SIGTTOU, SIG_IGN ));
        t = open("/dev/tty", O_RDWR, 0666);
        if( t  >= 0 ) { ioctl(t, TIOCNOTTY, 0); close(t); }
	mypgrp = getpgrp( 0 /*self*/ );
	setpgrp( 0 /*self*/, 0 );
    }

    close(STDIN);
    close(STDOUT);
    close(STDERR);

    if( (newFileName != NULL) 
            && ((t = open(newFileName, O_RDWR, 0666)) >= 0) ) {
	if( t != STDIN ) /* ?? */ { dup2(t,STDIN); close(t); }
        dup2(STDIN, STDOUT);
        dup2(STDIN, STDERR);
    }

    if( setControl ) {
        setpgrp( 0 /*self*/, mypgrp );
    }

    stdErrOpen = FALSE;
    return(0);
}


int
MoveDescriptor(from, to)
    int from;
    int to;
{
    if( from < 0 ) return(-1);
    if( from != to ) {
        if( dup2(from, to) < 0 ) return(-1);
	close(from);
    }
    return( to );
}


int
DefaultOnHup()
{
    (void)(signal(SIGHUP, SIG_IGN));
    (void)(signal(SIGINT, SIG_IGN));
    SPPClose(STDSTREAM, /*initiate=*/TRUE);
    _exit(0);
}


/*
 *
 * "standard" argument processing
 *
 */

int stubStdFlag_h;
char * stubStdArg_h;
int stubStdFlag_H;
char * stubStdArg_H;
int stubStdFlag_p;
int stubStdArg_p0;
int stubStdArg_p1;
int stubStdArg_p2;
int stubStdArg_p3;
int stubStdFlag_P;
int stubStdArg_P0;
int stubStdArg_P1;
int stubStdArg_P2;
int stubStdArg_P3;
int stubStdFlag_t;


static char remoteCmdBuf[2048];
static char *remoteCmdPtr;

static void
AddStringToRemoteCmd(from)
    register char *from;
{
    register char *to;
    register char *lim;
    register char c;

    to = remoteCmdPtr;
    lim = remoteCmdBuf + (sizeof remoteCmdBuf) - 2;
    if( to < lim ) {
	while( (c = *from++) != 0 )
	    if( to < lim ) *to++ = c;
	*to++ = '\r';
	*to = 0;
	remoteCmdPtr = to;
    }
}

static void
AddNumberToRemoteCmd(n)
    int n;
{
    char buf[10];
    sprintf(buf, "%d", n);
    AddStringToRemoteCmd(buf);
}


int
StubStart(remoteName, remoteArgc, remoteArgv, background, onHup)
    char *remoteName; /* name of remote command */
    int remoteArgc; /* argument count for remote command */
    char **remoteArgv; /* arguments for remote command */
    int background; /* true => fork, setup stub for background */
    int (*onHup)(); /* SIGHUP handler */
{
    int s; /* socket descriptor */
    char *wsName; /* network name/address of workstation */
    struct ns_addr *ap;
    int child;
    char *sessionName;
    int sessionID;

    if( (wsName = getenv("WORKSTATION")) == NULL )
	StubAbort(EX_NOINPUT, "No workstation in environment\n");

    if( (ap = GetXNSAddr(wsName)) == NULL )
	StubAbort(EX_DATAERR, "Can't parse WORKSTATION.\n");

    if( MoveDescriptor( SPPConnect(ap), STDSTREAM ) < 0 )
        StubAbort(EX_NOHOST, "Can't connect %d.\n", sppResult);

    if( background ) {

        child = fork();
	if( child < 0 ) {
	    SPPClose(STDSTREAM, TRUE);
	    StubAbort(1, "Can't fork.\n");
	}
	if( child > 0 ) {
	    close(STDSTREAM);
	    return( child );
	}

	if( (sessionName = getenv("SESSION")) != 0 )
	    sessionID = atoi(sessionName);
	setpgrp( 0 /*=self*/, sessionID );

	(void)(signal(SIGTSTP, SIG_IGN));
        (void)(signal(SIGINT, SIG_IGN));
	(void)(signal(SIGHUP, onHup));
	(void)(signal(SIGQUIT, SIG_IGN));
	(void)(signal(SIGTERM, SIG_IGN));
	(void)(signal(SIGTTIN, SIG_IGN)); /*??*/
	(void)(signal(SIGTTOU, SIG_IGN)); /*??*/

    } else {

        (void)(signal(SIGINT, onHup));
        (void)(signal(SIGHUP, onHup));

    }

    remoteCmdPtr = remoteCmdBuf;
    *remoteCmdPtr++ = 'E';
    AddStringToRemoteCmd(remoteName);

    if( stubStdFlag_h ) {
        AddStringToRemoteCmd("-h");
	AddStringToRemoteCmd(stubStdArg_h);
    }
    if( stubStdFlag_H ) {
        AddStringToRemoteCmd("-H");
	AddStringToRemoteCmd(stubStdArg_H);
    }
    if( stubStdFlag_p ) {
        AddStringToRemoteCmd("-p");
	AddNumberToRemoteCmd(stubStdArg_p0);
	AddNumberToRemoteCmd(stubStdArg_p1);
    }
    if( stubStdFlag_P ) {
        AddStringToRemoteCmd("-P");
	AddNumberToRemoteCmd(stubStdArg_P0);
	AddNumberToRemoteCmd(stubStdArg_P1);
	AddNumberToRemoteCmd(stubStdArg_P2);
	AddNumberToRemoteCmd(stubStdArg_P3);
    }
    if( stubStdFlag_t ) {
        AddStringToRemoteCmd("-t");
    }

    { int i;
        for( i = 0; i < remoteArgc; i++ )
           AddStringToRemoteCmd(remoteArgv[i]);
    }

    { int answer;
        answer = SPPWrite(STDSTREAM,
                remoteCmdBuf, remoteCmdPtr - remoteCmdBuf, /*setEOM=*/ 1);
	if( answer < 0 )
	    StubAbort(EX_UNAVAILABLE, "Error %d sending command\n", answer);
    }

    return( 0 );
}


int
StubCmdLoop(interpList)
    int (**interpList)();
{
    char cmd; /* 1-character command from workstation */
    char argBuf[1024];
    register int (**p)();
    int answer;

    do {
        /* read next command */
	cmd = RcvCmd(STDSTREAM, argBuf, sizeof argBuf);

	if( cmd > 0 ) {
            /* invoke list of command routines */
	    for( (p = interpList),(answer = 0)
		; (*p)  && ((answer = (**p)(STDSTREAM, cmd, argBuf)) == 0)
		; p++ ) ;
            /* or try default commands */
	    if( answer == 0 ) switch(cmd) {
		case 'Q':
		    (void)SPPClose(STDSTREAM, TRUE);
		    break;
		default:
		    answer = -1;
		    break;
	    }
	} else /* cmd <= 0 */ {
	    /* ?? CHECK FOR CLOSE HERE ?? */
	    answer = cmd;
	}

    } while( answer > 0 );
		
    return(answer);
}

