/*
 * SMailCmds.c - commands for RSMail stub
 *
 * Last edited by AJD on Thu Jan  2 21:47:53 PST 1986
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sysexits.h>

#include "NetworkStream.h"
#include "StubOps.h"

/* flags for SENDMAIL_CMD (better be standard sendmail!) */
#define DEFAULT_FLAGS "-oeq"
#define PARSE_MSG_FLAG "-t"


int SMailMaxLineLength = 80;

extern char *AliasExp();

extern int errno;

int
SMailCmds(s, cmd, arg)
    int s; /* socket descriptor */
    char cmd; /* 1-character command from workstation */
    char *arg; /* argument ptr */
{
    int returnCode = 1;

	switch( cmd ) {

	    case 'S': { /* (recipient) : Send meSSage */
	        char *nackVal;
	        int child, waitedChild;
		union wait status;
                char buf[512];
                int pfd[2]; /* pipe file descriptors */
#                 define READFD pfd[0]
#                 define WRITEFD pfd[1]
#               define xlate XLATE_TEXT
		int euid;

                /* fork a mailer */
		READFD = WRITEFD = -1;
	        if( pipe(pfd) < 0 )
		    { SendCmdf(s,NACK,"Pipe error %d", errno); goto Sout; }
		if( (child = fork()) < 0 )
		    { SendCmdf(s,NACK,"Fork error %d", errno); goto Sout; }
		if( child == 0 ) /* this is child */ {
		    setpgrp( 0 /*=self*/, getpid() );
		    close(WRITEFD);
		    close(s);
		    if( READFD != 0 )
		        { dup2(READFD,0); close(READFD); }
		    close(1); close(2);

		    execl( SENDMAIL_CMD, SENDMAIL_CMD,
		            DEFAULT_FLAGS, PARSE_MSG_FLAG, 0 );
		    /*NOTREACHED*/
		    exit(-1);
		}
		close(READFD); READFD = -1;
		SendACK(s);

	        /* pass message to mailer */
		for(;;) {
		    int nr;
		    cmd = RcvCmd(s, buf, sizeof buf);
		    if( cmd <= 0 )
		        { returnCode = -1; goto Sout; }
		    if( (cmd != 'H') && (cmd != 'D') ) break;
		    nr = RcvFile(s, WRITEFD, xlate,
		        ((cmd == 'H') ? 0 : SMailMaxLineLength) );
		    if( nr >= 0 ) {
	                SendACK(s);
		    } else {
		        SendCmdf(s, NACK, "I/O error"); goto Sout;
		    }
		}
		close(WRITEFD); WRITEFD = -1;

		/* check mailer exit status */
		do {
		    waitedChild = wait(&status);
		} while( (waitedChild >= 0) && (waitedChild != child) );
		if( cmd == 's' ) {
		    if( waitedChild < 0 ) {
		        nackVal = "Child disappeared";
		    } else switch(status.w_retcode) {
		        case EX_OK:
			    nackVal = NULL;
			    break;
			case EX_TEMPFAIL:
			    nackVal = "Message queued";
			    break;
			case EX_NOHOST:
			    nackVal = "Addressee host unknown";
			    break;
			case EX_NOUSER:
			    nackVal = "Addressee user unknown";
			    break;
			default:
			    nackVal = "Unknown error";
			    break;
		    }
		} else {
		    nackVal = "Protocol error";
		    returnCode = -1;
		}
		if( nackVal == NULL )
	            SendACK(s);
		else
		    SendCmdf(s, NACK, nackVal );
	    Sout:
	        if( READFD >= 0 ) close(READFD);
		if( WRITEFD >= 0 ) close(WRITEFD);
	        break; }

	    case 'a': { /* (addresses) : AliAs-expAnd list of Addresses */
	        char *expanded;
		if( (expanded = AliasExp(arg)) != NULL )
		    SendCmdf(s, ACK, "%s", expanded);
		else
	            SendACK(s); /* "no change" */
	        break; }

	    default:
		returnCode = 0;
		break;
	}

out:
    return(returnCode);
}

