/*
 * rviewstub.c
 *
 * rviewstub [file]
 *
 * Open a remote view window on a file or stdin
 *
 * Edited by AJD on Sun Aug 11 11:11:45 EDT 1985
 *
 */


#include <sys/types.h>

#include <errno.h>
#include <sgtty.h>
#include <stdio.h>
#include <sys/file.h>
#include <sysexits.h>

#include <signal.h> /* ?? */

#include "CommandOps.h"
#include "NetworkStream.h"
#include "StubOps.h"

#define REMOTE_COMMAND "RView"

#define INPUT_FILE	LAST_NONSTD

struct { int myArgc; char **myArgv; } myArgs;

char *myUsageMsg =
    "[-h tinyHeader] [-H activeHeader] [-p tinyPos] [-P activeBox] [-t] [fileName ...]";

char *myDescription[] = {
    STD_ARG_DEF_h, STD_ARG_DEF_H, STD_ARG_DEF_p, STD_ARG_DEF_P, STD_ARG_DEF_t,
    "*", (char *)(&myArgs),
    (char *)0 };

extern int errno;

int CopyChars();



int
main(argc, argv)
    int argc;
    char **argv;
{
    int i;
    int child;

    if( ParseArgsV( argc, argv, myUsageMsg, myDescription ) < 0 )
        exit(EX_USAGE);

    i = 0;
    do {
	if( myArgs.myArgc == 0 ) {
	    if( MoveDescriptor(STDIN, INPUT_FILE) < 0 )
		StubAbort(EX_NOINPUT, "No stdin!\n");
	    child = StubStart( REMOTE_COMMAND, /*argc=*/ 0, /*argv=*/ NULL,
	            /*background=*/ TRUE, DefaultOnHup );
	} else {
	    if( MoveDescriptor( open(myArgs.myArgv[i],O_RDONLY,0666),
		    INPUT_FILE ) < 0 )
		StubAbort(EX_NOINPUT, "can't open file\n");
	    child = StubStart( REMOTE_COMMAND, /*arcg=*/ 1, &(myArgs.myArgv[i]),
	            /*background=*/ TRUE, DefaultOnHup );
	}
        if( child  == 0 ) {
	    ReplaceStdTTYs(NULL, FALSE);
	    CopyChars();
	    DefaultOnHup();
	    /*NOTREACHED*/
	}
	close(INPUT_FILE);
    } while( ++i < myArgs.myArgc );

    _exit(EX_OK);

}



/*
 * Copy characters between input file and SPP stream,
 *   translating LF-CR for XDE.
 *
 * N.B. this ASSUMES SPPWrite will work with FIONBIO set on.
 */
int
CopyChars()
{
    char buf[4096];
    int cnt;
    int netbit = (1 << STDSTREAM);
    int on = 1;
    int off = 0;

        ioctl(STDSTREAM, FIONBIO, &on);

	for(;;) {

	    if( (cnt = read(INPUT_FILE,buf,(sizeof buf))) <= 0 ) goto out;

	    { register char *p = buf;
	      register int n = cnt;
	        while( --n >= 0 )
	            if( *p++  == '\n' )  p[-1] = '\r';
	    }

	    { char *bp = buf;
	      int cc;
	      int ibits, obits;

	        while( cnt > 0 ) {
		    ibits = obits = netbit;
		    if( (select((NUM_DESCRIPTORS), &ibits, &obits, 0, 0) <= 0)
		            || (ibits & netbit) )
			goto out;
		    if( obits & netbit) {
			cc = SPPWrite( STDSTREAM, bp, cnt, /*setEM=*/FALSE );
			if( cc < 0 ) {
			    if( sppResult != -EWOULDBLOCK )
			        goto out;
			    cc = 0;
			}
			cnt -= cc;  bp += cc;
		    } else {
		        sleep(5);
		    }
		}
	    }
	}

    out:
        ioctl(STDSTREAM, FIONBIO, &off);
	(void)SPPWrite( STDSTREAM, buf, 0, /*setEM=*/TRUE );
        return(0);
}

