/*
 * RTermstub.c
 *
 * RTermstub [windowOptions] [-d descriptor] command [arg ...]
 *
 * Open a remote terminal window, run command with requested descriptor
 * associated with that window.
 *
 * If no descriptor is specified, run command in background with
 * stdin+stdout+stderr attached to new window.
 *
 * Must be suid root for PTYSetup() to do chown and chmod.
 *
 * Edited by AJD on Tue Dec 10 22:27:47 PST 1985
 *
 */

#include <sgtty.h>
#include <signal.h>
#include <stdio.h>
#include <sysexits.h>

#include "CommandOps.h"
#include "NetworkStream.h"
#include "PTYOps.h"
#include "StubOps.h"

#define REMOTE_COMMAND "RTerm"

#define ENV_TERM "RTERM_TERM"
#define ENV_INIT "RTERM_INIT"

#define DEFAULT_TERM "vt100"

struct { int myArgc; char **myArgv; } myArgs;
int descriptorRequest = -1;

char *myUsageMsg =
    "[-h tinyHeader] [-H activeHeader] [-p tinyPos] [-P activeBox] [-t] [-d descriptor] command";

char *myDescription[] = {
    STD_ARG_DEF_h, STD_ARG_DEF_H, STD_ARG_DEF_p, STD_ARG_DEF_P, STD_ARG_DEF_t,
    "-dd", (char *)(&descriptorRequest),
    "#", (char *)(&myArgs),
    (char *)0 };

static char ptyName[20];
static char ttyName[20];

int
RTermOnHup()
{
    (void)(signal(SIGHUP, SIG_IGN));
    SPPClose(STDSTREAM, TRUE);

    PTYShutdown(ptyName, ttyName, descriptorRequest);
    exit(EX_OK);
}



main(argc, argv)
    int argc;
    char **argv;
{
    int child; /* child pid */

    if( ParseArgsV( argc, argv, myUsageMsg, myDescription ) < 0 )
        exit(EX_USAGE);

    if( descriptorRequest >= PTY )
        StubAbort(EX_USAGE,
	    "Descriptor request %d too large\n", descriptorRequest);

    if(  ( MoveDescriptor( GetPTY(ptyName, ttyName), PTY) < 0 )
            || ( PTYSetup(ptyName, ttyName, descriptorRequest) < 0 )  )
        StubAbort(EX_UNAVAILABLE, "Can't get PTY\n");

    if( (child = fork()) < 0 )
        StubAbort(EX_OSERR, "Can't fork\n");

    if( child == 0 ) {

	close(PTY); close(STDSTREAM);

	if( descriptorRequest < 0 ) {
	    int newpgrp = getpid();
	    setpgrp( 0 /*=self*/, newpgrp );
	    ioctl(STDIN, TIOCSPGRP, &newpgrp);
	}

	signal(SIGTTIN, SIG_DFL);
	signal(SIGTTOU, SIG_DFL);

	setuid( getuid() ); /* relinquish suid root */

	{ char *termName = GetEnv(ENV_TERM);
	    if( termName != NULL )
	        SetEnv("TERM", termName);
	    else if( GetEnv("TERM") == NULL )
	        SetEnv("TERM", DEFAULT_TERM);
	}

	{ char *initCmd = GetEnv(ENV_INIT);
	    if( initCmd != NULL ) system(initCmd);
	}

	execvp( myArgs.myArgv[0], myArgs.myArgv );
	exit(EX_UNAVAILABLE);
	/*NOTREACHED*/
    }

    if( StubStart( REMOTE_COMMAND, 1, myArgs.myArgv,
            /*background=*/ (descriptorRequest < 0),
	    /*onHup=*/ RTermOnHup ) != 0 )
	_exit(EX_OK);

    ReplaceStdTTYs(NULL, FALSE);
    PTYCopy();
    RTermOnHup();
    /*NOTREACHED*/
}
