/*
 * RSMailStub.c - Dandelion Remote Mail Sending Stub
 *
 * Edited by AJD on Sun Dec 22 13:34:23 PST 1985
 *
 */

#include <stdio.h>
#include <sysexits.h>

#include "CommandOps.h"
#include "StubOps.h"

#define REMOTE_COMMAND "RSMail"
#define ENV_MAXLINELENGTH "RSMAIL_MAXLINELENGTH"

extern int SMailCmds();
extern int SMailMaxLineLength;

extern int AliasExpInit();

extern int FTPCmds();
extern int FTPMaxLineLength;

int (*(myInterpList[]))() = { SMailCmds, FTPCmds, NULL };

struct { int myArgc; char **myArgv; } myArgs;

char *myUsageMsg =
    "[-h tinyHeader] [-H activeHeader] [-p tinyPos] [-P activeBox] [address]";

char *myDescription[] = {
    STD_ARG_DEF_h, STD_ARG_DEF_H, STD_ARG_DEF_p, STD_ARG_DEF_P, STD_ARG_DEF_t,
    "?", (char *)(&myArgs),
    (char *)0 };

main(argc, argv)
    int argc;
    char **argv;
{
    if( ParseArgsV( argc, argv, myUsageMsg, myDescription ) < 0 )
        exit(EX_USAGE);

    { char *p; int n;
        SMailMaxLineLength = 80;
	FTPMaxLineLength = 80;
        if( (p = GetEnv(ENV_MAXLINELENGTH)) != NULL )
	    if( (n = atoi(p)) >= 0 ) {
	        SMailMaxLineLength = n;
		FTPMaxLineLength = n;
	    }
    }


    if( StubStart( REMOTE_COMMAND, myArgs.myArgc, myArgs.myArgv,
            /*background=*/ TRUE, /*onHup=*/ DefaultOnHup ) != 0 )
	_exit(EX_OK);

    ReplaceStdTTYs(NULL, FALSE);
    (void)AliasExpInit();
    StubCmdLoop(myInterpList);
    DefaultOnHup();
    /*NOTREACHED*/
}
