/*
 * RRMailStub.c - Dandelion Remote Mail Reading Stub
 *
 * Edited by AJD on Thu Dec 12 17:11:57 PST 1985
 *
 * TODO: check if msg heap read-only and tell tool.
 */

#include <signal.h>
#include <stdio.h>
#include <sysexits.h>
#include <sys/wait.h>

#include "CommandOps.h"
#include "MsgHeap.h"
#include "StubOps.h"

#define ENV_MAILDIR "RRMAIL_MAILDIR"

#define REMOTE_COMMAND "RRMail"
#define MAX_NEW_MSGS 300

extern int rMailHeapHandle;
extern int RMailCmds();
extern int FTPCmds();

static int (*(myInterpList[]))() = { RMailCmds, FTPCmds, NULL };

struct { int myArgc; char **myArgv; } myArgs;

char *myUsageMsg =
    "[-h tinyHeader] [-H activeHeader] [-p tinyPos] [-P activeBox] [-t] [msgSetName]";

char *myDescription[] = {
    STD_ARG_DEF_h, STD_ARG_DEF_H, STD_ARG_DEF_p, STD_ARG_DEF_P, STD_ARG_DEF_t,
    "?", (char *)(&myArgs),
    (char *)0 };


static
int RRMailStubOnHup()
{
    int h;
    
    UnlockMailService(); /* idempotent, fortunately */
    h = rMailHeapHandle; rMailHeapHandle = -1;
    if( h >= 0 ) {
        if( CheckDirtyMsgHeap(h) == 0 ) WriteMsgHeap(h);
	ReleaseMsgHeap(h);
    }
    DefaultOnHup();
    /*NOTREACHED*/
}

static void
ReapChild()
{
    union wait status;
    while( wait3(&status, WNOHANG, NULL) > 0 ) ;
}


main(argc, argv)
    int argc;
    char **argv;
{
    if( ParseArgsV( argc, argv, myUsageMsg, myDescription ) < 0 )
        exit(EX_USAGE);

    { char *homeName, *mailDirName;
        if( ((homeName = GetEnv("HOME")) == NULL)
	        || (chdir(homeName) < 0)
                || ((mailDirName = GetEnv(ENV_MAILDIR)) == NULL)
		|| (chdir(mailDirName) < 0) )
            StubAbort(1, "Can't chdir to mail directory\n");
    }

    rMailHeapHandle = AcquireMsgHeap(NULL, MAX_NEW_MSGS);
    if( rMailHeapHandle < 0 )
        StubAbort(1, "Can't acquire mail heap\n");

    if( StubStart( REMOTE_COMMAND, myArgs.myArgc, myArgs.myArgv,
            /*background=*/ TRUE, /*onHup=*/ RRMailStubOnHup ) != 0 )
	_exit(EX_OK);

    signal(SIGCHLD, ReapChild);
    ReplaceStdTTYs(NULL, FALSE);
    StubCmdLoop(myInterpList);
    RRMailStubOnHup();
    /*NOTREACHED*/
}

