/*
 * RMailCmds.c - commands for Mail reading stub
 *
 * Edited by AJD on Tue Dec 31 20:09:59 PST 1985
 *
 */

#include <signal.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sysexits.h>

#include "NetworkStream.h"
#include "RMailOps.h"
#include "StubOps.h"

#define ENV_PRINT "RRMAIL_PRINT"

static char smail_command[] = "RSMail";
#define NEW_MAIL_MSGSET "newmail.toc"

int rMailHeapHandle = -1;

extern int SMailCmds();
extern int AliasExpInit();

extern int errno;
extern char *getenv();
extern char *malloc();
extern struct ns_addr *(GetXNSAddr());

static int sending = 0;

static void
StartSending(s, arg)
    int s; /* socket descriptor */
    char *arg; /* argument ptr */
{
    extern int rMailHeapHandle;
    char *wsName;
    struct ns_addr *ap;
    char *remoteCmdBuf;
    int answer;

    /* ignore reader commands, rMailHeap */
    sending = 1;
    rMailHeapHandle = -1;
    signal(SIGCHLD, SIG_DFL);

    /* replace s by new stream */
    close(s);
    if( (wsName = getenv("WORKSTATION")) == NULL )
	_exit(1);
    if( (ap = GetXNSAddr(wsName)) == NULL )
	_exit(1);
    if( MoveDescriptor( SPPConnect(ap), s ) < 0 )
	_exit(1);

    remoteCmdBuf = malloc( 1 + (sizeof smail_command) + 1 + strlen(arg) + 1 );
    strcpy(remoteCmdBuf, "E");
    strcat(remoteCmdBuf, smail_command);
    strcat(remoteCmdBuf, "\r");
    strcat(remoteCmdBuf, arg);
    answer = SPPWrite(s, remoteCmdBuf, strlen(remoteCmdBuf), /*setEOM=*/ 1 );

    if( answer < 0 )
	{ SPPClose(s); _exit(1); }
}


int
RMailCmds(s, cmd, arg)
    int s; /* socket descriptor */
    char cmd; /* 1-character command from workstation */
    char *arg; /* argument ptr */
{
    int returnCode = 1;
    static int sendOnly = 0;

	if( sending ) return( SMailCmds(s,cmd,arg) );

	switch( cmd ) {

	    case 'F': { /* (address) : create new Form */
	        int child;

		/* make sure alias translation tables are loaded */
		(void)AliasExpInit(NULL);

                /* fork and send mail from child */
		if( (child = fork()) < 0 ) {
		    SendCmdf(s, NACK, "Fork error %d", errno); 
		    break;
		}
		if( child == 0 ) /* this is child */ {
		    StartSending(s, arg);
		} else /* this is parent */ {
		    (void)SendACK(s);
		}
		break; }

	    case 'b': /* () : check mailbox */ {
	        int answer;
		(void)SetSpoolFileName(NULL, NULL);
		if( (answer = CheckMail(/*newMailOnly=*/TRUE)) > 0 )
		    SendACK(s);
		else
		    SendCmdf( s, NACK,
		        ((answer == 0) ? "No new mail" : "Error %d"), answer );
		break; }

	    case 'B': /* () : read mailbox */ {
	        int lockResult = 0;
		int retrieveResult = 0;
		FILE *toCFile = NULL;

		if( SetSpoolFileName(NULL, NULL) == NULL )
       		    { SendCmdf(s, NACK, "Spool name error"); goto Bout; }
		lockResult = LockMailService(LOCK_TYPE);
		if( lockResult <= 0 ) {
		    SendCmdf(s, NACK, ((lockResult==0)
		        ? "Mail service busy"
			: "Error %d reading mail"), lockResult);
		    goto Bout;
		}
		if( (toCFile = fopen(NEW_MAIL_MSGSET, "a")) == NULL ) {
		    SendCmdf(s, NACK, "Can't open new mail msgset");
		    goto Bout;
		}
		retrieveResult = RetrieveMail( toCFile,
		        rMailHeapHandle, /*deleteFromSpool=*/ TRUE );
		if( retrieveResult < 0 ) {
		    SendCmdf(s, NACK, "Mail read error %d", retrieveResult);
		    goto Bout;
		}
		SendACK(s);
	    Bout:
	        if( toCFile != NULL ) fclose( toCFile );
		if( lockResult > 0 ) UnlockMailService();
	        break; }
		
	    case 'G': /* (messageID) : Get given message */ {
		char buf[400];
		int desiredMsgID;
		int len;
		int nSent = 0;
		int req;
		int cc;


		desiredMsgID = atoi(arg);
		if( OpenMsg(rMailHeapHandle,desiredMsgID) != desiredMsgID )
		    { SendCmdf(s, NACK, "Message nonexistent"); goto Gout; }
		len = GetMsgLength(rMailHeapHandle);
		if( SendCmdf(s, 'D', "%d\r", len) < 0 )
		    { returnCode = -1; goto Gout; }
		for( nSent = 0; nSent < len; nSent += cc ) {
		    req = len - nSent;
		    if( req > (sizeof buf) ) req = sizeof buf;
		    if( (cc = ReadMsg(rMailHeapHandle, buf, req)) <= 0 )
		        { returnCode = -2; goto Gout; }
		    { register char *p;
		      register int n;
		        for( (p=buf),(n=cc); --n >= 0; )
			    if( *p++ == '\n' ) p[-1] = '\r';
		    }
		    { int n, nw;
		        for( nw = 0; nw < cc; nw += n ) {
			    n = SPPWrite(s, buf + nw, cc - nw, /*setEM=*/ 0);
			    if( n <= 0 ) { returnCode = -3; goto Gout; }
			}
		    }
		}
		(void)SPPWrite(s, buf, 0, /*setEM=*/ 1 );
		
	    Gout:
		(void)CloseMsg(rMailHeapHandle);
		break; }

	    case 'c': /* (msgID) : copy message to current FTP output file */ {
	        int answer;
		int desiredMsgID;
		extern int FTPofd;
		char buf[4096];

		desiredMsgID = atoi(arg);
		if( OpenMsg(rMailHeapHandle,desiredMsgID) != desiredMsgID )
		    { SendCmdf(s, NACK, "Message nonexistent"); goto cout; }
		for(;;) {
	            answer = ReadMsg(rMailHeapHandle, buf, (sizeof buf));
		    if( answer < 0 )
		        { SendCmdf(s, NACK, "Read error"); goto cout; }
		    if( answer == 0 ) break;
		    if( write( FTPofd, buf, answer ) != answer )
		        { SendCmdf(s, NACK, "Write error"); goto cout; }
	        };
		SendACK(s);
	    cout:
	        (void)CloseMsg(rMailHeapHandle);
	        break; }

	    case 'P': /* (msgID) : Print message */ {
	        int answer;
		int desiredMsgID;
		int child;
		char *printPgm;
		char buf[4096];
                int pfd[2]; /* pipe file descriptors */
#                 define READFD pfd[0]
#                 define WRITEFD pfd[1]

		desiredMsgID = atoi(arg);
		if( OpenMsg(rMailHeapHandle,desiredMsgID) != desiredMsgID )
		    { SendCmdf(s, NACK, "Message nonexistent"); goto Pout; }
		if( pipe(pfd) < 0 )
		    { SendCmdf(s,NACK,"Pipe error %d", errno); goto PCloseMsg; }
		if( (child = fork()) < 0 )
		    { SendCmdf(s,NACK,"Fork error %d", errno); goto PClose; }
		if( child == 0 ) /* this is child */ {
		    setpgrp( 0 /*=self*/, getpid() );
		    close(WRITEFD);
		    if( READFD != 0 )
		        { dup2(READFD,0); close(READFD); }
		    close(1); close(2);

		    if( (printPgm = getenv(ENV_PRINT)) == NULL )
		        printPgm = DEFAULT_PRINT;
		    system(printPgm);
		    exit(0);
		}
		/* copy message to child thru pipe */
		for(;;) {
	            answer = ReadMsg(rMailHeapHandle, buf, (sizeof buf));
		    if( answer < 0 )
		        { SendCmdf(s, NACK, "Read error"); goto PClose; }
		    if( answer == 0 ) break;
		    if( write( WRITEFD, buf, answer ) != answer )
		        { SendCmdf(s, NACK, "Write error"); goto PClose; }
	        };
		SendACK(s);
	    PClose:
	        close(READFD);
		close(WRITEFD);
	    PCloseMsg:
	        CloseMsg(rMailHeapHandle);
	    Pout:
	        break; }

	    case 'u': /* (msgID) : return message to mailbox */ {
	        int desiredMsgID;
		int lockResult = 0;
		int unRetrieveResult;
		if( SetSpoolFileName(NULL, NULL) == NULL )
		    { SendCmdf(s, NACK, "Spool name error"); goto uout; }
		lockResult = LockMailService(LOCK_TYPE);
		if( lockResult <= 0 ) {
		    SendCmdf(s, NACK, ((lockResult==0)
		        ? "Mail service busy"
			: "Error %d reading mail"), lockResult);
		    goto uout;
		}
		desiredMsgID = atoi(arg);
		unRetrieveResult = UnRetrieveMsg(desiredMsgID, rMailHeapHandle);
		if( unRetrieveResult < 0 ) {
		    SendCmdf(s, NACK, "I/O error %d", unRetrieveResult);
		    goto uout;
		}
		SendACK(s);
	    uout:
	        if( lockResult > 0 ) UnlockMailService();
		break; }

	    default:
		returnCode = 0;
		break;

	}

out:
    return(returnCode);
}
