/*
 * RFTPStub.c - Dandelion Remote FTP Stub
 *
 * Edited by AJD on Tue Dec  3 11:36:14 PST 1985
 */

#include <stdio.h>
#include <sysexits.h>

#include "CommandOps.h"
#include "StubOps.h"

#define REMOTE_COMMAND "RFTP"

extern int FTPCmds();
extern int FTPMaxLineLength;

int (*(myInterpList[]))() = { FTPCmds, NULL };

char *myUsageMsg =
    "[-h tinyHeader] [-H activeHeader] [-p tinyPos] [-P activeBox]";

char *myDescription[] = {
    STD_ARG_DEF_h, STD_ARG_DEF_H, STD_ARG_DEF_p, STD_ARG_DEF_P, STD_ARG_DEF_t,
    (char *)0 };


main(argc, argv)
    int argc;
    char **argv;
{
    if( ParseArgsV( argc, argv, myUsageMsg, myDescription ) < 0 )
        exit(EX_USAGE);

    {   char *p; int n;
        if( (p = GetEnv("RFTP_MaxLineLength")) != NULL )
	    if( (n = atoi(p)) >= 0 )
	        FTPMaxLineLength = n;
    }
    
    if( StubStart( REMOTE_COMMAND, /*argc=*/0, /*argv=*/NULL,
            /*background=*/ TRUE, /*onHup=*/ DefaultOnHup ) != 0 )
	_exit(EX_OK);

    ReplaceStdTTYs(NULL, FALSE);
    StubCmdLoop(myInterpList);
    DefaultOnHup();
    /*NOTREACHED*/
}
