/*
 * REditStub.c - Dandelion Remote Editor Stub
 *
 * Edited by AJD on Thu May 22 16:20:29 EDT 1986
 *
 * $Log:	REditStub.c,v $
 * Revision 1.2  86/11/03  13:15:00  jqj
 * Added decl for rindex() to allow compilation under 4.2
 * 
 */

#include <stdio.h>
#include <sysexits.h>

#include "CommandOps.h"
#include "StubOps.h"

#define REMOTE_COMMAND "REdit"
#define FOREGROUND_REMOTE_COMMAND "REditw"

#define ENV_MAXLINELENGTH "REDIT_MAXLINELENGTH"

extern int errno;

extern int FTPCmds();
extern int FTPMaxLineLength;

int (*(myInterpList[]))() = { FTPCmds, NULL };

struct { int myArgc; char **myArgv; } myArgs;
int waitFlag = 0;

char *myUsageMsg =
    "[-h tinyHeader] [-H activeHeader] [-p tinyPos] [-P activeBox] [-t] [-w] [fileName ...]";

char *myDescription[] = {
    STD_ARG_DEF_h, STD_ARG_DEF_H, STD_ARG_DEF_p, STD_ARG_DEF_P, STD_ARG_DEF_t,
    "-wB", (char *)(&waitFlag),
    "*", (char *)(&myArgs),
    (char *)0 };


main(argc, argv)
    int argc;
    char **argv;
{
    int stubArgc;
    int i;
    int child;

    if( ParseArgsV( argc, argv, myUsageMsg, myDescription ) < 0 )
        exit(EX_USAGE);

    /* Check to see if invoked under name requiring foreground operation */
    { char *cp; extern char *rindex();
      if((cp = rindex(argv[0], '/')) != 0) {
          cp++;
      } else {
          cp = argv[0];
      }
      if( strcmp(cp, FOREGROUND_REMOTE_COMMAND ) == 0)
          waitFlag = 1;
    }

    if( waitFlag && (myArgs.myArgc > 1) )
        StubAbort(EX_USAGE, "Can't use -w with multiple files\n");

    {   char *p; int n;
        if( (p = GetEnv(ENV_MAXLINELENGTH)) != NULL )
	    if( (n = atoi(p)) >= 0 )
	        FTPMaxLineLength = n;
    }

    stubArgc = ((myArgs.myArgc > 0) ? 1 : 0);
    i = 0;
    do {
        child = StubStart( REMOTE_COMMAND, stubArgc, &(myArgs.myArgv[i]),
	        /*background=*/ (waitFlag == 0), /*onHup=*/ DefaultOnHup );
        if( child  == 0 ) {
	    ReplaceStdTTYs(NULL, FALSE);
	    StubCmdLoop(myInterpList);
	    DefaultOnHup();
	    /*NOTREACHED*/
	}
    } while( ++i < myArgs.myArgc );

    _exit(EX_OK);
}
