/*
 * NetworkStream.h
 *
 * Edited by AJD on Fri Nov 29 13:48:13 PST 1985
 */

#ifndef _TYPES_
#  include <sys/types.h>
#endif

#ifdef BSD42
# ifndef IDPPROTO_MAX
#   include <netxns/xn.h>
#   include <netxns/idp.h>
#   include <netxns/spp.h>
#   include <netxns/sppidp.h>
# endif
# define XNS_MTU 576
# define XNS_MAXDATA (XNS_MTU - sizeof(struct sppidphdr))
#endif
#ifdef BSD43
# ifndef NSPROTO_MAX
#   include <netns/ns.h>
#   include <netns/idp.h>
#   include <netns/sp.h>
#   include <netns/spidp.h>
# endif
# define XNS_MTU 576
# define XNS_MAXDATA (XNS_MTU - sizeof(struct spidp))
#endif


/*
 * NS SubStreamTypes
 */
#define SPPSST_NORMAL		0
#ifndef SPSST_END
#  define SPPSST_END		254
#  define SPPSST_ENDREPLY 	255
#endif

/*
 * Completion codes for SPP operations
 */

extern int sppResult;

#define SPPR_OK		0
#define SPPR_SHORT	1 /* buffer too short for logical record */
/* on errors, sppResult is set to -errno */

/*
 * Basic primitives
 */

/*descriptor=*/ extern int SPPCreateListener( /*port*/ );
/*descriptor=*/ extern int SPPAccept( /*listener, sockaddrp*/ );
/*descriptor=*/ extern int SPPConnect( /*addrp*/ );
/*success=*/ extern int SPPClose( /*s, initiate*/ );

/*nBytes=*/ extern int SPPRead( /*from, buf, nBytes, readToEM*/ );
/*nBytes=*/ extern int SPPWrite( /*to, buf, nBytes, setEM*/ );

/*
 * Command-oriented primitives
 */
 
/*cmd=*/ extern int RcvCmd( /*from, argBuf, bufLen*/ );
/*success=*/ extern int SendCmd( /*to, cmd, arg*/ );
/*success=*/ extern int SendCmdf( /*to, cmd, fmt, arg1, arg2, arg3*/ );

#define ACK	'Y'
#define		SendACK(to) SendCmd( (to), ACK, NULL )

#define NACK	'N'
#define		SendNACK(to, msg) SendCmd( (to), NACK, (msg) )

/*
 * File-transfer primitives
 */

#define XLATE_TEXT	1 /* file is text file */
#define XLATE_HTSP	2 /* translate tabs to spaces */

#define TABSIZE 8

/*nBytes=*/ extern int RcvFile( /*from, to, xlate, maxLineLength*/ );
/*nBytes=*/ extern int SendFile( /*to, from, maxBytes, xlate*/ );

