/*
 * RLoginShell.c
 *
 * Start the user's login shell.
 *
 * Believe USER, HOME, SHELL from environment.
 * Assume utmp, wtmp and lastlog entries already made.
 *
 * Print motd.
 * Check for mail.
 * Start login shell.
 *
 * Created by ajd on Sun Dec  8 13:46:40 PST 1985
 *
 * Last edited by AJD on Tue Dec 31 00:19:30 PST 1985
 */

#include <sys/types.h>

#include <lastlog.h>
#include <sgtty.h>
#include <signal.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/stat.h>

#define DEFAULT_SHELL	"/bin/sh"
#define LASTLOG_FILE	"/usr/adm/lastlog"
#define QUIETLOG_FILE	".hushlogin"

extern int errno;
extern char *getenv();
extern char *rindex();
extern char *malloc();

/*
 * string concatenation routine -- should be in library
 */
char *
CopyToNewString(arg0 /*, arg1, ..., argn, NULL*/ )
    char *arg0;
{
    char **argp;
    int length = 0;
    char *result;
    register char *from;
    register char *to;

    for( argp = &arg0; *argp != NULL; argp++ )
        length += strlen(*argp);
    length += 1;

    result = malloc(length);
    if( result != NULL ) {
        to = result;
        for( argp = &arg0; *argp != NULL; argp++ ) {
	    for( from = *argp; *from != 0; *to++ = *from++ ) ;
        }
	*to++ = 0;
    }
    return( result );
}


/*
 * motd printing stuff -- stolen from UCB
 */
int stopMotd = 0;
 
CatchMotd()
{
    signal(SIGINT, SIG_IGN);
    stopMotd = 1;
}

ShowMotd()
{
    FILE *mf;
    register c;

    signal(SIGINT, CatchMotd);
    if ((mf = fopen("/etc/motd", "r")) != NULL) {
	while( ((c = getc(mf)) != EOF) && (!stopMotd) )
	    putchar(c);
	fclose(mf);
    }
    signal(SIGINT, SIG_IGN);
}


#ifdef UNDEFINED
/* THIS JUST PRINTS THE CURRENT LOGIN, SIGH! */

/*
 * Last Login printing stuff -- stolen from UCB
 */
ShowLastLog()
{
    int f;
    struct lastlog ll;

    if( access(QUIETLOG_FILE, F_OK) == 0 ) return;
    if( (f = open(LASTLOG_FILE, O_RDONLY)) < 0 ) return;
    lseek(f, (long)getuid() * sizeof (struct lastlog), 0);
    if( (read(f, (char *) &ll, (sizeof ll)) == (sizeof ll))
            && (ll.ll_time != 0) ) {
	printf("Last login: %.*s ", 24-5, (char *)ctime(&ll.ll_time));
	if (*ll.ll_host != '\0') {
	    printf("from %.*s\n", sizeof (ll.ll_host), ll.ll_host);
	} else {
	    printf("on %.*s\n", sizeof (ll.ll_line), ll.ll_line);
	}
    }
    close(f);
}
#else
ShowLastLog() {}
#endif


/*
 * Check whether user has mail
 */

ShowMail()
{
    char *userName;
    char *spoolFileName;
    struct stat b;

    if( (userName = getenv("USER")) == NULL ) return;
    spoolFileName = CopyToNewString(SPOOL_DIR, "/", userName, NULL);
    if( stat(spoolFileName, &b) < 0 ) return;
    if( b.st_size == 0 ) return;
    printf("%sail in %s\n", (b.st_mtime > b.st_atime) ? "New m" : "M", spoolFileName);
}


/*
 * default tty modes
 */

struct	sgttyb ttyb;

int ldisc = 0;

struct	ltchars ltc = {
    CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT
};

struct	tchars tc = {
    CINTR, CQUIT, CSTART, CSTOP, CEOT, CBRK
};


/*
 * Execution begins here ...
 */

main()
{
    char *myHome;
    char *myShell;
    char *minusName;
    char *p;
    int t;
    static int zero = 0;

    signal(SIGQUIT, SIG_IGN);
    signal(SIGINT, SIG_IGN);

    for( t = getdtablesize(); t > 3; t-- ) close(t);

    ioctl(0, TIOCLSET, &zero);
    ioctl(0, TIOCNXCL, 0);
    ioctl(0, FIONBIO, &zero);
    ioctl(0, FIOASYNC, &zero);
    ioctl(0, TIOCGETP, &ttyb);
    ioctl(0, TIOCSLTC, &ltc);
    ioctl(0, TIOCSETC, &tc);
    ioctl(0, TIOCSETP, &ttyb);
    ioctl(0, TIOCSETD, &ldisc);

    umask(022);

    if( (myHome = getenv("HOME")) == NULL ) {
        printf("No HOME\n");
	exit(1); /*??*/
    }
    if( chdir(myHome) < 0 ) {
        printf("Can't chdir to %s\n", myHome);
	exit(1); /*??*/
    }

    if( (myShell = getenv("SHELL")) == NULL )
        myShell = DEFAULT_SHELL;

    p = rindex(myShell, '/');
    p = ((p != NULL) ? p+1 : myShell );
    minusName = CopyToNewString("-", p, NULL);
 
    if( strcmp(myShell,"/bin/csh") == 0 ) {
        ldisc = NTTYDISC;
        ioctl(0, TIOCSETD, &ldisc);
    }

    ShowLastLog();
    ShowMotd();
    ShowMail();

    signal(SIGALRM, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGINT, SIG_DFL);
    signal(SIGTSTP, SIG_IGN);

    execlp( myShell, minusName, 0 );
    perror( myShell );
    printf("Can't exec %s\n", myShell);
    exit(1);
}