/*
 * LoginOps.c ; dgr ajd cucs
 *
 * Unix side of XDE <--> Unix session initiation
 *  --> relevant parts of /bin/login, with a verified user
 *
 * Edited by AJD on Sat Jul 20 14:15:08 EDT 1985
 */

#include <sys/param.h>
#include <sys/quota.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/file.h>

#include <sgtty.h>
#include <utmp.h>
#include <signal.h>
#include <pwd.h>
#include <stdio.h>
#include <lastlog.h>
#include <errno.h>
#ifndef sel
#include <ttyent.h>
#endif
#include <ctype.h>
#include <syslog.h>

#define	SCMPN(a, b)	strncmp(a, b, sizeof(a))
#define	SCPYN(a, b)	strncpy(a, b, sizeof(a))

#define NMAX	sizeof(utmp.ut_name)

#define	FALSE	0
#define	TRUE	1

#ifdef DEBUG
  char	utmpName[] =	"/tmp/utmp";
  char	wtmpName[] =	"/tmp/wtmp";
  char	lastlog[] =	"/tmp/lastlog";
#else
  char	utmpName[] =	"/etc/utmp";
  char	wtmpName[] =	"/usr/adm/wtmp";
  char	lastlog[] =	"/usr/adm/lastlog";
#endif

char	nolog[] =	"/etc/nologin";
char	qlog[]  =	".hushlogin";
struct	sgttyb ttyb;
struct	utmp utmp;
char	minusnam[16] = "-";

char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	path[64] = DEF_PATH ;
char	term[64] = "TERM=";
char	user[20] = "USER=";
char	remotehost[64] = "HOST=";
char    workstation[50] = "WORKSTATION=";
char    session[24] = "SESSION=";

char	*envinit[] = {
    homedir,
    shell,
    path,
    term,
    user,
    remotehost,
    workstation,
    session,
    0 };

struct	passwd *pwd;
char	*strcat(), *rindex(), *index();
char	*ttyname();
char	*ttywhere();
char	*getenv();

extern	char **environ;
extern	int errno;

struct	tchars tc = {
	CINTR, CQUIT, CSTART, CSTOP, CEOT, CBRK
};

struct	ltchars ltc = {
	CSUSP, CDSUSP, CRPRNT, CFLUSH, CWERASE, CLNEXT
};

char	name[NMAX+1];

/*
 * DoLogin: complete the login process
 *
 * called from: RLoginStub
 *
 * arguments:
 *    pwd : pointer to (verified) password structure
 *    wsname : pointer to workstation address, in a string
 *
 * returns: negative values on fatal errors
 *
 * puts entries in utmp, wtmp, and builds the environment
 *
 */

int
DoLogin(pwd, wsname, sessionname, termType)
     struct passwd *pwd;
     char *wsname;
     char *sessionname;
{
	register char *namep;
	int t, f, c;
	int quietlog;
	FILE *nlfd;
	char *ttyn, *tty;
	int ldisc = 0, zero = 0;
	char logbuf[100];
	char *sessionstring;

	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	quota(Q_SETUID, 0, 0, 0);

	/* copy valid login name into utmp */
	SCPYN(utmp.ut_name, pwd->pw_name);

	/* copy ws name into utmp, WORKSTATION and HOST	*/
	/* strip socket number from utmp and HOST	*/
	/* TODO: ought to be an entry point in Address-	*/
	/* translation.c for this!			*/
	strncat(workstation, wsname, sizeof(workstation)-13);
	{ register char *p;
	    p = index(wsname, '.');
	    if( p != NULL ) p = rindex(p + 1, '.');
	    if( p != NULL ) *p = 0;
	    strncat(remotehost, wsname, sizeof(remotehost)-6);
	    SCPYN(utmp.ut_host, wsname);
	    if( p != NULL ) *p = '.';
	}

	/* copy session id and term into environment */
	strncat(session, sessionname, sizeof(session)-9);
	strncat(term, termType, sizeof(term)-6);



	ioctl(0, TIOCLSET, &zero);
	ioctl(0, TIOCNXCL, 0);
	ioctl(0, FIONBIO, &zero);
	ioctl(0, FIOASYNC, &zero);
	ioctl(0, TIOCGETP, &ttyb);
	ioctl(0, TIOCSLTC, &ltc);
	ioctl(0, TIOCSETC, &tc);
	ioctl(0, TIOCSETP, &ttyb);
	for (t = getdtablesize(); t > 3; t--)
		close(t);
	ttyn = ttyname(0);
	if (ttyn == (char *)0)
		ttyn = "/dev/tty??";
	tty = rindex(ttyn, '/');
	if (tty == NULL)
		tty = ttyn;
	else
		tty++;
	openlog("login", 0, 0);
	t = 0;

	ldisc = 0;
	ioctl(0, TIOCSETD, &ldisc);
	if (!strcmp(pwd->pw_shell, "/bin/csh")) {
	  ldisc = NTTYDISC;
	  ioctl(0, TIOCSETD, &ldisc);
	}
	
	/* find login shell and change to home directory */
	if (*pwd->pw_shell == '\0')
	  pwd->pw_shell = "/bin/sh";
	if (chdir(pwd->pw_dir) < 0) {
	  if (chdir("/") < 0) {
	    printf("No directory!\n");
	    return(-1);
	  } else {
	    printf("No directory! %s\n",
		   "Logging in with home=/");
	    pwd->pw_dir = "/";
	  }
	}

	if (quota(Q_SETUID, pwd->pw_uid, 0, 0) < 0) {
		if (errno == EUSERS)
			printf("%s.\n%s.\n",
			   "Too many users logged on already",
			   "Try again later");
		else if (errno == EPROCLIM)
			printf("You have too many processes running.\n");
		else
			perror("setuid");
		return(-1);
	}

	/* set utmp and wtmp */
	time(&utmp.ut_time);
	t = ttyslot();
	if (t > 0 && (f = open(utmpName, O_WRONLY)) >= 0) {
		lseek(f, (long)(t*sizeof(utmp)), 0);
		SCPYN(utmp.ut_line, tty);
		write(f, (char *)&utmp, sizeof(utmp));
		close(f);
	}
	if ((f = open(wtmpName, O_WRONLY|O_APPEND)) >= 0) {
		write(f, (char *)&utmp, sizeof(utmp));
		close(f);
	}
	quietlog = access(qlog, F_OK) == 0;
	if ((f = open(lastlog, O_RDWR)) >= 0) {
		struct lastlog ll;
		short tsline;

		lseek(f, (long)pwd->pw_uid * sizeof (struct lastlog), 0);
		if (read(f, (char *) &ll, sizeof ll) == sizeof ll &&
		    ll.ll_time != 0 && !quietlog) {
			printf("Last login: %.*s ",
			    24-5, (char *)ctime(&ll.ll_time));
			if (*ll.ll_host != '\0')
				printf("from %.*s\n",
				    sizeof (ll.ll_host), ll.ll_host);
			else
				printf("on %.*s\n",
				    sizeof (ll.ll_line), ll.ll_line);
		}
		lseek(f, (long)pwd->pw_uid * sizeof (struct lastlog), 0);
		time(&ll.ll_time);
#if defined (TIOCGTSLINE)		
		if(ioctl(0,TIOCGTSLINE,&tsline) >= 0)
			sprintf(utmp.ut_line,"ts%3d",tsline);
#endif			
		SCPYN(ll.ll_line, utmp.ut_line);
		SCPYN(ll.ll_host, utmp.ut_host);
		write(f, (char *) &ll, sizeof ll);
		close(f);
	}
	chown(ttyn, pwd->pw_uid, pwd->pw_gid);
	chmod(ttyn, 0622);
	setgid(pwd->pw_gid);
	strncpy(name, utmp.ut_name, NMAX);
	name[NMAX] = '\0';
	initgroups(name, pwd->pw_gid);
	quota(Q_DOWARN, pwd->pw_uid, (dev_t)-1, 0);
	setuid(pwd->pw_uid);

	/* set up environment */
	environ = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, pwd->pw_shell, sizeof(shell)-7);
	strncat(user, pwd->pw_name, sizeof(user)-6);

	if ((namep = rindex(pwd->pw_shell, '/')) == NULL)
		namep = pwd->pw_shell;
	else
		namep++;
	strcat(minusnam, namep);
	umask(022);
	if (!quietlog)
		showmotd();

	signal(SIGALRM, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGINT, SIG_DFL);
	signal(SIGTSTP, SIG_IGN);

	/* overlay shell */
	execlp(pwd->pw_shell, minusnam, 0);
	/* error in exec */
	perror(pwd->pw_shell);
	printf("No shell\n");
	exit(1);
} /* end DoLogin */

int	stopmotd;
catch()
{

	signal(SIGINT, SIG_IGN);
	stopmotd++;
}

showmotd()
{
	FILE *mf;
	register c;

	signal(SIGINT, catch);
	if ((mf = fopen("/etc/motd", "r")) != NULL) {
		while ((c = getc(mf)) != EOF && stopmotd == 0)
			putchar(c);
		fclose(mf);
	}
	signal(SIGINT, SIG_IGN);
}


/*
 * DoLogout:
 *
 * called from: RLoginStub
 *
 * arguments:
 *    ptyLine, ttyLine : names of pty/tty
 *
 * returns: always returns 0
 *
 * removes entries from utmp, wtmp
 *
 */

int
DoLogout(ptyLine, ttyLine)
    char *ptyLine;
    char *ttyLine;
{
    static struct utmp wtmp;
    register f;
    int found = 0;
    char *ttyName;

	if( (ttyName = rindex(ttyLine, '/')) == NULL)
	    ttyName = ttyLine;
	else
	    ttyName++;

	f = open(utmpName, O_RDWR);
	if (f >= 0) {
		while(read(f, (char *)&wtmp, sizeof (wtmp)) == sizeof (wtmp)) {
			if (SCMPN(wtmp.ut_line, ttyName) || wtmp.ut_name[0]==0)
				continue;
			lseek(f, -(long)sizeof (wtmp), 1);
			SCPYN(wtmp.ut_name, "");
			SCPYN(wtmp.ut_host, "");
			time(&wtmp.ut_time);
			write(f, (char *)&wtmp, sizeof (wtmp));
			found++;
		}
		close(f);
	}
	if (found) {
		f = open(wtmpName, O_WRONLY);
		if (f >= 0) {
			SCPYN(wtmp.ut_line, ttyName);
			SCPYN(wtmp.ut_name, "");
			SCPYN(wtmp.ut_host, "");
			time(&wtmp.ut_time);
			lseek(f, (long)0, 2);
			write(f, (char *)&wtmp, sizeof (wtmp));
			close(f);
		}
	}
        chmod(ttyLine, 0666);
	chown(ttyLine, 0, 0);
	chmod(ptyLine, 0666);
	chown(ptyLine, 0, 0);

	return(0);
}

