/*
 * Program to do V7-style locking on mail directory
 *
 * Must run suid root if /usr/spool/mail is write-protected.
 *
 * Usage:
 *   LockMail /usr/spool/mail/me -l
 *   LockMail /usr/spool/mail/me -u
 *
 * Very paranoid about protections, but who knows ...
 *
 * TODO: Fix to use CommandOps.h
 *
 * Fri Jul  5 17:10:09 EDT 1985
 */

#ifdef DEBUG
#   define SPOOLDIR "./"
#else
#   define SPOOLDIR "/usr/spool/mail/"
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sysexits.h>
#include <errno.h>


#define NULL 0

#define LOCK_EXT ".lock"
#define EXTLEN 5 /* strlen(LOCK_EXT) */

#define MBOXNAMELEN 100
#define LOCKNAMELEN (MBOXNAMELEN+EXTLEN)

char *getenv();
char *index();

/* Band-Aid eliminates loader error in libra.a */
static void NeverCalled() { (void)fopen("/dev/null","r"); }
/* diA-dnaB */

extern int errno;

char mboxName[MBOXNAMELEN] = SPOOLDIR;
char lockName[LOCKNAMELEN];

main(argc,argv)
    int argc;
    char **argv;
{
    char *myName;
    struct stat b;
    char flag;
    int lockFildes;

    if( (argc != 2) || (strlen(argv[1]) != 2) || (argv[1][0] != '-') )
        exit(EX_USAGE);

    flag = argv[1][1];

    if( (myName = getenv("USER")) == NULL )
        exit(EX_UNAVAILABLE);
    if( index(myName,'/') != NULL )
        exit( EX_NOPERM );

    strncat( mboxName, myName, (sizeof mboxName)-strlen(mboxName)-1 );
    strcpy( lockName, mboxName );
    strcat( lockName, LOCK_EXT );
    
    if( stat(mboxName, &b) < 0 )
        exit( EX_UNAVAILABLE );
    if( b.st_uid != getuid() )
        exit( EX_NOPERM );

    switch( flag ) {
        case 'l':
	    lockFildes = open( lockName, (O_CREAT|O_RDWR|O_EXCL), 0600 );
	    if( lockFildes < 0 )
		exit( (errno == EEXIST ) ? EX_TEMPFAIL : EX_CANTCREAT );
	    close( lockFildes );
	    break;
	case 'u':
	    if( stat(lockName, &b) < 0 )
	        exit( EX_NOINPUT );
	    if( (b.st_mode & S_IFMT) != S_IFREG )
	        exit( EX_NOPERM );
	    if( unlink(lockName) < 0 )
	        exit( EX_IOERR );
	    break;
	default:
	    exit( EX_USAGE );
    }
    
    exit( EX_OK );

}