/*
 * LRMail - primitive mail tool compatible with XDE bridge mail system
 *
 * Last edited by AJD on Thu Dec 12 17:48:36 PST 1985
 */

#include <signal.h>
#include <stdio.h>
#include <sys/file.h>
#include <sysexits.h>

#include "CommandOps.h"
#include "MsgHeap.h"
#include "RMailOps.h"

#define MAIL_HEAP_NAME "mail"
#define NEW_MAIL_MSGSET "newmail.toc"
#define MSGSET_EXTENSION ".toc"

#define MAX_MSGS	300
#define MAX_NEW_MSGS	200

char *rindex();

int mailHeap = -1;

/*
 * Table of Contents array.
 * Internal "index" values are in [0..nToC).
 * User-visible "message numbers" are in [1..nToC].
 */
 
typedef struct {
    int msgID;
    char flag;
    char description[1];
} ToCLine;

#define LINE_SIZE_FOR_DESC_LEN(len) (sizeof(ToCLine) + (len))

ToCLine *(toCLine[MAX_MSGS]);
int nToC = 0;

char *toCName = NEW_MAIL_MSGSET;
FILE *toCFile = NULL;

int
ReadToC()
{
    char lineBuf[1024];
    char theFlag;
    int theMsgID;
    int answer;
    register ToCLine *p;

    toCFile = fopen( toCName, "a+" );
    fseek( toCFile, 0L, L_SET );
    if( toCFile == NULL ) return( -1 );
    for(;;) {
        answer = fscanf(toCFile,"%c%d %[^\n]%*c",&theFlag, &theMsgID, lineBuf);
	if( answer != 3 ) break;
	if( nToC >= MAX_MSGS ) return( -1 );
	toCLine[nToC++] = p =
	    (ToCLine *)malloc(LINE_SIZE_FOR_DESC_LEN(strlen(lineBuf)));
	p->flag = theFlag;
	p->msgID = theMsgID;
	strcpy(p->description, lineBuf);
    }
    return(nToC);
}

int
CompressToC()
{
    register int iFrom;
    register int iTo;
    register ToCLine *p;

    for( iFrom = iTo = 0; iFrom < nToC; iFrom++ ) {
        p = toCLine[iFrom];
	if( FlagIsDeleted(p->flag) )
	    free(p);
	else
	    toCLine[iTo++] = p;
    }
    nToC = iTo;
}

int
PrintToCLine(p, f)
    register ToCLine *p;
    FILE *f;
{
    fprintf( f, "%c%d %s\n", p->flag, p->msgID, p->description );
}

int
WriteToC()
{
    register int i;
    register ToCLine *p;

    if( toCFile == NULL ) return;
    fseek( toCFile, 0L, L_SET );
    for( i = 0; i < nToC; i++ ) {
        p = toCLine[i];
        PrintToCLine( p, toCFile );
	free(p);
    }
    nToC = 0;
    fflush( toCFile );
    ftruncate( fileno(toCFile), ftell(toCFile) );
    fsync( fileno(toCFile) );
    fclose( toCFile );
    toCFile = NULL;
}


int
Cleanup()
{
    WriteToC();
    if( mailHeap >= 0 ) {
        if( CheckDirtyMsgHeap(mailHeap) >= 0 )
	    WriteMsgHeap(mailHeap);
	ReleaseMsgHeap(mailHeap);
    }
    exit(EX_OK);
}


main(argc,argv)
    int argc;
    char **argv;
{

	if( ParseArgs(argc, argv,
		"[-m msgSetName]",
		"-ms", &toCName,
		0 ) < 0 )
	    exit( EX_USAGE );

        printf("\nLRMail of Thu Dec 12 1985\n\n");

	signal( SIGINT, SIG_IGN );
	signal( SIGQUIT, Cleanup );
	signal( SIGHUP, Cleanup );

	if( ReadToC() < 0 ) {
	    fprintf(stderr, "Can't read message set %s\n", toCName);
	    exit(EX_UNAVAILABLE);
	}
	printf("%d old messages\n\n", nToC );

	mailHeap = AcquireMsgHeap( NULL, MAX_NEW_MSGS );
	if( mailHeap < 0 ) {
	    fprintf(stderr, "Can't acquire mail heap\n");
	    exit(EX_UNAVAILABLE);
	}

	(void)CommandLoop();

	Cleanup();
	/*NOTREACHED*/
}


int stopPrint;

StopPrint()
{
    signal( SIGINT, SIG_IGN );
    stopPrint = 1;
}

int
PrintMsg( index, f )
    int index;
    FILE *f;
{
    char buf[1024];
    int cc;
    int desiredMsgID = toCLine[index]->msgID;

    if( OpenMsg(mailHeap,desiredMsgID) != desiredMsgID ) {
        printf("Can't get message %d (%d)\n", index+1, desiredMsgID);
	return;
    }

    stopPrint = 0;
    signal( SIGINT, StopPrint );

    printf("\nMessage %d -\n", index+1);
    while( (cc = ReadMsg(mailHeap, buf, (sizeof buf))) > 0 ) {
      register int i;
        for( i = 0; i < cc; i++ ) {
	    if( stopPrint ) goto out;
	    fputc( buf[i], f );
        }
    }

  out:
    signal( SIGINT, SIG_IGN );
    (void)CloseMsg(mailHeap);
}


int
GetNewMail()
{
    char *spoolFileName;
    FILE *f;
    int answer;

    spoolFileName = SetSpoolFileName(NULL, NULL);
    if( spoolFileName == NULL ) {
        fprintf(stderr, "Can't set spool file name.\n");
	return(-1);
    }
    f = fopen( NEW_MAIL_MSGSET, "a" );
    if( f == NULL ) {
        fprintf( stderr, "Can't add to message set %s.\n", NEW_MAIL_MSGSET );
	return(-2);
    }
    answer = LockMailService(LOCK_TYPE);
    if( answer < 0 ) {
        fprintf(stderr, "Error %d locking mail service.\n", -answer );
	return(answer);
    } else if( answer == 0 ) {
        fprintf(stderr, "Mail service busy.\n"); 
	return(0);
    }
    answer = RetrieveMail( f, mailHeap, /*deleteFromSpool=*/ 1);
    (void)UnlockMailService();
    fclose(f);
    if( answer < 0 ) {
        fprintf(stderr, "Error %d retrieving mail.\n", answer);
    } else {
        printf("Retrieved %d messages\n", answer);
    }
    return( answer );
}

/*
 * If arg non null, set message index *ip for message no atoi(arg),
 * otherwise set *ip := *ip + delta.
 */
int
SetMsgIndex(ip,arg,delta)
    int *ip;
    char *arg;
    int delta;
{
    int temp = ( (arg[0] == 0) ? *ip + 1 + delta : atoi(arg) );
    if( (temp <= 0) || (temp > nToC) ) {
        printf("Invalid message number %d\n", temp);
	return(-1);
    }
    return(*ip = (temp - 1));
}

int
CommandLoop()
{
    char cmdBuf[1024];
    char *argCursor;
    char *cmd;
    char *arg1;
    char *arg2;
    int index = 0;
#   define SETMSGINDEX(d) if( SetMsgIndex(&index,arg1,d) < 0 ) continue 

	for(;;) {
	    printf("\n: ");

	    cmdBuf[0] = 0;
	    gets( argCursor = cmdBuf );
	    while( *argCursor == ' ' ) argCursor++;

	    if( argCursor[0] == '!' ) {
	        system(argCursor+1);
		continue;
	    }
	    
	    cmd = GetToken(&argCursor);
	    arg1 = GetToken(&argCursor);
	    arg2 = GetToken(&argCursor);

	    switch(cmd[0]) {

		case 'h': {
		    int limit;
		    SETMSGINDEX(0);
		    index -= (index%10);
		    limit = index + 10;
		    if( limit > nToC ) limit = nToC;
		    for( ; index < limit; index++ ) {
		        printf("%3d: %c %s\n", index+1,
			    toCLine[index]->flag,
			    toCLine[index]->description );
		    }
		    break; }

		case 'm': {
		    int child;
		    if( arg1[0] == 0 ) {
		        printf("Send mail to whom?\n");
			break;
		    }
		    if( (child = fork()) < 0 ) {
		        printf("Can't fork()!\n");
			break;
		    }
		    if( child == 0 ) {
		        execlp("mail", "mail", arg1, 0);
			exit(0);
		    }
		    while( wait(0) >= 0 ) ;
		    break; }

		case 'd':
		    SETMSGINDEX(0);
		    toCLine[index]->flag =
		            FlagForDeleted(toCLine[index]->flag);
		    if( cmd[1] != 'p' ) break;
		    /* FALL THRU TO PRINT */

		case 'p':
		    SETMSGINDEX(1);
		    if( FlagIsDeleted(toCLine[index]->flag) ) {
		        printf("Deleted\n");
			break;
		    }
		    toCLine[index]->flag =
		            FlagForRead(toCLine[index]->flag);
		    PrintMsg( index, stdout );
		    break;

		case 's': {
		    FILE *f;
		    char *extension;
		    SETMSGINDEX(0);
		    if( arg2[0] == 0 ) {
		        printf("File name?\n");
			break;
		    }
		    if( FlagIsDeleted(toCLine[index]->flag) ) {
		        printf("Deleted\n");
			break;
		    }
		    f = fopen( arg2, "a" );
		    if( f == NULL ) {
		        printf("Can't create file\n");
			break;
		    }
		    toCLine[index]->flag =
		            FlagForCopied(toCLine[index]->flag);
		    if( ((extension = rindex(arg2,'.')) != NULL)
		            && (strcmp(extension,MSGSET_EXTENSION) == 0) )
			PrintToCLine( toCLine[index], f );
		    else
		        PrintMsg( index, f );
		    fflush(f); fsync(fileno(f)); fclose(f);
		    printf("Msg %d appended to %s\n", index+1, arg2);
		    break; }

		case 'u':
		    SETMSGINDEX(0);
		    toCLine[index]->flag =
		            FlagForUndeleted(toCLine[index]->flag);
		    break;

		case '?':
		    printf("d(elete n\n");
		    printf("g(etNewMail\n");
		    printf("h(eader n\n");
		    printf("m(ailTo addressee\n");
		    printf("p(rint n\n");
		    printf("q(uit\n");
		    printf("s(aveToFile n fileName\n");
		    printf("u(ndelete n\n");
		    printf("x(punge\n");
		    printf("! commandToShell\n");
		    break;

	        case 'g': {
		    int newIndex = nToC-1;
		    WriteToC();
		    if( GetNewMail() >= 0 ) {
		        if( strcmp(toCName, NEW_MAIL_MSGSET) == 0 ) {
			    index = newIndex;
			} else {
			    toCName = NEW_MAIL_MSGSET;
			    index = 0;
		        }
		    }
		    ReadToC();
		    break; }
		
		case 'q':
		    goto out;

	        case 'x':
		    CompressToC();
		    WriteToC();
		    ReadToC();
		    index = 0;
		    break;

		default:
		    printf("%s ?\n", cmd);
		    break;
	    }
	}

    out:
        return(0);
}

int
FlagForDeleted(c)
{
    switch(c) {
        case 'C': case 'M': return('M');
	default: return('D');
    }
}

int
FlagIsDeleted(c)
{
    switch(c) {
        case 'D': case 'M': return(1);
	default: return(0);
    }
}

int FlagForUndeleted(c)
{
    switch(c) {
        case 'M': return('C');
	case 'D': return('R');
	default: return(c);
    }
}

int
FlagForRead(c)
{
    switch(c) {
        case 'U': return('R');
	default: return(c);
    }
}

int
FlagForCopied(c)
{
    switch(c) {
        case 'D': case 'M': return('M');
	default: return('C');
    }
}