/*
 * FTPCmds.c - FTP commands for stubs
 * $Header: FTPCmds.c,v 1.2 86/12/16 12:11:14 jqj Exp $
 *
 * $Log:	FTPCmds.c,v $
 * Revision 1.2  86/12/16  12:11:14  jqj
 * When writing a UNIX file, first try to do it by copy-rename, and only if
 * that fails do the write in place.  Also, fsync().
 * 
 * Edited by AJD on Thu Dec  5 20:08:05 PST 1985
 */

#include <sys/types.h>

#include <errno.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/stat.h>

#include "NetworkStream.h"
#include "StubOps.h"

int FTPifd = -1; /* current input file descriptor */
int FTPofd = -1; /* current output file descriptor */
int FTPxlate = XLATE_TEXT; /* default file type is text */
int FTPMaxLineLength = 0; /* max line length for text files, 0 ==> infinite */
static char *EffectiveFileName;	/* name actually used in open( */
static char *RealFileName;	/* if non-null, rename EffectiveFileName to */
				/* RealFileName on close */

char *index();
extern int errno;
extern char *sys_errlist[];

int
FTPCmds(s, cmd, arg)
    int s; /* socket descriptor */
    char cmd; /* 1-character command from workstation */
    char *arg; /* argument ptr */
{
    int returnCode = 1;
    int oflags;

	switch( cmd ) {


	    case 'I': { /* (filename) : Open file for Input */
	        struct stat statBuf;

	        if( FTPifd >= 0 ) close(FTPifd);
		FTPifd = open(arg,O_RDONLY|O_NDELAY,0);
		if( FTPifd < 0 ) {
		    SendCmdf(s, NACK, ((errno == ENOENT)
		        ? "File nonexistent"
		        : "Input open error: (%d) %s"), errno,
				sys_errlist[errno]);
		} else if( fstat(FTPifd, &statBuf) < 0 ) {
		    SendCmdf(s, NACK, "Stat error: (%d) %s", errno,
		    	     sys_errlist[errno]);
		} else {
		    SendCmdf(s, ACK, "%d.%d",
		            statBuf.st_ino, statBuf.st_mtime);
		}
	      	break; }

	    case 'i': /* Close current input file */
	        if( FTPifd >= 0 ) close(FTPifd);
		FTPifd = -1;
		SendACK(s);
		break;

	    case 'R': /* () : Read current input file */ {
	        struct stat b;
	        if( fstat(FTPifd,&b) < 0 ) {
		    SendCmdf(s, NACK, "Stat error: (%d) %s", errno,
		    	     sys_errlist[errno]);
		} else if( ( SendCmdf(s, 'D', "%d", b.st_size) < 0 ) 
	                || ( SendFile(s, FTPifd, b.st_size, FTPxlate) < 0 ) ) {
		    returnCode = -1;
		    /* N.B. the data itself is supposed serve as ACK */
		}
		break; }


	    case 'A': /* (filename) : Open file for Append */
	        oflags = (O_WRONLY|O_CREAT|O_APPEND);
		EffectiveFileName = arg;	/* update in place */
		goto openForOutput;

	    case 'N': /* (filename) : Open New file for Output */
	        oflags = (O_WRONLY|O_CREAT|O_EXCL);
		/* update in place, since there's no file here to smash */
		EffectiveFileName = arg;
		goto openForOutput;

	    case 'O': /* (filename) : Open file for Output */
	        oflags = (O_WRONLY|O_CREAT|O_TRUNC);
		EffectiveFileName = arg;
		goto openForOutput;
		
		/* the following code is an attempt to work around truncations */
		{   register int i=strlen(arg);
		    extern char *malloc(), *strcpy();
		    RealFileName = strcpy(malloc(1+i), arg);
		    EffectiveFileName = strcpy(malloc(7+i), arg);
		    strcpy(EffectiveFileName+i, "XXXXXX");
		}
		mktemp(EffectiveFileName);
	        oflags = (O_WRONLY|O_CREAT|O_TRUNC);
	        if( FTPofd >= 0 ) close(FTPofd);
		FTPofd = open(EffectiveFileName, oflags, 0666);
		if ( FTPofd < 0 && 
		     (errno == EACCES || errno == ENAMETOOLONG) ) {
		    /* can't create temp file, so update in place */
		    free(RealFileName);
		    free(EffectiveFileName);
		    RealFileName = (char *) 0;
		    EffectiveFileName = arg;
		    goto openForOutput;
		}
		else goto openErrorCheck;

	    openForOutput:
	        if( FTPofd >= 0 ) close(FTPofd);
		FTPofd = open(EffectiveFileName, oflags, 0666);
	    openErrorCheck:
		if( FTPofd >= 0 )
		    SendACK(s);
		 else
		    SendCmdf(s, NACK, "Write failed: (%d) %s", errno,
		    	     sys_errlist[errno]);
		break;

	    case 'o': { /* Close current output file */
	        struct stat statBuf;
		if( FTPofd < 0 ) {
		    SendCmdf(s, NACK, "No open output file");
		    break;
		}
		if ( RealFileName ) {
		    if (rename(EffectiveFileName, RealFileName) < 0) {
			SendCmdf(s, NACK, "Rename failed: (%d) %s", errno,
		    	     sys_errlist[errno]);
			free(EffectiveFileName);
			free(RealFileName);
			RealFileName = EffectiveFileName = (char *) 0;
			break;
		    }
		    free(EffectiveFileName);
		    free(RealFileName);
		    RealFileName = EffectiveFileName = (char *) 0;
		}
		if( fsync(FTPofd) < 0 ) {
		    SendCmdf(s, NACK, "Fsync failed: (%d) %s", errno,
		    	     sys_errlist[errno]);
		} else if( fstat(FTPofd, &statBuf) < 0 ) {
		    SendCmdf(s, NACK, "Stat failed: (%d) %s", errno,
		    	     sys_errlist[errno]);
		} else {
		    SendCmdf(s, ACK, "%d.%d",
		            statBuf.st_ino, statBuf.st_mtime);
		}
		close(FTPofd);
		FTPofd = -1;
		break; }

	    case 'W': /* (lengthHint,data) : Write to current output file */ {
	        int nr, nh; 
	        nr = RcvFile(s, FTPofd, FTPxlate, FTPMaxLineLength);
	        if( nr < 0 )
		    SendCmdf(s, NACK, "I/O error: (%d) %s", errno,
		    	     sys_errlist[errno]);
		else if( (arg[0] != 0) && ((nh = atoi(arg)) != nr) )
		    SendCmdf(s, NACK, "Len error: %d/%d", nh, nr);
		else
	            SendACK(s);
		break; }


	    case 'E': /* (filename) : ErasE / ElidE / dElEtE a file */
	        if( unlink(arg) < 0 )
		    SendCmdf(s, NACK, "Cannot delete file: (%d) %s", errno,
		    	     sys_errlist[errno]);
		else
		    SendACK(s);
	        break;


	    case 'C': /* Copy from current input file to current output file */
	        if( CopyLocally(FTPifd, FTPofd) >= 0 )
	            SendACK(s);
		else
		    SendCmdf(s, NACK, "I/O error: (%d) %s", errno,
		    	     sys_errlist[errno]);
		break;


	    case 'M': /* (from to) : Move (atomically renaMe) file */ {
	        register char *from, *to;
		from = arg;
		if( (to = index(arg, ' ')) != NULL ) {
		    while( *to == ' ' ) *to++ = 0;
		    if( *to == 0 ) to = NULL;
		}
		if( to == NULL ) {
		    SendCmdf(s, NACK, "Protocol error: no \"to\"");
		} else if( rename(from,to) != 0 ) {
		    SendCmdf(s, NACK, "Rename failed: (%d) %s", errno,
		    	     sys_errlist[errno]);
		} else {
		    SendACK(s);
		}
		break; } 


	    case 'X': /* ([XxTtL123]) : set Xlate flag */ {
		char *ap = arg;
		char c;
		while( (c = *ap++) != 0 ) {
		    switch( c ) {
		        case 'X':
			    FTPxlate |= XLATE_TEXT;
			    break;
			case 'x':
			    FTPxlate &= ~XLATE_TEXT;
			    break;
			case 'T':
			    FTPxlate |= XLATE_HTSP;
			    break;
			case 't':
			    FTPxlate &= ~XLATE_HTSP;
			    break;
			case 'L':
			    FTPMaxLineLength = 0;
			    for( c = *ap; (c>='0') && (c<='9'); c = *++ap ) {
			        FTPMaxLineLength =
				        FTPMaxLineLength * 10 + (c - '0');
			    }
			    break;
			default:
			    goto Xbad;
		    }
		}
	      Xgood:
		SendACK(s);
		break;
	      Xbad:
	        SendCmdf(s, NACK, "Bad XLate arg: %c", c);
		break; }


	    default:
		returnCode = 0;
		break;
	}

out:
    return(returnCode);
}


/*
 * Copy between local files.
 *
 * N.B. on erroneous returns errno indicates failure reason.
 */
int
CopyLocally(ifd, ofd)
    int ifd; /* input file descriptor */
    int ofd; /* output file descriptor */
{
    char buf[4096];
    int cc, wcc;
    int nread = 0;
    char *p;

    while( (cc = read(ifd, buf, (sizeof buf))) > 0 ) {
        p = buf;
	while( cc > 0 ) {
	    if( (wcc = write(ofd, p, cc)) < 0 ) return(wcc);
	    p += wcc;
	    cc -= wcc;
	}
    }
    return( (cc < 0) ? cc : nread );
}
