/*
 * CommandOps.h
 *
 * Created by AJD on Sun Jul  7 19:19:19 EDT 1985
 */

#ifdef UNDEFINED /* strip comment in cpp */
/*
 *
 * A standard mechanism for parsing command arguments.
 *
 * Usage:
 *
 *   if( ParseArgsV( argc, argc, usageMsg, argFmt ) < 0 ) exit(-1);
 *
 *
 * argFmt is a null-terminated array string entries "-cxx..." where
 *
 * -c is a recognized flag
 *
 * characters in xxx may be any of
 *
 *   B : a Boolean, next fmt entry is address of int, gets 1.
 *
 *   b : an (inverted) Boolean, next fmt entry is address of int, gets 0.
 * 
 *   s : next arg is string, next fmt entry is address of char*, gets it.
 *
 *   d : next arg is number, next fmt entry is address of int, gets it.
 *
 *   * : consumes all arguments until next flag, next fmt entry
 *       is address of an argc,argv pair in memory, gets description
 *       of args.
 *
 *   + : like *, but requires there be at least one argument.
 *
 *   ? : like *, but allows at most one argument.
 *
 *   $ : consumes all remaining arguments (flags or not), next fmt entry
 *       is address of an argc,argv pair in memory, gets description
 *       of args.
 *
 *   # : like $, but requires there be at least one argument.
 *
 * The final (non-NULL) entry describes non-flag command arguments.
 * Its -c part is omitted.
 *
 * Simple Example:
 *
 * char usageMsg[] = "[-t tStringArgument] from to otherthing ...";
 *
 * char *(argFmt[]) = {
 *	"-tBs",	(char *)(&tflag),	(char *)(&tstring),
 *	"ss*",	(char *)(&fromName),	(char *)(&toName),
 *					(int *)(&argcArgvPair),
 *	0 };
 *
 *
 * Alternative entry point ParseArgs allows argFmt to be put inline
 * in the argument list, e.g.
 *
 * ... ParseArgs( argc, argv,	"[-t tStringArgument] from to",
 *		"-tBs",	(char *)(&tflag),	(char *)(&tstring),
 *		"ss",	(char *)(&fromName),	(char *)(&toName),
 *		0 ) ...
 *
 * is equivalent to the previous example.
 */
#endif


extern int ParseArgs(
	/* aArgc, aArgv, aUsageMsg, aArgFmt0, aArgFmt1, ..., 0 */);

extern int ParseArgsV(
	/* aArgc, aArgv, aUsageMsg, aArgFmt */);




/*
 * token scanner:	return pointer to next token,
 *			update *pCursor beyond it.
 */
 
/*token=*/ extern char * GetToken(/*char **pCursor*/);




/*
 * Primitives for dealing with environments
 */

/*value=*/ extern char *GetEnv(/* char *entryName */);
/*void*/ extern SetEnv(/* char *name, char *value */);
/*void*/ extern SetEnvI(/* char *name, int value */);
