/*
 * AliasExp.c
 *
 * Mail tool alias expansion
 *
 * Created by AJD on Sat Dec 21 17:56:56 PST 1985
 * Last edited by AJD Tue Dec 31 12:30:30 PST 1985
 */

#include <ctype.h>
#include <stdio.h>


char defaultNameSuffix[] = "/.mailrc";

extern char * malloc();
extern char * getenv();


/*
 * aliases maintained as singly-linked list in memory
 */

struct AliasEntry {
    struct AliasEntry * next;
    char * lhs;
    char * rhs;
    char buffer[1];
};

#define ENTRY_LEN_FOR_BUF_LEN(n) \
	( sizeof(struct AliasEntry) + (n) ) /* leaves a little slop */

struct AliasEntry * aliases = NULL;


int
AliasExpInit(fileName)
    char *fileName; /* optional, used in place of .mailrc */
{
    int answer = -1;
    FILE *rcFile = NULL;

    if( aliases != NULL ) return(0);

    if( fileName != NULL ) {
        rcFile = fopen(fileName, "r");
    } else {
        char *home;
	char *nameBuf;
	if( (home = getenv("HOME")) == NULL ) goto out; 
	nameBuf = malloc( strlen(home) + (sizeof defaultNameSuffix) );
	strcpy(nameBuf, home);
	strcat(nameBuf, defaultNameSuffix);
	rcFile = fopen(nameBuf, "r");
	free(nameBuf);
    }
    if( rcFile == NULL ) goto out;

    answer = LoadAliasesFromFile(rcFile);

out:
    if( rcFile != NULL ) fclose(rcFile);
    return( answer );
}


int
LoadAliasesFromFile(rcFile)
    FILE * rcFile;
{
    char lineBuf[1024];
    char *keyword;
    register char *lhs;
    register char *rhs;
    register char *p;
    int len;
    struct AliasEntry *ep;

    while( fgets(lineBuf, (sizeof lineBuf), rcFile) != NULL ) {
	p = lineBuf;

	while( (*p) && isspace(*p) ) p++;
	keyword = p;
	while( (*p) && !isspace(*p) ) p++;
	if( *p ) *p++ = 0;

	if( strcmp("alias", keyword) ) continue;

	len = strlen(p);
	if( (len > 0) && (p[len-1] == '\n') ) {
	    len--;
	    p[len] = 0;
	}

	while( (*p) && isspace(*p) ) p++;
	lhs = p;
	while( (*p) && !isspace(*p) ) p++;
	if( *p ) *p++ = 0;

	while( (*p) && isspace(*p) ) p++;
	rhs = p;

	if( (*lhs == 0) || (*rhs == 0) ) continue;

	ep = (struct AliasEntry *)(malloc(ENTRY_LEN_FOR_BUF_LEN(len)));
	p = &(ep->buffer[0]);
	ep->lhs = p;
	while( *lhs ) *p++ = *lhs++;
	*p++ = 0;
	ep->rhs = p;
	while( *rhs ) *p++ = *rhs++;
	*p++ = 0;
	ep->next = aliases;
	aliases = ep;
    }
    return ((aliases != NULL) ? 0 : -1 );
}


char *
LookUpAlias( rawAddress )
    char * rawAddress;
{
    register struct AliasEntry * ep;
    for( ep = aliases; ep != NULL; ep = ep->next ) {
        if( strcmp(rawAddress,ep->lhs) == 0 ) return( ep->rhs );
    }
    return( NULL );
}


char *
AliasExp( rawBuf )
    char *rawBuf;
{
    int found = 0;
    register char *pRaw;
    register char *pCooked;
    register char *p;
    char *rawAddress;
    static char cookedBuf[2048];

    pRaw = rawBuf;
    pCooked = cookedBuf;
    for(;;) {
        /* get beginning of address */
        while( (*pRaw) && isspace(*pRaw) ) pRaw++;
	if( (*pRaw) == 0 ) break;
	rawAddress = pRaw;
	/* get end of address */
	while( (*pRaw) && (*pRaw != ',') ) pRaw++;
	/* strip trailing white space */
	for( p = pRaw-1; (p >= rawAddress) && isspace(*p); p-- ) *p = 0; 
	/* smash delimiter */
	if( *pRaw ) *pRaw++ = 0;
	/* convert address */
	if( *rawAddress == 0 ) continue;
	if( (p = LookUpAlias(rawAddress)) == NULL ) {
	    p = rawAddress;
	} else {
	    found = 1;
	}
        if( pCooked > cookedBuf ) {
	    *pCooked++ = ',';
	    *pCooked++ = ' ';
	}
	while( *p ) *pCooked++ = *p++;
    }
    *pCooked++ = 0;
    return( found ? cookedBuf : NULL );
}

#ifdef TEST
/* This will be deleted soon */
PrintAliases()
{
    register struct AliasEntry * ep;
    printf("Alias table:\n\n");
    for( ep = aliases; ep != NULL; ep = ep->next ) {
        printf("%s -> %s\n\n", ep->lhs, ep->rhs);
    }
}

PrintExpansion(s)
    char *s;
{
    char rawbuf[100];
    char *expansion;

    strcpy(rawbuf, s);
    expansion = AliasExp(rawbuf);
    if( expansion == NULL )
        printf("Expansion: %s not changed\n\n", s);
    else
        printf("Expansion: %s -> %s\n\n", s, expansion );
}

main(argc,argv)
    char **argv;
{
    int ans;
    
    ans = AliasExpInit(NULL);
    printf("InitAliasExp(NULL) returned %d\n\n\n");
    PrintAliases();
    PrintExpansion("demers");
    PrintExpansion("foo");
    PrintExpansion("me");
    PrintExpansion("sue");
    PrintExpansion("us");
    PrintExpansion("me,sue");
    exit(0);
}
#endif
