/*
 * AddressTranslation.c - Adapted from early version of JQJ's courier library.
 *
 * $Log:	AddressTranslation.c,v $
 * Revision 1.2  86/11/03  13:16:40  jqj
 * Reinstalled ns_netof() to allow compilation under 4.2BSD
 * 
 *
 * Converted to 4.3BSD Thu Jul 11 16:00:29 EDT 1985
 * GOULD port 10/16/85 WAN
 */


#include <sys/types.h>
#include <sys/socket.h>

#ifdef BSD43
# include <netns/ns.h>
# ifndef ns_netof 
  /* Gould machine doesn't have this defined because of possible alignment */
  /* problems, but that's no problem here. */
# define ns_netof(a) (*(long *) & ((a).x_net))
# endif
# define c_hostof(a) (a).x_host.c_host
#endif
#ifdef BSD42
# include <netxns/xn.h>
# define ns_addr xn_addr
# define ns_netof(a) xnnet((a).xn_net)
# define x_port xn_socket
# define c_hostof(a) (a).xn_host
#endif


#define NULL 0


CvtLongHex(len, to, from)
    int len;
    char *to;
    char *from;
{
    register char *fp;
    int b;

    fp = from + strlen(from);
    while( len > 0 ) {
        *fp = 0;
	if( fp <= from ) {
	    b = 0;
	} else {
	    if( (--fp) > from ) --fp;
	    (void)sscanf(fp, "%x", &b);
	}
	to[--len] = b;
    }
}


struct ns_addr *
GetXNSAddr(inputName)
    char *inputName;
{
    char name[50];
    static struct ns_addr addr;
    struct ns_addr nullAddr;
    u_long net;
    u_short socket;
    char *netname, *hostname, *socketname;
    int i;
    register char *p, *q;
    extern char *index();

	addr = nullAddr;
	strncpy(name, inputName, sizeof name);

	/*
	 * try XDE hex form 8E1H.0AA007625H.7538H
	 */
	
	if( index(name,'H') != NULL ) {
	    if( (hostname = index(name,'.')) == NULL ) {
	        netname = "0"; hostname = name; socketname = "0";
	    } else {
	        netname = name;
	        *hostname++ = 0;
		if( (socketname = index(hostname,'.')) == NULL )
	            socketname = "0";
		else
		    *socketname++ = 0;
	    }

	    if( (p = index(netname,'H')) != NULL ) *p = 0;
	    (void)sscanf(netname,"%lx", &net);
	    ns_netof(addr) = htonl(net);
	    /*net = htonl(net);
	    addr.x_net.s_net[1] = net & 0xffff;
	    addr.x_net.s_net[0] = net >> 16 ;*/

	    if( (p = index(hostname,'H')) != NULL ) *p = 0;
	    CvtLongHex( (sizeof c_hostof(addr)), c_hostof(addr),
	            hostname );

	    if( (p = index(socketname,'H')) != NULL ) *p = 0;
	    (void)sscanf(socketname,"%hx", &socket);
	    addr.x_port = htons(socket);

	    return(&addr);
	}

        /*
	 * try Unix form 2273.aa:0:76:25.1027
	 */
	if( index(name,':') != NULL ) {
	    if( (hostname = index(name,'.')) == NULL ) {
	        netname = "0"; hostname = name; socketname = "0";
	    } else {
	        netname = name;
	        hostname++;
		if( (socketname = index(hostname,'.')) == NULL )
	            socketname = "0";
		else
		    socketname++;
	    }

	    (void)sscanf(netname,"%ld", &net);
	    ns_netof(addr) = htonl(net);
	    
	    p = hostname; q = hostname;
	    while( *q ) {
	        if( q[1] == ':' ) *p++ = '0'; else *p++ = *q++;
		*p++ = *q++;
	        if( *q == ':' ) q++;
	    }
	    *p++ = 0;
	    CvtLongHex( (sizeof c_hostof(addr)), c_hostof(addr),
	            hostname );

	    (void)sscanf(socketname,"%hd", &socket);
	    addr.x_port = htons(socket);


	    return(&addr);
	}

	return( NULL );

}


int
FormatNetworkAddress( buf, ap )
    char *buf;
    struct ns_addr *ap;
{
    unsigned long net = ntohl( ns_netof(*ap) );
    unsigned short port = ntohs( ap->x_port );
    register u_char *p;

    p = (u_char *)(c_hostof(*ap));
    sprintf( buf, "%lxH.%02x%02x%02x%02x%02x%02xH.%xH",
        net, p[0], p[1], p[2], p[3], p[4], p[5], p[6], port );
}
