#include "../white/config.h"		/* IOBASE definition */

/* %W% %Y% %Q% %G% */
/*
 * $Header: cvreg.h,v 800.0 85/08/06 14:08:50 root Exp $
 *
 * $Log:	cvreg.h,v $
 * Revision 800.0  85/08/06  14:08:50  root
 * Bumped for Release 800.00
 * 
 * Revision 8.0  85/07/17  12:58:58  root
 * Initial checkin (sas).
 * 
 * Revision 7.28  85/04/12  10:14:26  sbs
 * changed NCV from 4 to 3.
 * 
 * Revision 7.27  85/03/08  11:11:24  root
 * Deleted "Corvus" (sas)
 * 
 * Revision 7.26  85/02/22  14:45:12  sbs
 * Cleaned up some waste code.
 * 
 */

/*
 *	This system knows about IMI H-20.
 */

/*
 * Normally these disks can be daisy-chained on a controller, with the
 * first one being disk 1 and second one being disk 2.  We aren't using
 * this feature, which makes some of the arithmetic simpler, and our
 * lives a lot easier.
 */
#define NCV		3		/* was 4 (but the floppy is in slot 4)*/
#define DSIZE		512
#define SIZE6		11220
#define SIZE10		21220
#define SIZE20		38460

/* --- map from minor # to disk partition */
#define cv_part(d)	((d)&0xF)	/* 16 partitions per drive */
/* --- minor to disk unit number */
#define cv_unit(d)	((d)>>4)	/* ... so unit shifts by 4 */
/* --- which drive on the daisy chain (1 or 2) */
#define cv_drive(unit)	(1)		/* never use the daisy-chain option */
/* --- slot, for appleslots */
#define cv_slot(unit)	((unit) + 1)	/* disk 0 at slot 1, 1 at 2, &c */
#define cv_addr(unit)	((struct cv_device *)(IOBASE+0x30100)+cv_slot(unit))


/*
 * disk sizes table
 */
struct cv_sizes {
	daddr_t	sz_offset;
	daddr_t sz_size;
};

/*
 * Programming model for the device
 */
struct cv_device {
	char	cv_fill0;
	char	cv_data;
	char	cv_fill1;
	char	cv_stat;
	char	cv_fill2[12+16];
};

	/* cv_stat bits */
#define ST_BUSY		0x80
#define ST_CTOH		0x40		/* controller to host direction */
#define ST_HTOC		0x00		/* host to controller direction */
#define ST_ENB		0x2		/* enable interrupts */
#define ST_PND		0x1		/* interrupt pending */

#define cvwait(a) while((a)->cv_stat & ST_BUSY); while((a)->cv_stat & ST_BUSY)

	/* normal mode commands */
#define N_READ		0x02
#define N_WRITE		0x03
#define N_PARAM		0x10
#define N_DIAGN		0x11
#define N_R128		0x12
#define N_R256		0x22
#define N_R512		0x32
#define N_W128		0x13
#define N_W256		0x23
#define N_W512		0x33
#define N_BOOT		0x14

	/* diagnostic mode commands */
#define D_RESET		0x00
#define D_FORMAT	0x01
#define D_VERIFY	0x07
#define D_RFIRMWARE	0x32
#define D_WFIRMWARE	0x33

	/* semaphore commands */
#define	S_INIT0		0x1a
#define S_INIT1		0x10
#define S_LOCK0		0x0b
#define S_LOCK1		0x01
#define S_ULOCK0	0x0b
#define S_ULOCK1	0x11
#define S_STAT0		0x1a
#define S_STAT1		0x41
#define S_STAT2		0x03

	/* pipe commands */
#define P_OP		0x1a
#define P_READ1		0x20
#define P_WRITE1	0x21
#define P_CLOSE1	0x40
#define P_STATUS1	0x41
#define P_NAMTAB2	0x01
#define P_PTRTAB2	0x02
#define P_BOTH2		0x00
#define P_CMD0		0x1b
#define P_OPENW1	0x80
#define P_INIT1		0xa0
#define P_OPENR1	0xc0

	/* mirror commands */
#define M_BACKUP	0x08
#define M_RESTOR	0x09
#define M_CMD0		0x0a
#define M_RDHDR1	0x00
#define M_RPTVFY1	0x02
#define M_FNDTRL1	0x0a
#define M_RSTERR	0x0c
#define M_RSTRTY1	0x00
#define M_RSTRPT1	0x01
#define M_PARTIAL	0x0d


	/* normal mode return status */
#define NS_FATAL	0x80		/* mask */
#define NS_VERIFY	0x40		/* mask */
#define NS_RECOVER	0x20		/* mask */
#define NS_HFAULT	0x00
#define NS_STIME	0x01
#define NS_SFAULT	0x02
#define NS_SERROR	0x03
#define NS_HCRC		0x04
#define NS_ZFAULT	0x05
#define NS_ZTIME	0x06
#define NS_OFFLINE	0x07
#define NS_WFAULT	0x08
#define NS_		0x09
#define NS_RFAULT	0x0a
#define NS_DATACRC	0x0b
/* . . . */

char *cv_errlist[];


struct cv_drivercmd {	/* N.B. obsoletes cvdstat */
	u_char result;
	u_char result1;		/* waste */
	short cvs_drive;
	long cvs_bno, cvs_size;
};

/*
 * This block defines a command to the controller.  Each controller
 * operation consists of a request and a response.  The first byte
 * of the response is the result code, which is duplicated in the
 * result field of this block for easy reading.
 */
struct cv_specialcmd {		/* N.B. obsoletes cvio_args */
	u_char result;
	u_char result1;		/* waste */
	caddr_t request_data;
	caddr_t response_data;
};

	/* use temp in iobuf for args to multiblock transfers */
#define io_buf b_blkno
#define io_count b_bufsize

	/* reuse stuff in buf for ioctl count args used advisedly */
#define b_rcvem b_blkno
#define b_code b_error

	/* ioctls */
#define CVIOCSTATS	_IOWR('d', 127, struct cv_drivercmd)
#define CVIOCPREP	_IOWR('d', 126, struct cv_specialcmd)
#define CVIOCRESET	_IOWR('d', 125, struct cv_specialcmd)
#define CVIOCPARK	_IOWR('d', 124, struct cv_specialcmd)
#define CVIOCFORMAT	_IOWR('d', 123, struct cv_specialcmd)
#define CVIOCRFIRM	_IOWR('d', 122, struct cv_specialcmd)
#define CVIOCWFIRM	_IOWR('d', 121, struct cv_specialcmd)
#define CVIOCPBLK	_IOWR('d', 120, struct cv_specialcmd)

	/* drive parameter format */
struct cv_param {
	char	cp_stat;
	char	cp_text[31];
	char	cp_fver;
	char	cp_rver;
	char	cp_nsec;
	char	cp_ntrk;
	char	cp_ncyl0;
	char	cp_ncyl1;
	char	cp_nblk0;
	char	cp_nblk1;
	char	cp_nblk2;
	char	cp_spare[16];
	char	cp_ileave;
	char	cp_const[12];
	char	cp_pipe[6];
	char	cp_vdo[14];
	char	cp_lsi_vdo[8];
	char	cp_lsi_spare[8];
	char	cp_physdrv;
	char	cp_lblk0;
	char	cp_lblk1;
	char	cp_lblk2;
	char	cp_fill[19];
};
