static char rcsid[] = "$Header: subr_prf.c,v 820.1 86/12/04 19:58:24 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984, 1985			*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	subr_prf.c	6.1	83/07/29	*/

/*
 * jht 850721 - Turn on logging device if we panic() -- documents crashes.
 */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/seg.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/reboot.h"
#include "../h/vm.h"
#include "../h/msgbuf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/tty.h"

/*
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */
char	*panicstr;

/*
 * Scaled down version of C Library printf.
 * Used to print diagnostic information directly on console tty.
 * Since it is not interrupt driven, all system activities are
 * suspended.  Printf should not be used for chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character,
 * e.g. \10 gives octal; \20 gives hex.  Each arg is a sequence of
 * characters, the first of which gives the bit number to be inspected
 * (origin 1), and the next characters (up to a control character, i.e.
 * a character <= 32), give the name of the register.  Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=2<BITTWO,BITONE>
 */
/*VARARGS1*/
printf(fmt, x1)
	char *fmt;
	unsigned x1;
{

	prf(fmt, &x1, 0);
}

/*
 * Uprintf prints to the current user's terminal,
 * guarantees not to sleep (so can be called by interrupt routines)
 * and does no watermark checking - (so no verbose messages).
 */
/*VARARGS1*/
uprintf(fmt, x1)
	char *fmt;
	unsigned x1;
{

	prf(fmt, &x1, 2);
}

prf(fmt, adx, touser)
	register char *fmt;
	register u_int *adx;
{
	register int base, c, i;
#ifdef s32
	register width;
	int right;
	int zeroFill;
#endif s32
	char *s;
	int any;

loop:
	while ((c = *fmt++) != '%') {
		if(c == '\0')
			return;
		putchar(c, touser);
	}
#ifdef s32
	zeroFill = 0;
	width = 0;
	right = 0;
#endif s32
again:
	c = *fmt++;
	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

#ifdef s32
	case '0':
		if (!width)
			zeroFill = 1;
	case '1': case '2': case '3':
	case '4': case '5': case '6':
	case '7': case '8': case '9':
		width = width*10 + c - '0';
		goto again;
#endif s32
	case 'l':
		goto again;
	case 'x': case 'X':
		base = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		base = 10;
		goto number;
	case 'o': case 'O':
		base = 8;
number:
#ifdef s32
		printn((u_long)*adx, base, touser, width, zeroFill, right);
#else s32
		printn((u_long)*adx, base, touser);
#endif s32
		break;
	case 'c':
		base = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (base >> i) & 0x7f)
				putchar(c, touser);
		break;
	case 'b':
		base = *adx++;
		s = (char *)*adx;
#ifdef s32
		printn((u_long)base, *s++, touser, width, zeroFill, right);
#else s32
		printn((u_long)base, *s++, touser);
#endif s32
		any = 0;
		if (base) {
			putchar('<', touser);
			while (i = *s++) {
				if (base & (1 << (i-1))) {
					if (any)
						putchar(',', touser);
					any = 1;
					for (; (c = *s) > 32; s++)
						putchar(c, touser);
				} else
					for (; *s > 32; s++)
						;
			}
			if (any)
				putchar('>', touser);
		}
		break;

	case 's':
		s = (char *)*adx;
#ifdef s32
		while (*s++)
			width--;
		s = (char *)*adx;
		if (!right) while (width-- > 0)
			putchar(' ', touser);
#endif s32
		while (c = *s++)
			putchar(c, touser);
#ifdef s32
		if (right) while (width-- > 0)
			putchar(' ', touser);
#endif s32
		break;

	case '%':
		putchar('%', touser);
#ifdef s32
		goto loop;
	case '*':
		width = *adx++;
		goto again;
	case '-':
		right = 1;
		goto again;
#else s32
		break;
#endif s32
	}
	adx++;
	goto loop;
}

/*
 * Printn prints a number n in base 'base'.
 * We don't use recursion to avoid deep kernel stacks.
 */
#ifdef s32
printn(n, base, touser, pad, zeroFill, right)
	register u_long n;
#else s32
printn(n, base, touser)
	u_long n;
#endif s32
{
	char prbuf[11];
	register char *cp;
#ifdef s32
	register sign = base == 10 && (int)n < 0;
	register char c = (!right && zeroFill) ? '0' : ' ';
#endif s32

#ifdef s32
	if (sign) {
#else s32
	if (base == 10 && (int)n < 0) {
		putchar('-', touser);
#endif s32
		n = (unsigned)(-(int)n);
#ifdef s32
		pad--;
#endif s32
	}
	cp = prbuf;
	do {
		*cp++ = "0123456789abcdef"[n%base];
		n /= base;
#ifdef s32
		pad--;
#endif s32
	} while (n);
#ifdef s32
	if (!right)
		while (pad-- > 0)
			putchar(c, touser);
	if (sign)
		putchar('-', touser);
#endif s32
	do
		putchar(*--cp, touser);
	while (cp > prbuf);
#ifdef s32
	if (right)
		while (pad-- > 0)
			putchar(c, touser);
#endif s32
}

#ifdef s32
int	stayindebug		= -1;
int	calledFromPanic		= 0;	/* Used in debugger() */
int	alreadyPaniced		= 0;	/* Prevent recursive panics */
int	panicStateMachine	= 0;	/* Prevent recursive panics */

short	canSyncNow		= 0;	/* 0 ==> May not update() yet	*/
#endif s32
/*
 * Panic is called on unresolvable fatal errors.
 * It prints "panic: mesg", and then reboots.
 * If we are called twice, then we avoid trying to
 * sync the disks as this often leads to recursive panics.
 */
panic(s)
	char *s;
{
	int bootopt = RB_AUTOBOOT;

	if (panicstr)
		bootopt |= RB_NOSYNC;
	else {
		panicstr = s;
	}
#if	defined(PANIC_LOGGING) && defined(s32)
	/*
	 * Insure that we are logging what goes
	 * to the console.
	 * We try to make any crash-dump
	 * self documenting.
	 */
	if (!alreadyPaniced++)	/* BUG: compute the '16'! */
		(void) logopen(makedev(16,1), 1/*LOGTYPE_KERNEL*/);

	/*
	 * The classic message...
	 */
#endif	defined(PANIC_LOGGING) && defined(s32)
	printf("panic: %s\n", s);

#ifdef s32
#ifdef	DEBUG
	/*
	 * Sync once and only once for fear of recursion.
	 * Nominal 4.2bsd would do the 'sync()' via boot().
	 */
	if (!(bootopt & RB_NOSYNC)
	 && canSyncNow) {
		printf("syncing disks...\n");
		update();
	}
#endif	DEBUG
	if (panicStateMachine)
		calledFromPanic = 2;	/* Used in debugger(): state machine */
	while (stayindebug == -1)
		cdebugger("called from panic");
	printf("Returning from panic ...\n");
	panicstr = (char *)0;
#else	s32
	boot(RB_PANIC, bootopt);
#endif	s32
}

/*
 * Warn that a system table is full.
 */
tablefull(tab)
	char *tab;
{

	printf("%s: table is full\n", tab);
}

/*
 * Hard error is the preface to plaintive error messages
 * about failing disk transfers.
 */
harderr(bp, cp)
	struct buf *bp;
	char *cp;
{

	printf("%s%d%c: hard error sn%d ", cp,
	    dkunit(bp), 'a'+(minor(bp->b_dev)&07), bp->b_blkno);
}

#ifdef s32
/*
 * prdev prints a warning message of the
 * form "mesg on dev x/y".
 * x and y are the major and minor parts of
 * the device argument.
 */
prdev(str, dev)
char *str;
dev_t dev;
{

	printf("%s on dev %D/%D\n", str, major(dev), minor(dev));
}
#endif s32

/*
 * Print a character on console or users terminal.
 * If destination is console then the last MSGBUFS characters
 * are saved in msgbuf for inspection later.
 */

#ifdef STOPDEBUG
short	nLinesPerBreak = -1;
#endif STOPDEBUG

/*ARGSUSED*/
putchar(c, touser)
	register int c;
{
#ifdef STOPDEBUG
	register char c1;
#endif STOPDEBUG
#ifdef s32
	extern int vax_mapen;
#endif s32

	if (touser) {
		register struct tty *tp = u.u_ttyp;

		if (tp && (tp->t_state&TS_CARR_ON)) {
			register s = spl6();
			if (c == '\n')
				(void) ttyoutput('\r', tp);
			(void) ttyoutput(c, tp);
			ttstart(tp);
			splx(s);
		}
		return;
	}
	if (c != '\0' && c != '\r' && c != 0177
#ifdef vax
	    && mfpr(MAPEN)
#endif
#ifdef s32
	    && vax_mapen
#endif s32
	    ) {
		if (msgbuf.msg_magic != MSG_MAGIC) {
			register int i;

			msgbuf.msg_bufx = 0;
			msgbuf.msg_magic = MSG_MAGIC;
			for (i=0; i < MSG_BSIZE; i++)
				msgbuf.msg_bufc[i] = 0;
		}
		if (msgbuf.msg_bufx < 0 || msgbuf.msg_bufx >= MSG_BSIZE)
			msgbuf.msg_bufx = 0;
		msgbuf.msg_bufc[msgbuf.msg_bufx++] = c;
	}
	if (c == 0)
		return;
#ifdef STOPDEBUG
	if (nLinesPerBreak != -1 && c == '\n' && --nLinesPerBreak == 0) {
		nLinesPerBreak = 20;
		for (c1=3; c1; --c1) putchar ('.', touser);
		c1 = getchar ();
		if (c1 == '\n' || c1 == '\r')
			nLinesPerBreak = 1;
		else if (c1 == 'q')
			nLinesPerBreak = -1;
	}	
#endif STOPDEBUG
	cnputc(c);
}
