/* rcsid[]="$Header: isvar.h,v 2.1 86/07/21 14:56:40 bog Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1985				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Interphase 2190/Storager driver global definitions for boot rom.
 * Derived from kernel source.
 */

/*
 * Per controller information.
 * Note that we only show one register set for the Storager, as it's the
 * only one we'll be using.
 */
struct is_ctlr {
	u_char ic_storager;		/* true => is a storager */	
	u_char ic_init;			/* Open and initialized */
	struct is_device *ic_addr;	/* controller address */
	struct is_param *ic_param;	/* per-controller parameter block */
					/* called `iopb' by Interphase */
#define IP (ic->ic_param)		/* shorthand for current param block */
	struct is_disk *ic_disk;	/* is_disk in use */
	struct is_tape *ic_tape;	/* is_tape being used */
};

extern struct is_ctlr i_templates[];

/*
 * Per disk information
 */
struct is_disk {
	int id_ncyl;			/* cylinders, including alternates */
	int id_nhead;			/* number of heads */
	int id_nsec;			/* number of sectors per track */
	int id_nsecpercyl;		/* sectors per cylinder */
	int id_acyl;			/* number of alternate cylinders */
	int id_a_alloc;			/* number of alt tracks allocated */
	int id_gap1;			/* gap 1 (for formatting) */
	int id_gap2;			/* gap 2 (for formatting) */
	int id_intrlv;			/* interleave factor */
	int id_group;			/* group size */
	int id_skew;			/* skew factor */
	char id_cache;			/* cache mode */
	/* begin Storager only fields */
	u_char id_zerolatency;	/* zero latency mode */
	u_char id_drivedesc;	/* Storager uib drive descriptor byte */
	int id_gap3;		/* gap3 size */
	u_char id_bufstep;	/* does drive accept buffered steps? */
	u_char id_stepwidth;	/* step pulse width */
	int id_stepinter;	/* step pulse interval */
	u_char id_headloadtime;	/* head load time */
	u_char id_seektime;	/* track to track seek time */
	u_short id_precomp;	/* write precompensation starting cylinder */
	u_short id_redwrite;	/* reduced write current starting cylinder */
	/* end Storager only */
	struct dk_sizes id_sizes[DK_NSIZES];	/* disk partition table */
	int id_unit;			/* unit number */
	u_char id_err;			/* last controller error */
};

/*
 * Per tape information
 */
struct is_tape {
	int it_unit;			/* unit number */
	u_char it_open;			/* is open */
	u_char it_err;			/* can't recover from last error */
	u_char it_lastiow;		/* last io was a write */
	u_char it_lasterr;		/* error field of last command run */
	u_char it_filemark;		/* last read returned a filemark */
	daddr_t it_blkno;		/* current block number */
	daddr_t it_nxrec;		/* eof position, if known */
};

struct cyl_hd {
	u_short	cyl,
		head;
};

#define IT_TAPETIMEOUT	18	/* timeout in 10s incrs for tape ops */
#define IS_DMA 128		/* DMA burst */
#define ISDELAYAMT 50		/* "i-- ticks" to delay */
#define NDISK 4
#define NTAPE 4

#define IPERR_CANCEL	0x99	/* psuedo error reported when iscmd() fails */
				/* due to user interrupting with ^X */

extern struct is_uib *is_uib;	/* global uib */
extern struct dk_label *label;	/* disk label */

extern long ignerr;
extern long berrfound;

extern u_char iserr;		/* error code returned by last iscmd() */

extern struct is_disk is_disk[];    /* per disk info, for every possible disk */
extern struct is_tape is_tape[];    /* per tape info, ... */

extern struct dk_sizes *is_sizes;	/* partition table for current disk */

/*
 * Macros to convert struct iob unit numbers into controller and unit.
 */
#define ISUNIT(n)	((n) % ID_NSLAVE)
#define ISCTLR(n)	((n) / ID_NSLAVE)
