	.asciz "$Header: disasm.s,v 820.1 86/12/04 19:53:15 root Exp $"
	.asciz "%W% %Y% %Q% %G%"
	.even

|------------------------------------------------------------------------
|
|				Copyright  1984
|
|			VALID  LOGIC  SYSTEMS  INCORPORATED
|
|	This listing contains confidential proprietary information which
|	is not to be disclosed to unauthorized persons without written
|	consent of an officer of Valid Logic Systems Incorporated.
|
|	The copyright notice appearing above is included to provide
|	statutory protection in the event of unauthorized or
|	unintentional public disclosure.
|
|------------------------------------------------------------------------

|  68000 disassembler
|  short *		
|  disasm(loc,cp)
|  register short *loc;	
|  register char *cp;	










EA=1
EA2=2
AX=3
AY=4
SIZ=5
RAD=6
DY=7
CC=8
DSP=9
SZ6=10
REV=11
QCT=12
IMM=13
SZ2=14
ESC=15
SHD=0
BIT=1
DX=2
CCR=3
SR=4
USP=5
UUO=6
AAP=7
UNS=8
SHM=9
MVQ=10

N4W=4
	M_1=0x0e3e
	S_1=-32	| 8 registers (only d0,a0 clobbered)
	F_1=-32	| that's all

	.globl disasm
disasm:
	link a6,#F_1
	moveml #M_1,a6@(S_1)
	movl a6@(8),d0
	bclr #0,d0
	movl d0,a0
	movl a6@(12),a1
	movw a0@+,d2
	moveq #1,d5
L800:	lea pc@(0x41a),a2	| idecode-4
L100:
	addql #4,a2	| skip modes word and first word of packed opcode chars
L110:
	movw a2@+,d0	| look for an instr mask
	bpls L110	| while skipping packed character strings
	andw d2,d0
	cmpw a2@+,d0
	bnes L100
		| found it; print the opcode
	movw a2@+,d3	| modes
	bsrs L130
ret:
	clrb a1@
	movl a0,d0	| pc_next_instr
	moveml a6@(S_1),#M_1
	unlk a6
	rts
L120:
	movl #0x1f,d0
	andw d1,d0
	addw #'`,d0
	movb d0,a1@+
	lsrw #5,d1
L125:
	bnes L120
L130:
	movw a2@+,d1
	bpls L125		| got upto 3 packed chars
L140:
	movl #0x20,d4	| blank after opcode
	bras L220
L200:
	movb d4,a1@+
	movl #0,d4
	movl a1,sp@-		| save start of each operand
	movl #0xf,d0		| N4W
	andw d3,d0		| get a 4-bit code
	eorw d0,d3		| and clear it
	addw d0,d0
L803:	movw pc@(0x1a,d0:w),d0	| L300
L804:	jsr pc@(0x16,d0:w)	| L300
	tstw d4
	bnes L220
	movl #0x2c,d4	| ',' 054
L220:
	rolw #N4W,d3
	bnes L200
	movl a6@(S_1-4),a3	| known position of return address
	jmp a3@
L300:
	.word L220-L300,_EA-L300,_EA2-L300,_AX-L300
	.word _AY-L300,_SIZ-L300,_RAD-L300,_DY-L300
	.word _CC-L300,_DSP-L300,_SZ6-L300,_REV-L300
	.word _QCT-L300,_IMM-L300,_SZ2-L300,_ESC-L300

_RAD:
	movl #8,d0	| the magic bit
	andw d2,d0
	andw #0xe07,d2	| 07007 keep the registers, clear the modes
	lslw #2,d0	| mode 000 or 040
	orw d0,d2
	lslw #3,d0
	orw d0,d2
	rts

_SZ2:
	movw d2,d0
	rolw #4,d0
	andw #3,d0
L805:	movb pc@(4,d0:w),d5	| sizmov
	bras si

sizmov:	.byte 0,0,2,1
sizsiz:	.byte 0,1,2,1,0,1,2,2
sizch:	.ascii "bwl "

_SIZ:
	movw d2,d0
	asrw #6,d0
	andw #7,d0
L806:	movb pc@(-0x16,d0:w),d5	| sizsiz
si:
	movb #0x2e,a1@(-1)	| '.' 056
L807:	movb pc@(-0x18,d5:w),a1@+	| sizch
	movl #0x20,d4
	rts

_CC:
	subql #1,a1
	movw d2,d0
	asrw #7,d0
	andw #0x1e,d0
	movl #2,d1
	bsrs xstrbl
	.byte 0x72,0,0x66,0	| "r\0f\0"
	.ascii	    "hilshsloneeq"
	.ascii	"vcvsplmigeltgtle"

_BIT:
	subql #1,a1
	movw d2,d0
	asrw #6,d0
	movl #3,d1
	andw d1,d0
	mulu d1,d0
	bsrs xstrbl
	.ascii	"tstchgclrset"

xstrbl:
	movl #0x20,d4
xstr:
	movl sp@+,a3
	addw d0,a3
strout:
	movb a3@+,d0
	beqs strend
	movb d0,a1@+
	subqw #1,d1
	bgts strout
strend:
	rts

_SHD:
	movw d2,d0
	lsrw #3,d0
	bsrs shfdir
	addql #1,a1
	bsr _SIZ
	movl #QCT,d0
	btst #5,d2
	beqs shdcnt
	movl #DY,d0
shdcnt:
	orw d0,d3
	rorw #N4W,d3
	rts

shftyp:
	subql #1,a1
	movl #3,d1
	andw d1,d0
	mulu d1,d0
	bsrs xstr
	.ascii	"as"
	.byte 0
	.ascii	"ls"
	.byte 0
	.ascii "rox"
	.ascii "ro"
	.byte 0
shfdir:
	bsrs shftyp
	movl #'r,d0
	bclr #8,d2
	beqs shfrgt
	movl #'l,d0
shfrgt:
	movb d0,a1@+
	rts

_SHM:
	movw d2,d0
	rolw #7,d0
	bsrs shfdir
	movl #0,d0
	movl #5,d1
	bsrs xstr
	.ascii	".w"
	.byte 0
	.ascii "#1"
	.byte 0

_ESC:
	rolw #N4W,d3
	movl #0xf,d0		| N4W
	andw d3,d0
	eorw d0,d3
	addw d0,d0
L808:	movw pc@(6,d0:w),d0	| _ESCtab
L809:	jmp pc@(2,d0:w)		| _ESCtab
_ESCtab:
	.word _SHD-_ESCtab,_BIT-_ESCtab,_DX-_ESCtab,_CCR-_ESCtab
	.word _SR-_ESCtab,_USP-_ESCtab,_UUO-_ESCtab,_AAP-_ESCtab
	.word _UNS-_ESCtab,_SHM-_ESCtab,_MVQ-_ESCtab

_AAP:
	andw #0xe07,d2	| 07007 keep registers, clear modes
	orw  #0xd8,d2	| 00330
	bsrs _EA
_EA2:
	movl #7,d0
	lsrw #6,d2
	andw d2,d0
	lslw #3,d0
	lsrw #3,d2
	andw #7,d2
	orw d0,d2
_EA:
	movl #0x38,d0
	andw d2,d0
	asrw #2,d0
L810:	jmp pc@(0x42,d0:w)	| _EAtab

_UUO:	subql #1,a1
	movw d2,d0
	bra d0_unsgn
ch_pct2:bra ch_pct
_AY:	bsrs ch_pct2
	bsrs ch_a
	bras _RY
_DY:	bsrs ch_pct2
	bsrs ch_d
_RY:
	movw d2,d0
	rolw #7,d0
	bras octchar

_USP:	bsrs ch_pct2
	movb #0x75,a1@+
	bsrs ch_s
	bras ch_p
_SR:	bsrs ch_pct2
	bsrs ch_s
	movb #0x72,a1@+
	rts
_CCR:	bsrs ch_pct2
	bsrs ch_c
	bras ch_c

_RX:
	movw d2,d0
octchar:
	andw #7,d0
	bra hexchar

_EAtab:
	bras _EA0X
	bras _EA1X
	bras _EA2X
	bras _EA3X
	bras _EA4X
	bras _EA5X
	bras _EA6X
	bras _EA7X

ch_xad:	bpls ch_d
ch_a:	movb #0x61,a1@+
	rts
ch_c:	movb #0x63,a1@+
	rts
ch_d:	movb #0x64,a1@+
	rts
ch_p:	movb #0x70,a1@+
	rts
ch_s:	movb #0x73,a1@+
	rts

_DX:
_EA0X:	| dn
	bsrs ch_pct
	bsrs ch_d
	bras _RX
_AX:
_EA1X:	| an
	bsrs ch_pct
	bsrs ch_a
	bras _RX
_EA5X:	| y(an)
	bsrs locnxt
_EA2X:	| (an)
	bsrs ch_lpa
	bsrs _EA1X
	bras ch_rpa
_EA3X:	| (an)+
	bsrs _EA2X
	bras ch_pls
_EA4X:	| -(an)
	bsrs ch_min
	bras _EA2X
_EA6X:	| z(an,%rxs)
L801:	lea pc@(-0x18),a3	| _EA1X
_EAix2:
	movw a0@,d0
	bsrs d0_byte
	bsrs ch_lpa
	jsr a3@
	bsrs ch_cma
	bsrs ch_pct
	movw a0@,d0
	bsrs ch_xad
	rolw #4,d0
	bsrs octchar
	movw a0@+,d0
	lslw #4,d1
	bsr dot_wl
	bras ch_rpa
_EA7X:
	movl #7,d0
	andw d2,d0
	addw d0,d0
L811:	jmp pc@(0x32,d0:w)	| _EA7tab
ch_pc:
	bsrs ch_pct
	bsrs ch_p
	bras ch_c
ch_pct:	bsrs ch_spec	| '%' 045
ch_amp:	bsrs ch_spec	| '#' 046
ch_app:	bsrs ch_spec	| '\'' 047
ch_lpa:	bsrs ch_spec	| '(' 050
ch_rpa:	bsrs ch_spec	| ')' 051
ch_ast:	bsrs ch_spec	| '*' 052
ch_pls:	bsrs ch_spec	| '+' 053
ch_cma:	bsrs ch_spec	| ',' 054
ch_min:	bsrs ch_spec	| '-' 055
ch_dot:	bsrs ch_spec	| '.' 056

locnxt:
_EA70:	| absolute word address
	movw a0@+,d0
	bras d0_word
locnxtl:
_EA71:	| absolute long address
	movl a0@+,d0
	bras d0_long

_EA72:	|y(pc)
	bsrs locnxt
	bsrs ch_lpa
	bsrs ch_pc
	bras ch_rpa
_EA73:	|y(pc,%rxs)
L802:	lea pc@(-0x2c),a3	| ch_pc
	bras _EAix2
_EA7tab:
	bras _EA70
	bras _EA71
	bras _EA72
	bras _EA73
	bras _EA74
	bras _EA75
	bras _EA76
	bras _EA77
_MVQ:
	subql #1,a1
	bsr dot_l
	movb #0x20,a1@+
	bsrs ch_amp
	movw d2,d0
d0_byte:
	extw d0
d0_word:
	extl d0
d0_long:
	tstl d0
	bges d0_unsgn
	bsrs ch_min
	negl d0
d0_unsgn:
numout:
	movw d0,sp@-
	lsrl #4,d0
	beqs zquo
	bsrs numout
zquo:
	movl #0xf,d0
zquom:
	andw sp@+,d0
hexchar:
L812:	movb pc@(0x2a,d0:w),a1@+	| hextab
	rts

_IMM:
_EA74:	| immediate
	bsrs ch_amp
	movw d5,d0
	addw d0,d0
	jmp pc@(2,d0:w)
	bras locnxt
	bras locnxt
	bras locnxtl

ch_spec:
	movl sp@,sp@-
	movl d0,sp@(4)
	movl sp@+,d0
L813:	pea pc@(-0xcc)	| ch_pct+2-'%-'%
	subl sp@+,d0
	lsrw #1,d0
	movb d0,a1@+
	movl sp@+,d0
	rts

hextab:
	.ascii	"0123456789abcdef""

_EA75:
_EA76:
_EA77:
	movb #0x3f,a1@+		|077 '?'
	rts
_UNS:
	subql #1,a1
	movw d2,d1
	movl #'s,d0
	lslw #7,d1
	bmis _UNSs
	movl #'u,d0
_UNSs:
	movb d0,a1@+
	bsrs ch_dot2
	bsrs ch_w
	movl #0x20,d4
	rts

_QCT:
	bsr ch_amp
	movw d2,d0
	rolw #7,d0
	andw #7,d0
	bnes hexchar
	addqw #8,d0
	bras hexchar
_DSP:
	movb d2,d0
	beqs _DSPw
	moveq #0,d5
	bsr si
	movb d4,a1@+
	movb d2,d0
	extw d0
	extl d0
	addl a0,d0
	bras d0_uns2
_DSPw:
	movw a0@,d0
	extl d0
	addl a0,d0
	addql #2,a0
d0_uns2:
	bra d0_unsgn

_SZ6:
	subql #1,a1
	movl #0x20,d4
	movw d2,d0
	rorw #7,d0
dot_wl:	bpls dot_w
dot_l:	bsrs ch_dot2
ch_l:	movb #0x6c,a1@+
	rts
dot_w:	bsrs ch_dot2
ch_w:	movb #0x77,a1@+
	rts
ch_dot2:bra ch_dot

_REV:
	moveml sp@(4),#0x0600
	bsrs revstr
	moveml sp@(8),#0x0600
	bsrs revstr
	moveml sp@(4),#0x0e00
	movl a3,a2
	bsrs revstr
	movl sp@(4),a1
	clrb a1@-		| erase trailing comma
	rts
revstr:		| reverse string [a2,a1)
	movb a2@,d0
	movb a1@-,a2@+
	movb d0,a1@
	cmpl a2,a1
	bgts revstr
	rts


|define P3(a,b,c) ('c-'`)*0x400+('b-'`)*0x20+('a-'`)
|define P2(a,b) ('b-'`)*0x20+('a-'`)
|define P1(a) ('a-'`)


	|struct idecode {
	|	uword mask,value,modes;
	|	uword pckstr[];
	|} idecode[] = {
idecode:
	.word 0xd000,0x1000, [SZ2*0x1000]+[EA*0x100]+[EA2*0x10]+0,0x59ed	|P3(m,o,v) move byte/word
	.word 0xf000,0x2000, [SZ2*0x1000]+[EA*0x100]+[EA2*0x10]+0,0x59ed	|P3(m,o,v) move long
	.word 0xff00,0x0c00, [SIZ*0x1000]+[IMM*0x100]+[EA*0x10]+REV,0x41a3	|P3(c,m,p) cmp immediate
	.word 0xf0c0,0xb0c0, [SIZ*0x1000]+[AY*0x100]+[EA*0x10]+0,0x41a3	|P3(c,m,p) cmpa
	.word 0xf138,0xb108, [SIZ*0x1000]+[ESC*0x100]+[AAP*0x10]+0,0x41a3	|P3(c,m,p) cmpm [eor!]
	.word 0xf100,0xb000, [SIZ*0x1000]+[DY*0x100]+[EA*0x10]+0,0x41a3	|P3(c,m,p)
	.word 0xf100,0xb100, [SIZ*0x1000]+[DY*0x100]+[EA*0x10]+0,0x49e5	|P3(e,o,r)
	.word 0xff00,0x6100, [DSP*0x1000]+[0*0x100]+[0*0x10]+0,0x4a62	|P3(b,s,r)
	.word 0xf000,0x6000, [CC*0x1000]+[DSP*0x100]+[0*0x10]+0,0x0002	|P1(b)
	.word 0xf100,0x7000, [ESC*0x1000]+[MVQ*0x100]+[DY*0x10]+0,0x59ed	|P3(m,o,v) move quick
	.word 0xf0f8,0x50c8, [CC*0x1000]+[ESC*0x100]+[DX*0x10]+IMM,0x0044	|P2(d,b) dbcc
	.word 0xf0c0,0x50c0, [CC*0x1000]+[EA*0x100]+[0*0x10]+0,0x0013	|P1(s) scc
	.word 0xf100,0x5000, [SIZ*0x1000]+[QCT*0x100]+[EA*0x10]+0,0x1081	|P3(a,d,d) add quick
	.word 0xf100,0x5100, [SIZ*0x1000]+[QCT*0x100]+[EA*0x10]+0,0x0ab3	|P3(s,u,b) sub quick
	.word 0xff00,0x0600, [SIZ*0x1000]+[IMM*0x100]+[EA*0x10]+0,0x1081	|P3(a,d,d) add immed
	.word 0xff00,0x0400, [SIZ*0x1000]+[IMM*0x100]+[EA*0x10]+0,0x0ab3	|P3(s,u,b) sub immed
	.word 0xf0c0,0xd0c0, [SIZ*0x1000]+[EA*0x100]+[AY*0x10]+0,0x1081	|P3(a,d,d) adda
	.word 0xf130,0xd100, [SIZ*0x1000]+[RAD*0x100]+[EA*0x10]+EA2,0x1081,0x0018	|P3(a,d,d),P1(x)
	.word 0xf100,0xd000, [SIZ*0x1000]+[EA*0x100]+[DY*0x10]+0,0x1081	|P3(a,d,d)
	.word 0xf100,0xd100, [SIZ*0x1000]+[DY*0x100]+[EA*0x10]+0,0x1081	|P3(a,d,d)
	.word 0xf0c0,0x90c0, [SIZ*0x1000]+[EA*0x100]+[AY*0x10]+0,0x0ab3	|P3(s,u,b) suba
	.word 0xf130,0x9100, [SIZ*0x1000]+[RAD*0x100]+[EA*0x10]+EA2,0x0ab3,0x0018	|P3(s,u,b),P1(x)
	.word 0xf100,0x9000, [SIZ*0x1000]+[EA*0x100]+[DY*0x10]+0,0x0ab3	|P3(s,u,b)
	.word 0xf100,0x9100, [SIZ*0x1000]+[DY*0x100]+[EA*0x10]+0,0x0ab3	|P3(s,u,b)
	.word 0xf1f8,0xc140, [ESC*0x1000]+[DX*0x100]+[DY*0x10]+0,0x1f05	|P3(e,x,g)
	.word 0xf1f8,0xc148, [AX*0x1000]+[AY*0x100]+[0*0x10]+0,0x1f05	|P3(e,x,g)
	.word 0xf1f8,0xc188, [AX*0x1000]+[DY*0x100]+[0*0x10]+0,0x1f05	|P3(e,x,g)
	.word 0xf1f0,0xc100, [RAD*0x1000]+[EA*0x100]+[EA2*0x10]+0,0x0c41,0x0004	|P3(a,b,c),P1(d)
	.word 0xf0c0,0xc0c0, [ESC*0x1000]+[UNS*0x100]+[EA*0x10]+DY,0x32ad	|P3(m,u,l)
	.word 0xf100,0xc000, [SIZ*0x1000]+[EA*0x100]+[DY*0x10]+0,0x11c1	|P3(a,n,d)
	.word 0xf100,0xc100, [SIZ*0x1000]+[DY*0x100]+[EA*0x10]+0,0x11c1	|P3(a,n,d)
	.word 0xf1c0,0x41c0, [SZ6*0x1000]+[EA*0x100]+[AY*0x10]+0,0x04ac	|P3(l,e,a)
	.word 0xffc0,0x4e80, [EA*0x1000]+[0*0x100]+[0*0x10]+0,0x4a6a	|P3(j,s,r)
	.word 0xf1f0,0x8100, [RAD*0x1000]+[EA*0x100]+[EA2*0x10]+0,0x0c53,0x0004	|P3(s,b,c),P1(d)
	.word 0xf0c0,0x80c0, [ESC*0x1000]+[UNS*0x100]+[EA*0x10]+DY,0x5924	|P3(d,i,v)
	.word 0xf100,0x8000, [SIZ*0x1000]+[EA*0x100]+[DY*0x10]+0,0x024f	|P2(o,r)
	.word 0xf100,0x8100, [SIZ*0x1000]+[DY*0x100]+[EA*0x10]+0,0x024f	|P2(o,r)
	.word 0xf8c0,0xe0c0, [ESC*0x1000]+[SHM*0x100]+[EA*0x10]+0,0000	|shift/rotate memory
	.word 0xf000,0xe000, [ESC*0x1000]+[SHD*0x100]+[ESC*0x10]+DX,0000	|shift/rotate dx
	.word 0xf100,0x0100, [ESC*0x1000]+[BIT*0x100]+[DY*0x10]+EA,0x0002	|P1(b) dynamic bit
	.word 0xff00,0x0800, [ESC*0x1000]+[BIT*0x100]+[IMM*0x10]+EA,0x0002	|P1(b) static bit
	.word 0xf0b8,0x0008, [SIZ*0x1000]+[IMM*0x100]+[AX*0x10]+DY,0x59ed,0x0010	|P3(m,o,v),P1(p)
	.word 0xf0b8,0x0088, [SIZ*0x1000]+[DY*0x100]+[IMM*0x10]+AX,0x59ed,0x0010	|P3(m,o,v),P1(p)
	.word 0xffff,0x003c, [IMM*0x1000]+[ESC*0x100]+[CCR*0x10]+0,0x024f	|P2(o,r)  or immed to ccr
	.word 0xffff,0x007c, [IMM*0x1000]+[ESC*0x100]+[SR*0x10]+0,0x024f	|P2(o,r)  or immed to sr
	.word 0xff00,0x0000, [SIZ*0x1000]+[IMM*0x100]+[EA*0x10]+0,0x024f	|P2(o,r)  or immed
	.word 0xffff,0x023c, [IMM*0x1000]+[ESC*0x100]+[CCR*0x10]+0,0x11c1	|P3(a,n,d)  and immed to ccr
	.word 0xffff,0x027c, [IMM*0x1000]+[ESC*0x100]+[SR*0x10]+0,0x11c1	|P3(a,n,d)  and immed to sr
	.word 0xff00,0x0200, [SIZ*0x1000]+[IMM*0x100]+[EA*0x10]+0,0x11c1	|P3(a,n,d)  and immed
	.word 0xffff,0x0a3c, [IMM*0x1000]+[ESC*0x100]+[CCR*0x10]+0,0x49e5	|P3(e,o,r)  eor immed to ccr
	.word 0xffff,0x0a7c, [IMM*0x1000]+[ESC*0x100]+[SR*0x10]+0,0x49e5	|P3(e,o,r)  eor immed to sr
	.word 0xff00,0x0a00, [SIZ*0x1000]+[IMM*0x100]+[EA*0x10]+0,0x49e5	|P3(e,o,r)  eor immed
	.word 0xffff,0x4afc, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x3189	|P3(i,l,l)
	.word 0xffc0,0x4ac0, [EA*0x1000]+[0*0x100]+[0*0x10]+0,0x4c34	|P3(t,a,s)
	.word 0xff00,0x4a00, [SIZ*0x1000]+[EA*0x100]+[0*0x10]+0,0x5274	|P3(t,s,t)
	.word 0xffc0,0x40c0, [ESC*0x1000]+[SR*0x100]+[EA*0x10]+0,0x59ed	|P3(m,o,v) move from sr
	.word 0xff00,0x4000, [SIZ*0x1000]+[EA*0x100]+[0*0x10]+0,0x1cae,0x0018	|P3(n,e,g),P1(x)
	.word 0xffc0,0x42c0, [ESC*0x1000]+[CCR*0x100]+[EA*0x10]+0,0x59ed	|P3(m,o,v) move from ccr
	.word 0xff00,0x4200, [SIZ*0x1000]+[EA*0x100]+[0*0x10]+0,0x4983	|P3(c,l,r)
	.word 0xffc0,0x44c0, [EA*0x1000]+[ESC*0x100]+[CCR*0x10]+0,0x59ed	|P3(m,o,v) move to ccr
	.word 0xff00,0x4400, [SIZ*0x1000]+[EA*0x100]+[0*0x10]+0,0x1cae	|P3(n,e,g)
	.word 0xffc0,0x46c0, [EA*0x1000]+[ESC*0x100]+[SR*0x10]+0,0x59ed	|P3(m,o,v) move to sr
	.word 0xff00,0x4600, [SIZ*0x1000]+[EA*0x100]+[0*0x10]+0,0x51ee	|P3(n,o,t)
	.word 0xffb8,0x4880, [SZ6*0x1000]+[EA*0x100]+[0*0x10]+0,0x5305	|P3(e,x,t)
	.word 0xfff8,0x4840, [EA*0x1000]+[0*0x100]+[0*0x10]+0,0x06f3,0x0010	|P3(s,w,a),P1(p)
	.word 0xffc0,0x4840, [SZ6*0x1000]+[EA*0x100]+[0*0x10]+0,0x04b0	|P3(p,e,a)
	.word 0xffc0,0x4800, [EA*0x1000]+[0*0x100]+[0*0x10]+0,0x0c4e,0x0004	|P3(n,b,c),P1(d)
	.word 0xff80,0x4880, [SZ6*0x1000]+[IMM*0x100]+[EA*0x10]+0,0x59ed,0xd		| store multiple
	.word 0xff80,0x4c80, [SZ6*0x1000]+[IMM*0x100]+[EA*0x10]+REV,0x59ed,0xd	| load multiple
	.word 0xfff0,0x4e40, [ESC*0x1000]+[MVQ*0x100]+[0*0x10]+0,0x0654,0x0010	|P3(t,r,a),P1(p)
	.word 0xfff8,0x4e50, [AX*0x1000]+[IMM*0x100]+[0*0x10]+0,0x392c,0x000b	|P3(l,i,n),P1(k)
	.word 0xfff8,0x4e58, [AX*0x1000]+[0*0x100]+[0*0x10]+0,0x31d5,0x000b	|P3(u,n,l),P1(k)
	.word 0xfff8,0x4e60, [AX*0x1000]+[ESC*0x100]+[USP*0x10]+0,0x59ed	|P3(m,o,v) move to usp
	.word 0xfff8,0x4e68, [ESC*0x1000]+[USP*0x100]+[AX*0x10]+0,0x59ed	|P3(m,o,v) move from usp
	.word 0xffff,0x4e70, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x4cb2,0x0285	|P3(r,e,s),P2(e,t)
	.word 0xffff,0x4e71, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x41ee	|P3(n,o,p)
	.word 0xffff,0x4e72, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x3e93,0x0010	|P3(s,t,o),P1(p)
	.word 0xffff,0x4e73, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x1692	|P3(r,t,e)
	.word 0xffff,0x4e74, [IMM*0x1000]+[0*0x100]+[0*0x10]+0,0x1292	|P3(r,t,d)
	.word 0xffff,0x4e75, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x4e92	|P3(r,t,s)
	.word 0xffff,0x4e76, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x0654,0x02d0	|P3(t,r,a),P2(p,v)
	.word 0xffff,0x4e77, [0*0x1000]+[0*0x100]+[0*0x10]+0,0x4a92	|P3(r,t,r)
	.word 0xffc0,0x4ec0, [EA*0x1000]+[0*0x100]+[0*0x10]+0,0x41aa	|P3(j,m,p)
	.word 0xf1c0,0x4180, [EA*0x1000]+[DY*0x100]+[0*0x10]+0,0x2d03	|P3(c,h,k)
	.word 0x8000,0x8000, [ESC*0x1000]+[UUO*0x100]+[0*0x10]+0,0
	.word -1
