/* rcsid[]="$Header: debug.h,v 820.1 86/12/04 19:53:06 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/* debugging flag definitions: */

extern long debug;

#define	D_DS		0x00000001 /* File system simulated across serial line*/
#define	D_SLP		0x00000002 /* Process stuff in slp.c*/
#define	D_TRAP		0x00000004 /* Traps and system calls */
#define	D_UREG		0x00000008 /* Setting user registers */

#define D_MAIN		0x00000010 /* Startup and initialization */
#define D_DK		0x00000020 /* Interphase controller drivers */
#define	D_DF		0x00000040 /* Floppy disk drivers */
#define	D_DW		0x00000080 /* Winchester and rimfire drivers */

#define D_CB1		0x00000100 /* ? */
#define	D_RUN		0x00000200 /* Scheduling */
#define D_PMEM		0x00000400 /* Physical memory debugging */
#define D_VMEM		0x00000800 /* Virtual memory debugging */

#define D_SNOOP		0x00001000 /* Snooper. kernel instrumentation */
#define D_BAB		0x00002000 /* Turn on bus analyzer board at boot time */
#define D_KPROF 	0x00004000 /* Kernel profiling */
#define D_MALLOC 	0x00008000 /* Memory allocation debugging*/

#define D_FILESYS 	0x00010000 /* File system debugging */
#define D_VG		0x00020000 /* Valid Video Graphics debug */
#define D_BRKTODB	0x00040000 /* Console break enters low level debugger */
#define D_PT            0x00080000 /* Network packet trace */

#define D_DR    	0x00100000 /* Rimfire 45 debug */
#define D_LOCK  	0x00200000 /* Shadowmap and locking debug */
#define D_PIB   	0x00400000 /* PIB debug */
#define D_MULTIMEG 	0x00800000 /* Multiple megabyte debug */

#define D_TEMP		0x00800000 /* Temporary flag for the "current" bug */

#define D_PTO           0x01000000 /* Network timout trace */
#define D_IP            0x02000000 /* IP protocol */
#define D_COW		0x04000000 /* Copy-on-write code */
#define D_CTXT		0x08000000 /* Hardware context code */

#define D_PAGEIN	0x10000000 /* Paging in from disk */
#define D_CORE		0x20000000 /* Enter debugger instead of core dump */
#define D_DUNNO		0x40000000 /* Unused... */
#define D_SEG0UNP	0x80000000 /* Leave physical segment 0 unprotected */

#ifdef DEBUG
#define DODEBUG(SYM,X) if (debug&(SYM)) {printf X;}
#define PRINTF(X) printf X ;

#else
#define DODEBUG(SYM,X) /* if (debug&(SYM)) X; */
#define PRINTF(X) /* printf(X); */
#endif
