static char rcsid[] = "";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	fuintf.c	1.0	85/03/26	*/

#include "../h/param.h"
#include "../h/mbuf.h"
#include "../h/socket.h"
#include "../net/if.h"
#include "../fusion/fusion.h"

#define MAX_INTERFACE 1

struct ifnet * intfTable[MAX_INTERFACE];/* Pointers to found interfaces */
char *  fuTable[MAX_INTERFACE];		/* Fusion driver identifier */
static u_char pktBuffer[1600];		/* Contiguous input packet buffer */

extern u_char commonAddress[];

fu_command(drv_sel, command, arg1, arg2)
    char ** drv_sel;
    int command;
    char ** arg1;
    char ** arg2;
{
    struct mbuf * m;		/* Packet buffer */

    switch(command)
	{

    /* Put driver interface into service */

	case FUCMD_online:
	    if ((int)arg1 != 0)
		return(-1);

	/* Find interface supporting AF_NS */

	    if(!(intfTable[0] = if_ifwithaf(AF_NS)))
		return(-1);

	    fuTable[0] = *arg2;
	    *drv_sel = 0;
	    break;

    /* Take driver interface out of service */

	case FUCMD_offline:
	    if((*drv_sel != 0) || (intfTable[0] == 0))
		return(-1);
	    intfTable[0] = 0;
	    break;

	case FUCMD_getaddr:
	    if((*drv_sel != 0) || (intfTable[0] == 0))
		return(-1);

	/* !!!! SIDE EFFECT !!!! */
	/* Get Ethernet address */
	/* !!!! SIDE EFFECT !!!! */

	    bcopy(commonAddress, arg1, 6);
	    break;

	default:
	    return(-1);
	}

    return(0);
}

fu_output(drv_sel, ptr, length)
    char * drv_sel;
    char * ptr;
    int length;
{
    struct mbuf * m0 = 0;	/* Base of chain */
    struct mbuf * m = 0;	/* Next entry in chain */
    struct mbuf * last_m = 0;	/* Last entry in chain */
    struct sockaddr socket;	/* Dummy socket to pass AF_NS */

    if((drv_sel != 0) || (intfTable[0] == 0) || (length <= 0))
	return(-1);

    while(length)
	{
	if(!(m = m_get(M_DONTWAIT, MT_FUSION)))
	    {
	    m_freem(m0);
	    return(0);
	    };

	if(!m0)
	    m0 = m;
	else
	    last_m->m_next = m;

	last_m = m;

	m->m_off = MMINOFF;
	m->m_len = MIN(length, MLEN);
	bcopy(ptr, mtod(m, char *), m->m_len);

	ptr += m->m_len;
	length -= m->m_len;
	}
    
    socket.sa_family = AF_NS;
    (intfTable[0]->if_output)(intfTable[0], m0, &socket);
    return(0);
}

fu_pktinput(ptr, length)
    char * ptr;
    int length;
{
    if(intfTable[0])
	fu_input(fuTable[0], ptr, length);
}
