static char rcsid[] = "$Header: efs_fstat.c,v 820.1 86/12/04 19:47:37 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Perform a stat on an open remote file.
 *
 * jam 840207-09-11-22
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/file.h"
#include "../h/user.h"
#include "../vnet/vnet.h"
#include "../h/inode.h"
#include "../h/stat.h"

#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

struct efs_fstatCall {
	u_long	rfd;		/* Remote file descriptor */
};

struct efs_fstatReturn {
	int	error;		/* Error number or 0 on success */
	struct stat stat;	/* Buffer containing status */
};

efs_fstat(fp, usb)
   struct file *fp;
   caddr_t usb;
{
	register struct efs_remoteFile *remote = fp->f_remote;
	register struct efs_fstatCall *params;
	register struct efs_fstatReturn *results;

	if (remote->state == EFS_FILE_CRASHED)
		return(ESERVERCRASHED);
	params = efs_makePacket(fstat, 0);
	params->rfd = remote->rfd;
	efs_incClient(fstats);
	results = (struct efs_fstatReturn *)efs_call(remote->conn,EFS_FSTAT,params);
	if (results == NULL)
		return;
	u.u_error = results->error;
	if (u.u_error == 0)
		u.u_error = copyout((caddr_t)&results->stat, usb,
				    sizeof(results->stat));
	rpc_freeResults(results);
}

caddr_t
efs_remoteFstat(clientConn, clientId, operation, params)
   connection_t *clientConn;
   u_long clientId;
   u_short operation;
   struct efs_fstatCall *params;
{
	register struct efs_fstatReturn *results;
	register efs_localFile_t *local;

	efs_incServer(fstats);
	results = efs_makeReturnPacket(params,fstat, 0);
	if ((local = efs_rfdToLocal(params->rfd)) == NULL)
		results->error = EBADF;
	else {
		ino_stat((struct inode *)local->fp->f_data, &results->stat);
		results->error = 0;
	}
	rpc_freeParams(params);
	return((caddr_t)results);
}
