/* rcsid[]="$Header: conn.h,v 820.1 86/12/04 19:43:25 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Header for the connection manager
 *
 *	Bakul Shah
 *
 * bvs 840223 -- original version
 * jam 840228-0410
 * bvs 840322
 * bog 850709 -- need definitions from vnet/vnet.h, so include it.
 */

#ifndef	CONN_ALREADY_DEFINED
#define	CONN_ALREADY_DEFINED

/*
 * We need definitions from <vnet/vnet.h> here. (bog)
 */

#ifdef	KERNEL
#include "../vnet/vnet.h"
#else	not KERNEL
#include <vnet/vnet.h>
#endif	not KERNEL

typedef struct connection {
	struct connection *next;	/* next entry in the hash bucket */
	short		flags;		/* special flags */
	u_short		version;	/* version of connection manager */
	short		state;		/* State of the connection */
	long		time;		/* time when a conn pkt was received */
	long		timeSinceUp;	/* how long the node has been up */
	long		timeTillDown;	/* when the node will to go down */
	node_t 		node;		/* connection is to this node */
	long		generation;	/* kernel generation number */
	char *		name;		/* name of the node */
	short		count;		/* number of active references */
	long		seqno;		/* sequence number for resync. */
} connection_t;

/*
 * values for the connection.state field
 */
#define CONN_IDLE	0		/* struct is free for use */
#define CONN_ACTIVE	1		/* connection is known to be active */
#define CONN_CRASHED	3		/* no conn pkt for last 180 seconds */
#define CONN_SHUTDOWN	4		/* connection was shutdown */

#define CONNstateIDLE		0
#define CONNstateACTIVE		1
#define CONNstateINACTIVE	2
#define CONNstateCRASHED	3
#define CONNstateSHUTDOWN	4

/*
 * flag values
 */
#define CONN_INACTIVE	0x0001		/* no conn pkt for last 90 seconds */
#define CONN_SHUTTING_DOWN 0x0002	/* the connection is being shut down */
#define CONN_CLEANUP	0x0004		/* connection is being cleaned up */
#define	CONN_SUPER_USER	0x1000		/* the node can be a super user */
#define CONN_NOACCESS	0x2000		/* the node is not allowed any access */

/*
 * Conn exception type values
 */
#define CONN_UP		0		/* A connection has just come up */
#define CONN_DOWN	1		/* A connection has just gone down */

/*
 * time constants in seconds
 */
#define CONN_PERIOD_GOING_DOWN_BRDCAST	10
#define CONN_PERIOD_IM_ALIVE_BRDCAST	30
#define CONN_PERIOD_JUST_LISTENING	30
#define CONN_TIME_INACTIVE		90
#define CONN_TIME_CRASHED		180

#endif	CONN_ALREADY_DEFINED
