/* static char rcsid[] = "$Header: saio.h,v 86.1 86/07/21 14:57:03 bog Exp $"; */

/************************************************************************\
**									**
**				Copyright 1986				**
**			VALID LOGIC SYSTEMS INCORPORATED		**
**									**
**	This listing contains confidential proprietary information	**
**	which is not to be disclosed to unauthorized persons without	**
**	written consent of an officer of Valid Logic Systems 		**
**	Incoroporated.							**
**									**
**	The copyright notice appearing above is included to provide	**
**	statutory protection in the event of unauthorized or 		**
**	unintentional public disclosure.				**
**									**
\************************************************************************/

/*
 * Header file for standalone UNIX I/O library.
 *
 * 5-6/86:  Bill O. Gallmeister 
 *	Modified, based on Valid boot code and Valid UNIX.
 */

/*
 * Io block: includes an
 * inode, cells for the use of seek, etc,
 * and a buffer.
 *
 * These are generic blocks used in file access,
 * as well as for scratchpad reads and writes.
 */
struct	iob {
	int	i_flgs;		/* see F_ below */
	struct	inode *i_ino;	/* inode, if file */
	int	i_unit;		/* pseudo device unit */
#ifndef INODE_LIVES_IN_IOB
	int	i_dev;		/* device type number: an index into devsw[] */
#endif  INODE_LIVES_IN_IOB
	daddr_t	i_boff;		/* block offset on device (partition #+trash) */
	daddr_t	i_cyloff;	/* cylinder offset on device */
	off_t	i_offset;	/* seek offset in file */
	daddr_t	i_bn;		/* 1st block # of next read/write */
	char	*i_ma;		/* memory address of i/o buffer */
	int	i_cc;		/* character count of transfer */
	int	i_error;	/* error # return */
	int	i_errcnt;	/* error count for driver retries */
	int	i_errblk;	/* block # in error for error reporting */
	struct fs *i_fs;	/* file system super block info */
	char	i_buf[MAXBSIZE];/* i/o buffer */
};

/*
 * All file systems in use are stored in the iofs array.
 */
struct io_fs {
	int iof_inuse;		/* Whether this structure is in use. */
	int iof_dev;		/* Device the F.S. refers to. */
	struct fs iof_fs;
};

/*
 * All inodes in use are stored in the iofs array.
 */
struct io_inode {
	int ioi_inuse;		/* Whether this structure is in use. */
	struct inode ioi_inode;
};

/*
 * Bits for iof_inuse and ioi_inuse flag.
 */
#define IOFS_INUSE	1
#define IOFS_FREE	0

#define NIOFS 4		/* Number of "file systems" allowable. */


#define F_READ		0x1	/* file opened for reading */
#define F_WRITE		0x2	/* file opened for writing */
#define F_ALLOC		0x4	/* buffer allocated */
#define F_FILE		0x8	/* file instead of device */
#define F_TAPE		0x10	/* Device is a tape raw device */
#define F_ECCLM		0x20	/* limit # of bits in ecc correction */
#define F_SSI		0x40	/* set skip sector inhibit */
#define F_SEVRE		0x80	/* Severe burnin (no retries, no ECC) */
/* io types */
#define	F_RDDATA	0x0100	/* read data */
#define	F_WRDATA	0x0200	/* write data */
#define F_HDR		0x0400	/* include header on next i/o */
#define F_CHECK		0x0800	/* perform check of data read/write */
#define F_HCHECK	0x1000	/* perform check of header and data */

#define	F_TYPEMASK	0xff00

/*
 * Device switch.
 */
struct devsw {
	char	*dv_name;
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
	int	(*dv_ioctl)();
};

struct devsw devsw[];

/*
 * Request codes. Must be the same a F_XXX above
 */
#define	READ	1
#define	WRITE	2

#define	NBUFS	4

char	b[NBUFS][MAXBSIZE];
daddr_t	blknos[NBUFS];

#define	NFILES	4

extern	int errno;	/* just like unix */

/* error codes */

#define	EOFFSET	2	/* relative seek not supported */
#define	EDEV	3	/* improper device specification on open */

#define	EUNIT	5	/* improper unit specification */


#define	ECMD	10	/* undefined driver command */
#define	EBSE	11	/* bad sector error */
#define	EWCK	12	/* write check error */
#define	EECC	13	/* uncorrectable ecc error */
#define	EHER	14	/* hard error */

/* ioctls -- for disks and tapes */
#define	SAIOCTL(c,i)	(((c)<<8)|(i))	/* Ioctl-bladed screwdriver. */
/* Disk ioctls */
#define SAIODISK	'd'
#define	SAIOGPARM	SAIOCTL(SAIODISK,1)	/* get the disk's parameters */
#define	SAIOSPARM	SAIOCTL(SAIODISK,2)	/* set the disk's parameters */
#define SAIORLAB	SAIOCTL(SAIODISK,3)	/* read the disk label */
#define SAIOWLAB	SAIOCTL(SAIODISK,4)	/* write the disk label */
#define SAIOFMTTRK	SAIOCTL(SAIODISK,5)	/* format a specified track */
#define SAIOFMTDSK	SAIOCTL(SAIODISK,6)	/* format the whole disk */
#define SAIOMAP		SAIOCTL(SAIODISK,7)	/* map spcified bad track */
#define SAIOMAPLST	SAIOCTL(SAIODISK,8)	/* map out bad tracks in list */
#define SAIODEBUG	SAIOCTL(SAIODISK,9)	/* toggle debug flag */
/* Tape ioctls */
#define SAIOTAPE	't'
#define SAIOTWFM	SAIOCTL(SAIOTAPE,1)	/* Write file marker. */
#define SAIOTREW	SAIOCTL(SAIOTAPE,2)	/* Rewind tape. */

/*
 * Directory data. Used for directory read-through.
 */
struct dirstuff {
	int loc;
	struct iob *io;
};

/*
 * Flag value for find().  Controls whether to follow 
 * symlinks in directory search or not.
 */
#define	FOLLOW_SYMLINK	0x80000000
#define CREATE_LINK	0x40000000
#define	DELETE		0x20000000

/*
 * Flags for calls to sys.c: readdir().
 */
#define CREATE 1
#define LOOKUP 2

/*
 * Size of a little buffer you can put on the stack without knocking it over.
 */
#define	LITTLEBSIZE	1024
