static char rcsid[] = "$Header: vgb.c,v 820.1 86/12/04 19:57:00 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	Valid Peripheral Board:  Board-dependent code			*/

#include "../s32dev/useful.h"
#include "../s32dev/regmuck.h"
#include "../h/types.h"		/* jht for tty.h 'caddr_t' */

#define VGBMNBIT 3
#define VGBMNMSK (1<<VGBMNBIT)-1
#define VGBSHBIT 0
#define VGBSHMSK (1<<VGBSHBIT)-1
#define NBD	VGBSHMSK+1

#include "../s32dev/vpb.h"

static byte pdvcflg[VGBMNMSK+1];
extern int vgintr();

/*	Initialize a board data table for VGBs				*/
struct bdt vgbdt = {
	VGB,				/* type				*/
	0,				/* altbdt			*/
	0,				/* owner			*/
	0X00000080,			/* mdlegal			*/
	pdvcflg,			/* dvcflag			*/
	0x2006,				/* intpri			*/
	3*PGPERSEG,			/* Mbpgs (2 for dmgr, 1 for vgb)*/
	VGBSHBIT,			/* share bits			*/
	VGBSHMSK,			/* share mask			*/
	VGBMNBIT,			/* minor bits			*/
	VGBMNMSK,			/* minor mask			*/
	NBD,				/* maxboards			*/
	0,				/* totboards			*/
	SEGALIGN,			/* flag				*/
	0,				/* pad for alignment		*/
	{0,0,0,0},			/* doio				*/
	vgintr,			  	/* intrpt			*/
	0,				/* watch			*/
	0X4000,				/* onbdend			*/
	0X30000,			/* offbdbase			*/
	{0X4069,
	 0X4071
	},				/* segregad			*/
	{{BYSET,0X20000000,0X4019},	/*	RUN			*/
	 {BYSET,0X20000000,0X8001},	/*	HALT			*/
	 {BYSET,0X80000000,0X4019},	/*      REDLED			*/
	 {BYSET,0X40000000,0X4019},	/*      GREENLED		*/
	 {BYSET,0X01000000,0X8001}	/*      RING			*/
	},				/* regdef structures		*/
					/* b[NBD]			*/
};

