static char rcsid[] = "$Header: pibdata.c,v 820.1 86/12/04 19:56:11 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * The board data table for the IBM pib.  Modified from a 4.2(10/27/82)
 * copy to use 4.1c header file conventions and the NIBMPIB hack (to
 * prevent IBM pib files being needed by VAX kernels).
 */

#include "pib.h"
#if NPIB > 0

#include "../h/types.h"


/*	Valid Peripheral Board:  Board-dependent code			*/
#include "../s32dev/useful.h"
#include "../s32dev/regmuck.h"

#define PIBMNBIT 5
#define PIBMNMSK (1<<PIBMNBIT)-1
#define PIBSHBIT 0
#define PIBSHMSK (1<<PIBSHBIT)-1
#define NBD	1

#include "../s32dev/vpb.h"

extern int pibint(), pibopen(), pibclose(), pibio(), pibctl();
extern byte pdvcflg[];

/*	Initialize a board data table for PIBs				*/
struct bdt pibdt = {
	PIB,				/* type				*/
	0,				/* altbdt			*/
	0,				/* owner			*/
	0X91001900,			/* mdlegal			*/
	pdvcflg,			/* dvcflag			*/
	0x2006,				/* intpri			*/
	PGPERSEG,			/* Mbpgs			*/
	PIBSHBIT,			/* share bits			*/
	PIBSHMSK,			/* share mask			*/
	PIBMNBIT,			/* minor bits			*/
	PIBMNMSK,			/* minor mask			*/
	NBD,				/* maxboards			*/
	0,				/* totboards			*/
	SEGALIGN+DSPMGROK,		/* flag				*/
	0,				/* pad for alignment		*/
	{pibopen,pibclose,pibio,pibctl},/* doio				*/
	pibint,				/* intrpt			*/
	0,				/* watch			*/
	0X4000,				/* onbdend			*/
	0X70000,			/* offbdbase			*/
	{0X4068,
	 0X4070
	},				/* segregad			*/
	{{BYSET,0X20000000,0X4019},	/*	RUN			*/
	 {BYSET,0X20000000,0X8001},	/*	HALT			*/
	 {BYSET,0X80000000,0X4019},	/*      REDLED			*/
	 {BYSET,0X40000000,0X4019},	/*      GREENLED		*/
	 {BYSET,0X01000000,0X8001}	/*      RING			*/
	},				/* regdef structures		*/
					/* b[NBD]			*/
};

#endif NPIB > 0
