/* rcsid[]="$Header: mbvar.h,v 820.1 86/12/04 19:55:58 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*			Copyright 1984 - 1986				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * This file contains definitions related to the kernel structures
 * for dealing with the multibus.
 *
 * This file is derived from vaxuba/ubavar.h, with unnecessary
 * things taken out.  Sundev/mbvar.h would have been better suited
 * for our purpose.  But it is not to be had.
 *
 * Each multibus has a mb_hd structure.
 * Each multibus controller which is not a device has a mb_ctlr structure.
 * Each multibus device has a mb_device structure.
 */

/*
 * Per-multibus structure.
 *
 * This structure holds the interrupt vector for the multibus,
 * and its address in physical and virtual space.  At boot time
 * we determine the devices attached to the mb and their
 * interrupt vectors, filling in mh_vec.
 *
 * When an interrupt occurs during normal operation, we call
 * all of the device interrupt handlers at this ipl in turn.
 *
 * We make provisions for vectors 1 through 7, but startrtclock() and
 * other device init routines may override.
 */
#define MB_NVEC	7		/* number of different vectors, starting at 1 */
#define MB_NDEV	8		/* number of devices per vector */
struct mb_vec {
	int (*mv_func)();
	int mv_unit;
};

/*
 * Per-controller structure.
 * (E.g. one for each disk and tape controller)
 *
 * If a controller has devices attached, then there are
 * cross-referenced mb_drive structures.
 * The queue of devices waiting to transfer is attached here.
 */
struct mb_ctlr {
	struct	mb_driver *mc_driver;
	short	mc_ctlr;	/* controller index in driver */
	short	mc_alive;	/* controller exists */
	int	(**mc_intr)();	/* interrupt handler(s) */
	caddr_t	mc_addr;	/* address of device in i/o space */
};

/*
 * Per ``device'' structure.
 * (A controller has devices.)
 * (Everything else is a ``device''.)
 *
 * If a controller has many devices attached, then there will
 * be several mb_device structures associated with a single mb_ctlr
 * structure.
 *
 * This structure contains all the information necessary to run
 * a multibus device such as a sc.  It also contains information
 * for slaves of multibus controllers as to which slave on the controller
 * this is.  A flags field here can also be given in the system specification
 * and is used to tell which terminal lines are hard wired or other device
 * specific parameters.
 */
struct mb_device {
	struct	mb_driver *md_driver;
	short	md_unit;	/* unit number on the system */
	short	md_ctlr;	/* ctlr number; -1 if none */
	short	md_slave;	/* slave on controller */
	int	(**md_intr)();	/* interrupt handler(s) */
	caddr_t	md_addr;	/* address of device in i/o space */
	short	md_dk;		/* if init 1 set to number for iostat */
	int	md_flags;	/* parameter from system specification */
	short	md_alive;	/* device exists */
	short	md_type;	/* driver specific type information */
	caddr_t	md_physaddr;	/* phys addr, for standalone (dump) code */
/* this is the forward link in a list of devices on a controller */
	struct	mb_device *md_forw;
/* if the device is connected to a controller, this is the controller */
	struct	mb_ctlr *md_mi;
};

/*
 * Per-driver structure.
 *
 * Each multibus driver defines entries for a set of routines
 * as well as an array of types which are acceptable to it.
 * These are used at boot time by the configuration program.
 */
struct mb_driver {
	int	(*mdr_reset)();		/* reset a driver to disable int's */
	int	(*mdr_probe)();		/* see if a driver is really there */
	int	(*mdr_slave)();		/* see if a slave is there */
	int	(*mdr_attach)();	/* setup driver for a slave */
	u_short	*mdr_addr;		/* device csr addresses */
	char	*mdr_dname;		/* name of a device */
	struct	mb_device **mdr_dinfo;	/* backpointers to mbdinit structs */
	char	*mdr_cname;		/* name of a controller */
	struct	mb_ctlr **mdr_cinfo;	/* backpointers to mbcinit structs */
};

#ifdef KERNEL
/*
 * Multibus interrupt handlers
 */
int (*mbint[MB_NVEC])();		/* interrupt catchers */
int (*mbintx[MB_NVEC])();		/* simple versions of above */
struct mb_vec mb_vec[MB_NVEC][MB_NDEV + 1];

/*
 * mbcinit and mbdinit initialize the mass storage controller and
 * device tables specifying possible devices.
 */
extern	struct	mb_ctlr mbcinit[];
extern	struct	mb_device mbdinit[];
#endif KERNEL
