/* rcsid[]="$Header: param.h,v 820.1 86/12/04 19:53:47 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	param.h	4.30	83/02/21	
 *
 * History:
 * =======
 *	updated for VALID  83/07/21   sbs,jfr,sas
 * 860209 jht -- Add code to support 32Mb, 64Mb, 128Mb vaddr: M68020_REV_B
 * 860308 jht -- Add code for LRU allocation of virtual segments.
 */

#ifndef	S32_PARAM_ALREADY_DEFINED
#define	S32_PARAM_ALREADY_DEFINED

#ifdef	M68020_REV_B
#include "../machine/context.h"		/* smaps_t */
#endif	M68020_REV_B

/*
 * Machine type dependent parameters.
 */

/*
 * Tunable variables which do not usually vary per system.
 *
 * The sizes of most system tables are configured
 * into each system description.  The file system buffer
 * cache size is assigned based on available memory.
 * The tables whose sizes don't vary often are given here.
 */

#define	SSIZE	1		/* initial stack size (*4096 bytes) */
#define	SINCR	1		/* increment of stack (*4096 bytes) */

/*
 * fundamental constants of the implementation--
 * cannot be changed easily.
 */

#define	NBPG		4096		/* Physical page size */
#define	PGOFSET		(NBPG-1)	/* byte offset into page */
#define	PGSHIFT		12		/* LOG2(NBPG) */

#ifdef BIGUPAGE
#ifndef	M68020_REV_B
#define	UPAGES	2			/* pages of u-area */
#else	M68020_REV_B
#define	UPAGES	(2+(sizeof(vSMaps_dlist_t)*ptos(BIGMAP_PAGES))/NBPG)
#endif	M68020_REV_B
#else BIGUPAGE
#define	UPAGES	1			/* pages of u-area */
#endif BIGUPAGE
#define UWASTE	(stoc(1)-UPAGES)	/* page table entries wasted below
					   U page entry in user page tables */

#define	NGRPS	256			/* max number groups */

#define SEGSIZE		65536	/* Size of a physical segment in bytes */
#define SEGSHIFT	16	/* log2(SEGSIZE) */

#define PTOSSHIFT	(SEGSHIFT-PGSHIFT)	/* log2(SEGSIZE/NBPG) */
#define CTOSSHIFT	(SEGSHIFT-CLSHIFT)	/* log2(SEGSIZE/CLBYTES) */

#define MAXPHYS (1024 * 1024)

/*
 * Some macros for units conversion
 *
 * NOTE:  definitions of the form
 *
 *	((x) + M/N -1 ) >> ...)
 *
 * round UP to a whole number of units.
 */
/* Core clicks (4096 bytes) to segments (64K) and vice versa: ROUNDS UP */
#define	ctos(x)	(((x)+SEGSIZE/CLBYTES-1)>>CTOSSHIFT)
#define	stoc(x)	((x)<<CTOSSHIFT)

/* Round number of bytes up to whole number of segments */
#define	srnd(i)	(((i) + (SEGSIZE-1)) &~ (SEGSIZE-1))

#define	ptos(x)	(((x)+SEGSIZE/NBPG-1)>>PTOSSHIFT) /* Pages to segs: ROUNDS UP */
#define	PTOS(x)	((x)		     >>PTOSSHIFT) /* Pages to segs: UNROUNDED */

/* Bytes to segments: ROUNDS UP */
#define btos(x) (((x)+SEGSIZE-1)>>SEGSHIFT)
#define stob(x) ((x)<<SEGSHIFT)

/* Core clicks (4096 bytes) to disk blocks */
#define	ctod(x)	((x)<<(PGSHIFT-DEV_BSHIFT))
#define dtoc(x)	((x)/ctod(1))

#define dtob(x)	((x)*DEV_BSIZE)

/* clicks to bytes */
#define	ctob(x)	((x)<<CLSHIFT)

/* bytes to clicks: ROUNDS UP */
#define	btoc(x)	((((unsigned)(x)+CLBYTES-1)>>CLSHIFT))

/*
 * Machine-dependent bits and macros
 */

#define	USERMODE(ps)	(((ps) & PSL_SMODE) == 0)
#define	BASEPRI(ps)	(((ps) & PSL_INTPRI) == 0)

/*
 * Provide about n microseconds of delay.
 */
#define	DELAY(n)	{ register int N = (n)>>1; while (--N > 0); }

/*
 * Clustering of hardware pages on machines with ridiculously small
 * page sizes is done here.  The paging subsystem deals with units of
 * CLSIZE pte's describing NBPG (from vm.h) pages each... BSIZE must
 * be CLSIZE*NBPG in the current implementation, that is the paging subsystem
 * deals with the same size blocks that the file system uses.
 *
 * NOTE: SSIZE, SINCR and UPAGES must be multiples of CLSIZE
 */
#define CLSIZE		1
#define CLSIZELOG2	0

#define PPIB    (PZERO + 2)	/* Priority of sleep for PIB */

#define MBIO_SIZE	(8*1024) /* 8 K of multibus I/O space */

/* #define RTOLBYTES */		/* if bytes ordered from right to left */
#define fuibyte(x)		fubyte(x)
#define fuiword(x)		fuword(x)
#define suibyte(x,y)		subyte(x,y)
#define suiword(x,y)		suword(x,y)
#define copyiin(x,y,z)		copyin(x,y,z)
#define copyiout(x,y,z)		copyout(x,y,z)
#define	bcopy(from,to,count)	blt(to,from,count)

#define gsignal signal

#define	lobyte(X)	(((u_char *)&X)[1])
#define	hibyte(X)	(((u_char *)&X)[0])
#define	loword(X)	(((u_short *)&X)[1])
#define	hiword(X)	(((u_short *)&X)[0])

#define KVSIZE		256		/* Kernel virtual memory size (pages) */
#define KVBASE		0		/* Kernel virtual memory base (page) */
#ifdef BIGUPAGE
#ifdef	M68020_REV_B
#ifdef	BIDIRECTIONAL_LRU
#define UPAGENUM	0x0FC	/* btop(&u + sizeof(struct user)) < U_SMAPNUM */
#else	BIDIRECTIONAL_LRU
#define UPAGENUM	0x0FD	/* btop(&u + sizeof(struct user)) < U_SMAPNUM */
#endif	BIDIRECTIONAL_LRU

/*
 * Pages of U_sMaps[] entries within the upage
 */
#define U_SMAPSPAGES	((sizeof(vSMaps_dlist_t)*ptos(BIGMAP_PAGES))/NBPG)

/*
 * Put the U_sMaps page ABOVE the syscall stack
 * so that the map is out of harm's way...
 */
#define U_SMAPSNUM	(UPAGENUM+UPAGES-U_SMAPSPAGES)  /* Page # of U_sMaps */
#else	M68020_REV_B
#define UPAGENUM	0x0FE
#endif	M68020_REV_B
#else BIGUPAGE
#define UPAGENUM	0x00F
#endif BIGUPAGE
#define U_PAGE		(UPAGENUM * NBPG)
#define TMPSTACK	0x1000		/* Temporary stack for context switch */
#define SYM_PA		0x5000		/* Symbol table, 5 pages long */

#endif	S32_PARAM_ALREADY_DEFINED
