/* rcsid[]="$Header: clock.h,v 820.1 86/12/04 19:52:48 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Structure for the Intel 8253 microsecond clock
 */

#define CLKADDR_HW_ADDR		0x1d000		/* Hardware addr of clock */

#ifndef LOCORE
struct clock {
	char c_0;	/*0*/
	char c_c0;	/*1*/	/* Counter 0 */
	char c_1;	/*2*/
	char c_c1;	/*3*/	/* Counter 1 */
	char c_2;	/*4*/
	char c_c2;	/*5*/	/* Counter 2 */
	char c_3;	/*6*/
	char c_mode;	/*7*/	/* Mode register */
};

u_short clkparam;		/* used to restart the clock */

#define CLKADDR		((struct clock *) CLKADDR_HW_ADDR)

#else LOCORE	/* For machine/locore.s */

#define CLKADDR		CLKADDR_HW_ADDR

/*
 * Offsets from CLKADDR_HW_ADDR
 * to the (decrementing) counters.
 * These are used in machine/locore.s
 */
#define C_C0		1
#define C_C1		3
#define C_C2		5

#define C_MODE		7	/* Offset to the mode register */

#endif LOCORE

	/* Mode bits */

#define C_SEL	0xc0		/* Select counter */

#define C_SEL0	0x00		/* Counter 0 */
#define C_SEL1	0x40		/* Counter 1 */
#define C_SEL2	0x80		/* Counter 2 */

#define C_LATCH	0x00		/* Latch the counter */

#define C_BYTE1	0x10		/* Read/write byte 1 */
#define C_BYTE0	0x20		/* Read/write byte 0 */
#define C_WORD	0x30		/* Read/write both bytes (0 first) */

#define C_MODE0	0x00		/* Interrupt on terminal count */
#define C_MODE1	0x02		/* Programmable one-shot */
#define C_MODE2	0x04		/* Rate generator */
#define C_MODE3	0x06		/* Square wave rate generator */
#define C_MODE4	0x08		/* Software triggered strobe */
#define C_MODE5	0x0a		/* hardware triggered strobe */

#define C_BCD	0x01		/* count in bcd */

	/* clock rate */

#define C_RATE	1000000		/* 1 MHz */
