static char rcsid[] = "$Header: rpc_init.c,v 820.1 86/12/04 19:52:13 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * RPC initialization
 *
 *      Bakul Shah
 *
 * bvs 840203 -- original version
 * jam 840209-20-21-0301-05
 */

#include "../h/param.h"
#include "../h/socket.h"
#include "../net/if.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../h/proc.h"
#include "../h/mbuf.h"
#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"

#define RPC_STAT_INIT
#include "../s32/kstat.h"
#include "../rpc/rpc_stat.h"

struct ifnet * ifrpc;
int rpc_enabled = 0;

rpc_init()
{
	extern rpc_serverException();
	extern rpc_clientException();

	/*
	 * Hook up with the first driver that can carry RPC packets.
	 * If we can't find one then return.
	 */
	ifrpc = (struct ifnet *)0;

	/*
	 * Attach RPC module to the connection server
	 */
	conn_attach(rpc_serverException);
	conn_attach(rpc_clientException);
	rpc_initClientHash();
	rpc_initServerHash();
	rpc_enabled++;
	/*
	 * BUG remove once rpc is tested.
	 */
	timeServer_init();
	prpc_init();
}
