/* rcsid[]="$Header: types.h,v 820.1 86/12/04 19:49:35 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	types.h	6.1	83/07/29	*/

#ifndef HAVE_INCLUDED_TYPES
#define HAVE_INCLUDED_TYPES

/*
 * Basic system types and major/minor device constructing/busting macros.
 */

/* major part of a device */
#define	major(x)	((int)(((unsigned)(x)>>8)&0377))

/* minor part of a device */
#define	minor(x)	((int)((x)&0377))

/* make a device number */
#define	makedev(x,y)	((dev_t)(((x)<<8) | (y)))

typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;
typedef	unsigned short	ushort;		/* sys III compat */

#ifdef vax
typedef	struct	_physadr { int r[1]; } *physadr;
typedef	struct	label_t	{
	int	val[14];
} label_t;
#endif
#ifdef s32
typedef	struct	_physadr { short r[1]; } *physadr;
typedef	struct	label_t	{
#ifdef KERNEL
	int	val[15];	/* pc, d2-7, a2-7, pad[2] */
#else KERNEL
	int	val[15];	/* pc, d2-7, a2-7, mask, onstack */
#endif KERNEL
} label_t;
/*
 * Location of the users' stored
 * registers relative to start of val[]
 * with the label_t structure.
 * Usage is val[XX].
 *
 */
#define	LABEL_R2	0	/* M68000 data register D2 */
#define	LABEL_R3	1
#define	LABEL_R4	2
#define	LABEL_R5	3
#define	LABEL_R6	4
#define	LABEL_R7	5

#define	LABEL_AR2	6	/* M68000 address register A2 */
#define	LABEL_AR3	7
#define	LABEL_AR4	8
#define	LABEL_AR5	9

#define	LABEL_AR6	10	/* Frame pointer	*/
#define	LABEL_AR7	11	/* Stack pointer	*/
#define	LABEL_PC	12	/* Program Counter	*/
#define	LABEL_SR	13	/* System Status Register (SSR) long-aligned */
#endif s32
typedef	struct	_quad { long val[2]; } quad;
typedef	long	daddr_t;
typedef	char *	caddr_t;
typedef	u_long	ino_t;
typedef	long	swblk_t;
typedef	int	size_t;
typedef	int	time_t;
#ifdef s32
typedef	u_short	dev_t;
typedef	u_short	smap_t;
#else s32
typedef	short	dev_t;
#endif s32
typedef	int	off_t;

typedef	struct	fd_set { int fds_bits[1]; } fd_set;

#ifdef s32
#define void int
#endif s32

#endif HAVE_INCLUDED_TYPES
