#ifndef lint
static char sccsid[] = "%W% %Y% %Q% %G%";
#endif

/*
 * Build a swap configuration file.
 */
#include "config.h"

#include <stdio.h>
#include <ctype.h>

swapconf()
{
	register struct file_list *fl;
	struct file_list *do_swap();

	fl = conf_list;
	while (fl) {
		if (fl->f_type != SYSTEMSPEC) {
			fl = fl->f_next;
			continue;
		}
		fl = do_swap(fl);
	}
}

struct file_list *
do_swap(fl)
	register struct file_list *fl;
{
	FILE *fp;
	char  swapname[80], *cp;
	register struct file_list *swap;
	dev_t dev;

	if (eq(fl->f_fn, "generic")) {
		fl = fl->f_next;
		return (fl->f_next);
	}
	(void) sprintf(swapname, "swap%s.c", fl->f_fn);
#ifdef s32
	unlink(swapname);
#endif s32
	fp = fopen(path(swapname), "w");
	if (fp == 0) {
		perror(path(swapname));
		exit(1);
	}
	fprintf(fp, "#include \"../h/param.h\"\n");
	fprintf(fp, "#include \"../h/conf.h\"\n");
	fprintf(fp, "\n");
	/*
	 * If there aren't any swap devices
	 * specified, just return, the error
	 * has already been noted.
	 */
	swap = fl->f_next;
	if (swap == 0 || swap->f_type != SWAPSPEC) {
		(void) unlink(path(swapname));
		fclose(fp);
		return (swap);
	}
	fprintf(fp, "dev_t\trootdev = makedev(%d, %d);\n",
		major(fl->f_rootdev), minor(fl->f_rootdev));
	fprintf(fp, "dev_t\targdev  = makedev(%d, %d);\n",
		major(fl->f_argdev), minor(fl->f_argdev));
	fprintf(fp, "dev_t\tdumpdev = makedev(%d, %d);\n",
		major(fl->f_dumpdev), minor(fl->f_dumpdev));
	fprintf(fp, "\n");
	fprintf(fp, "struct\tswdevt swdevt[] = {\n");
	do {
		dev = swap->f_swapdev;
		fprintf(fp, "\t{ makedev(%d, %d),\t0,\t%d },\t/* %s */\n",
		    major(dev), minor(dev), swap->f_swapsize, swap->f_fn);
		swap = swap->f_next;
	} while (swap && swap->f_type == SWAPSPEC);
	fprintf(fp, "\t{ 0, 0, 0 }\n");
	fprintf(fp, "};\n");
	fclose(fp);
	return (swap);
}

static	int devtablenotread = 1;
static	struct devdescription {
	char	*dev_name;
	int	dev_major;
	struct	devdescription *dev_next;
} *devtable;

/*
 * Given a device name specification figure out:
 *	major device number
 *	partition
 *	device name
 *	unit number
 * This is a hack, but the system still thinks in
 * terms of major/minor instead of string names.
 */
dev_t
nametodev(name, defunit, defpartition)
	char *name;
	int defunit;
	char defpartition;
{
	char *cp, partition;
	int unit;
	register struct devdescription *dp;

	cp = name;
	if (cp == 0) {
		fprintf(stderr, "config: internal error, nametodev\n");
		exit(1);
	}
	while (*cp && !isdigit(*cp))
		cp++;
	switch (machine) {

	case MACHINE_VAX:
	case MACHINE_SUN:
		unit = *cp ? atoi(cp) : defunit;
		break;

	case MACHINE_S32:
		unit = *cp ? *cp - '0' : defunit;
		break;
	}
	if (unit < 0 || unit > 7) {
		fprintf(stderr,
"config: %s: invalid device specification, unit out of range\n", name);
		unit = defunit;			/* carry on more checking */
	}
	switch (machine) {
	case MACHINE_VAX:
	case MACHINE_SUN:
		while (*cp && isdigit(*cp))
			*cp++ = '\0';
		break;

	case MACHINE_S32:
		if (*cp)
			*cp++ = '\0';
		break;
	}
	partition = *cp ? *cp : defpartition;
	switch (machine) {
	case MACHINE_VAX:
	case MACHINE_SUN:
		if (partition < 'a' || partition > 'h') {
			fprintf(stderr,
"config: %c: invalid device specification, bad partition\n", *cp);
			partition = defpartition;	/* carry on */
		}
		break;

	case MACHINE_S32:
		if (!isxdigit(partition)) {
			fprintf(stderr,
"config: %c: invalid device specification, bad partition\n", *cp);
			partition = defpartition;	/* carry on */
		}
		break;
	}
	if (devtablenotread)
		initdevtable();
	for (dp = devtable; dp->dev_next; dp = dp->dev_next)
		if (eq(name, dp->dev_name))
			break;
	if (dp == 0) {
		fprintf(stderr, "config: %s: unknown device\n", name);
		return (NODEV);
	}
	switch (machine) {
	case MACHINE_VAX:
	case MACHINE_SUN:
		return makedev(dp->dev_major, (unit << 3) + (partition - 'a'));

	case MACHINE_S32:
		return makedev(dp->dev_major, (unit << 4) +
			(partition - (isdigit(partition) ? '0' : 'a' - 10)));
	}
	/*NOTREACHED*/
}

char *
devtoname(dev)
	dev_t dev;
{
	char buf[80]; 
	register struct devdescription *dp;

	if (devtablenotread)
		initdevtable();
	for (dp = devtable; dp->dev_next; dp = dp->dev_next)
		if (major(dev) == dp->dev_major)
			break;
	if (dp == 0)
		dp = devtable;
	switch (machine) {
	case MACHINE_VAX:
	case MACHINE_SUN:
		sprintf(buf, "%s%d%c", dp->dev_name,
			minor(dev) >> 3, (minor(dev) & 07) + 'a');
		break;

	case MACHINE_S32:
		sprintf(buf, "%s%d%x", dp->dev_name,
			minor(dev) >> 4, (minor(dev) & 017));
		break;
	}
	return (ns(buf));
}

initdevtable()
{
	char buf[BUFSIZ];
	int maj;
	register struct devdescription **dp = &devtable;
	FILE *fp;

	sprintf(buf, "../conf/devices.%s", machinename);
	fp = fopen(buf, "r");
	if (fp == NULL) {
		fprintf(stderr, "config: can't open %s\n", buf);
		exit(1);
	}
	while (fscanf(fp, "%s\t%d\n", buf, &maj) == 2) {
		*dp = (struct devdescription *)malloc(sizeof (**dp));
		(*dp)->dev_name = ns(buf);
		(*dp)->dev_major = maj;
		dp = &(*dp)->dev_next;
	}
	*dp = 0;
	fclose(fp);
	devtablenotread = 0;
}
