/************************************************************************
 *   Metal Message file conversion routine... 
 *
 *  From 1.2xx or 1.3xx TO 1.5xx
 *
 ************************************************************************
 *
 *  08/16/86   Updated for newest msg file format..
 *  01/29/86   Started... Based on message purge function...
 *
 ***********************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"

typedef struct	{
	unsigned number;		/* message # */
	unsigned seek;			/* cp/m record, seek loc of msg */
	unsigned parent;		/* parent message #, if any	*/
	unsigned reply;			/* reply message #, if any	*/
	char	receiver[36];		/* who's msg to?	*/
	char	fsend[15];		/* who's msg from (first name)	*/
	char	lsend[21];		/*  "     "    "  (last name)	*/
	char	status;			/* private/normal, etc.. */
	int	lines;			/* # of lines in message */
	char	date[9];		/* date message entered */
	char	time[9];		/* time message entered */
	char	topic[29];		/* subject of message	*/
	} omsg_record;	/* old msg type */

char *filen();
FILE *msource,*mdest;
static int new_index,nmsg_rec;	/* index variable, last+1 rec of msg file */

main(argc,argv)
 int argc;
 char *argv[];
{
int tindex,err_flag;
unsigned total;
char temp[50],*tp;
omsg_record *mptr;

send("\nMessage file conversion program 1.2xx/1.3xx to 1.5xx\n\n");

if (argc!=3 || strlen(argv[1])>5 || strlen(argv[2])>5 || !index(argv[1],':'))
	{
	send("\nUsage:  mconvert <old duu:> <new duu:>");
	return;
	}

msg=malloc(O.MAXTOTMSGS*8+100);		/* table */
ogcntrs(filen(argv[1],"counters"));	/* get old counters */
read_sum(argv[1]);			/* read summary file to build table */

new_index=total=0;

if (!lmsg) {
	send("\nNo messages to purge.\n");
	return;
	}

msource=open(filen(argv[1],"messages"),0);

printf("\nThere are %d active messages, and %d deleted messages (unpurged).\n",
	msgcount,mindex-msgcount);

if (msource)
	{
	toeof(msource);
	nmsg_rec=getrec(msource);
	total=(nmsg_rec+7)>>3;
	printf("\nMessage file now %dk",total);
	}
	else	{
		send("\messages file not found");
		return;
		}

if (summary=open(filen(argv[1],"summary"),0))
	{
	toeof(summary);
	total+=(getrec(summary)+7)>>3;
	printf(",  Summary file is %dk\n",(getrec(summary)+7)>>3);
	close(summary);
	}
	else	{
		send("\nsummary file not found");
		return;
		}

/* check if possible problem with purge to same drive */

printf("\nFree space on same drive is %uK\n",free_space(msource->_fcb.f_drive));

if ( total+2 > free_space(msource->_fcb.f_drive) )
	printf("\nWARNING: Space remaining on same drive is less than the total space used\nby the current summary, messages and counters files.");

close(msource);		/* cause gotta close for reset disk */

/* make sure the person still wants to do the purge */

ask("\n\nConvert messages (y/n) ?",temp,1,UP);
if (*temp!='Y') return;

send("\nPress any key to perform a disk reset and continue.\n(swap disks NOW if you need to!) --> ");
getchar();

reset_disk(0);
msource=open(filen(argv[1],"MESSAGES"),0);
mptr=bufloc(msource);

send("\n[Converting..]\n");

unlink(filen(argv[2],"summary"));	/* make sure no file previously */
summary=open(filen(argv[2],"summary"),1);

unlink(filen(argv[2],"counters"));	unlink(filen(argv[2],"messages"));

printf("\nOutput summary, counters and messages files go to: %s.\n",argv[2]);

mdest=open(filen(argv[2],"messages"),1);

if (!(msource && mdest && summary))
	{
	printf("\nCan't open all files...\nMESSAGES=%s  NEWMESS=%s  SUMMARY=%s \n\n",
	msource ? "<open>" : "<Couldn't open>",
	mdest ? "<open>" : "<Couldn't open>",
	summary ? "<open>" : "<Couldn't open>");
	close(msource); close(mdest); close(summary);
	return;
	}

sprintf(bufloc(summary),"%u",msgcount);
write(summary,1);

tindex=0;
while (tindex<mindex)
	{
	setarec(msource,msg[tindex].seek);	/* fix if bad recs.. */
	read(msource,1);	/* into buffer pointed to by mptr */
	if (mptr->status!=DEADMSG)
		if ((err_flag=wrtmsg(mdest,tindex))==ERROR) /* out to file */
			break;		/* stop here.. */
	++tindex;
	}
mindex=new_index;

if (err_flag!=ERROR)
  printf("\n\nMessage file now %dk,  Summary file is %dk\n\n[Finishing up]\n",
	(getrec(mdest)+7)/8,(getrec(summary)+7)/8);

close(mdest);
close(summary);
close(msource);

if (err_flag!=ERROR) pcounters(filen(argv[2],"counters"));
 else send("\n\n*** ERROR encountered while writing new file.  Operation ABORTED ***\n");

printf("\n\n[done]\n");

} /* destroy */


wrtmsg(fil,tindex)
 FILE *fil;
 int tindex;
{
omsg_record *mptr;
msg_record *newp;
int len,tlen;
char *buf,*tbuf,ts[MAXLINE];

mptr=bufloc(msource);
newp=bufloc(mdest);
sprintf(buffer,"\r[Processing %5u]",mptr->number);
send(buffer);

setmem(newp,128,0);	/* clear */
newp->number=mptr->number;
newp->seek=getrec(fil);
newp->parent=msg[tindex].parent;
/* newp->reply=msg[tindex].reply;  new format has no reply.. */
sprintf(ts,"%s %s",mptr->fsend,mptr->lsend);
ts[NAMELEN]='\0';
strcpy(newp->sender,ts);
mptr->receiver[NAMELEN]='\0';	/* terminate this */
strcpy(newp->receiver,mptr->receiver);
newp->status=mptr->status;
newp->lines=mptr->lines;
dateasc(mptr->date,newp->date_entr);
if (atoi(mptr->time)>=12)
	{
	sprintf(mptr->time,"%02d%s",atoi(mptr->time)-12,mptr->time+2);
	mptr->time[6]='p';
	}
 else mptr->time[6]='a';
timeasc(mptr->time,newp->time_entr);
strcpy(newp->topic,mptr->topic);

if (write(fil,1)!=128) return ERROR;
movmem(bufloc(fil),bufloc(summary),128);
if (write(summary,1)!=128) return ERROR;

/* if last, use global eof rec pointer to compute size.. */
if (tindex>=mindex-1) len=nmsg_rec-getrec(msource);
  else len=msg[tindex+1].seek-getrec(msource);

tlen=len;

if ( (tbuf=buf=malloc(len*128+20))==(char *)0)
	{	/* we do it the slower way if not enuf space */	
	while (len--)
		{
		if (read(msource,1)!=128) break;
		movmem(bufloc(msource),bufloc(fil),128);
		if (write(fil,1)!=128) return ERROR;
		}
	}
  else		/* we can do it the fastest way... */
	{
	while (len--)
		{
		if (read(msource,1)!=128)
			{
			tlen=tlen-len-1;  /* point to actual number read */
			break;
			}
		movmem(bufloc(msource),tbuf,128);
		tbuf+=128;
		}
	tbuf=buf;
	while (tlen--)		
		{
		movmem(tbuf,bufloc(fil),128);
		tbuf+=128;
		if (write(fil,1)!=128)
			{
			free(buf);
			return ERROR;
			}
		}
	free(buf);
	} /* most efficient way else.. */

}	/* write message */


/************************************************
 * All new and improved msg summary builder...	*
 * Will use messages file alone and skip bad	*
 * sectors that it finds...			*
 ************************************************/

read_sum(drive)
 char *drive;
{
omsg_record *mptr;	/* for easy access to values in the field */
register int flag;
int fileflag;		/* summary or message index build	  */
int lines;		/* line count of message */

flag=msgcount=totalmsgs=privmsgs=mindex=fmsg=lmsg=0;
fileflag=TRUE;

send("\n[Building index.");

if ((summary=open(filen(drive,"summary"),F_RD | F_UNLOCK))!=NULL)
 	{	/* summary file opened.. */
	toeof(summary);
	if (getrec(summary)<=1) close(summary);
	  else	{
		setarec(summary,1);
		fileflag=FALSE;
		}
	}
	else {		/* create summary to keep things happy */
		summary=open(SUMMARY,F_RW);
		sprintf(bufloc(summary),"0   \n");
		write(summary,1);
		close(summary);
		}

if (fileflag)	/* summary file not opened correctly, try messages */
	summary=open(filen(drive,"messages"),F_RD | F_UNLOCK);

mptr=bufloc(summary);	/* setup buffer pointer	*/
while (summary && read(summary,1)==128)
	{
	msg[mindex].number=mptr->number;
	msg[mindex].seek=mptr->seek;
	msg[mindex].parent=mptr->parent;
/*	msg[mindex].reply=mptr->reply;   new format has no .reply */
	if (mptr->status==DEADMSG) msg[mindex].parent=0;

	if (mptr->lines && fileflag)
		{		/* message file skip text */
		if ( (mptr->status!=PRIVMSG && mptr->status!=NORMMSG
		    && mptr->status!=DEADMSG)
	    	    || mptr->seek!=(getrec(summary)-1) )
			{	/* not valid record, skip till one found.. */
			send("\n[Bad records found, skipping..]\n");

			do lines=read(summary,1);
			  while (lines==128 && (mptr->status!=NORMMSG &&
				 mptr->status!=PRIVMSG && 
				 mptr->status!=DEADMSG) ||
				 mptr->lines>O.MLINES ||
				mptr->seek!=(getrec(summary)-1) );
			setrrec(summary,-1);
			if (lines==128) continue;	/* don't increment mindex, etc.. */		   else break;
			}
		}

	if (mptr->number)
		{
		lmsg=mptr->number;
		if (!fmsg) fmsg=lmsg;
		}

	if (mptr->status!=DEADMSG) {
			++msgcount;
			++totalmsgs;
			}

	if (mptr->lines && fileflag)
		{
		lines=mptr->lines+1;
		read(summary,1);
		while (lines--) while (getc(summary)!='\n');  /* flush line */
		}

	++mindex;	/* killed msg in table too, for upcoming unkill,etc. */

	if (mindex>=O.MAXTOTMSGS)
		{
		printf("\nTo many msgs, (%d is max, including deleted ones)\n",
			O.MAXTOTMSGS);
		close(summary);
		return ERROR;
		}
	}	/* while */

send("]\n");

if (summary && fileflag)
	{
	for (flag=0; flag<mindex; flag++)	/* fix reply/parent conficts */
		{
		if (getindex(msg[flag].parent)==ERROR) msg[flag].parent=0;
/* if (getindex(msg[flag].reply)==ERROR) msg[flag].reply=0;  */
		}
	}

close(summary);
nextmsg=lmsg+1;

return NULL;
} /* build index */


/* old get coutners */

ogcntrs(f)
char *f;
{
FILE *counters;
char tdate[10];
unsigned trash;

/* in case of failure.... */

callnum=0;	/* for defaults in case nothing found */

if ((counters=open(f,F_RD | F_LOCK))!=0)
	{
	read(counters,0);
	sscanf(bufloc(counters),"%d %d %d %s %d %d",&msgcount,
		&callnum,&nextmsg,tdate,&trash,&privmsgs);
	dateasc(tdate,date);
	close(counters);
	}

}


char *filen(s1,s2)
 char *s1,*s2;
{
static str[MAXLINE+1];

sprintf(str,"%s%s",s1,s2);
return str;
}


getindex(m)
 register unsigned m;
{
register int a;
 if (m==0) return ERROR;
 for (a=0; a<mindex; a++) if (msg[a].number==m) break;
 if (msg[a].number!=m) return ERROR;
return a;
}

