/***************************************************************
 * Conversion utility, from Version 1.31x to 1.4x
 *
 ***************************************************************
 *
 * 1.50xx 08/4/86  Fixed for latest version of user struct.
 * 1.40xx 01/28/86  City added back in.. 
 * 1.40xx 01/27/86  Written..
 ***************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"

/* old defines for user structure */

#define FNAMELEN 14
#define LNAMELEN 20
#define OCITYLEN  28
#define DATELEN  9
#define TIMELEN  9

/*********************************************
 * old user structure/file format typedef..
 *********************************************/

typedef struct	{
	int	number;
	char	first[FNAMELEN+1];
	char	last[LNAMELEN+1];
	char	pass[PASSLEN+1];
	char	date[DATELEN];
	char	time[TIMELEN];
	char	city[OCITYLEN+1];
	unsigned lastread;
	char	status;
	char	type;
	struct	{
		char	ulcase;		/* upper or lower case 	*/
		char	jmpcpm;		/* jump to cpm/no bbs  	*/
		char	expert;		/* expert user? 	*/
		char	bell;		/* bell on or off 	*/
		char	rp;		/* 'RP' command at bbs  */
		char	video;		/* video mode ok?	*/
		char	nulls;		/* number of nulls	*/
		char	height;		/* height of terminal	*/
		char	width;		/* width of terminal	*/
		unsigned tcap;		/* tcap ptr (coming)	*/
		unsigned uploads;	/* upload count		*/
		unsigned downloads;	/* download count	*/
		unsigned minutes;	/* time on system today	*/
		unsigned inforec;	/* user info file rec	*/
		unsigned calls;		/* # of times called	*/
		char	reserved[5];	/* reserved for future	*/
		char	udef[4];	/* parms for users use	*/
		} parm;
	} oldusr;

oldusr ouser;	/* old user variable */


/********************************************
 * New users file typedef format....
 ********************************************/

typedef struct	{
	unsigned number;	/* seek pos. in mem, next bucket in file */
	char	file_info;	/* bit info for users file routines */
	char	name[NAMELEN+1];	/* namelen=26..+1 */
	char	pass[PASSLEN+1];	/* passlen=8...+1 */
	char	city[CITYLEN+1];	/* citylen=26..+1 */
	char	date[3];	/* last date */
	char	time[2];	/* last time */
	unsigned lastread;	/* high message # at last login */
	char	status;		/* status character		*/
	char	login;		/* login method, message sys/os/other */
	char	flags;		/* expert (2 bits), bell, rp + other toggles */
	char	nulls;		/* number of nulls		*/
	char	width;		/* width of user display	*/
	char	height;		/* height of user display	*/
	char	minutes;	/* minutes on system today	*/
	unsigned tot_hours;	/* total hours on system so far   */
	char	tot_mins;	/* remainder mins on system total */
	unsigned calls;		/* number of calls made to system */
	unsigned uploads;	/* number of files uploaded	*/
	unsigned downloads;	/* number of files downloaded	*/
	unsigned group_flags;	/* groups user can read flags	*/
	char	tcap[8];	/* space padded Z3 tcap name	*/
        unsigned info_link;	/* record location of more info link */
        char    phone[13];	/* 12 chars (aaa-ppp-nnnn) + \0 */

	char	nada[14];  /* temp placeholder */

	/* the following variables are not saved in the file */
	u_types	*type_ptr;	/* pointer to type based on status..*/
	} newusr;

newusr nuser;	/* user variable */


main(argc,argv)
 int argc;
 char *argv[];
{
FILE *input,*output;

if (argc!=3)		/* if not 3 args... */
	{
	send("\n\rFormat:  uconvert uu/d:oldusers uu/d:newusers");
	send("\n\r          where:  uu=user area, d=drive\n\r");
	return;		/* that'ts it here.. */
	}

if ( !( (input=open(argv[1],F_RD)) && (output=open(argv[2],F_RW)) ) )
	{
	send("\n\rUnable to open both files...\n\r");
	return;
	}

while (1)	/* endless loop to do things.. */
	{
	if (read(input,1)!=128) break;
	movmem(bufloc(input),&ouser,128);

	if (convert(output)==ERROR)
		{
		send("\n\rERROR on output (write)..\n\r");
		output=close(output);
		break;
		}
	}

close(input);

if (output) flush_out(output);	/* flush output in case move to partial recs */

send("\n\r[done]\n");

}	/* main */


/********************************************************************
 * convert does the exchange of record info... from ouser to nuser
 * and also writes the new record.. returns ERROR if couldn't write
 */

convert(output)
 FILE *output;
{
char ts[FNAMELEN+LNAMELEN+4];

setmem(&nuser,128,0);	/* clear new structure */

nuser.number=getrec(output)+1;	/* sorry, could reset some (ouser.number) */
sprintf(ts,"%s %s",ouser.first,ouser.last);
ts[NAMELEN]='\0';	/* make sure <= new length */
strcpy(nuser.name,ts);
strcpy(nuser.pass,ouser.pass);
dateasc(ouser.date,nuser.date);
if (atoi(ouser.time)>=12)
	{
	sprintf(ouser.time,"%02d%s",atoi(ouser.time)-12,ouser.time+2);
	ouser.time[6]='p';	/* since new stuff assumes */
	}
  else ouser.time[6]='a';
timeasc(ouser.time,nuser.time);
nuser.lastread=ouser.lastread;
nuser.status=ouser.status;
nuser.login=(ouser.parm.jmpcpm=='1');		/* '1'=PON */
nuser.flags|=(ouser.parm.expert=='1')*EXPERT;	/* set expert mode */
nuser.flags|=(ouser.parm.bell=='1')*BELL;	/* set bell flag */
nuser.flags|=(ouser.parm.rp=='0')*READNEW;	/* set read new msgs flag */
nuser.nulls=ouser.parm.nulls;
nuser.height=ouser.parm.height;
nuser.width=ouser.parm.width;
nuser.minutes=ouser.parm.minutes;
nuser.uploads=ouser.parm.uploads;
nuser.downloads=ouser.parm.downloads;
nuser.calls=ouser.parm.calls;
ouser.city[CITYLEN]='\0';	/* make sure it's <= new city len */
strcpy(nuser.city,ouser.city);
nuser.group_flags = 1;

/* DONE with actual convert */

movmem(&nuser,bufloc(output),128);
if (write(output,1)!=128) return ERROR;

putchar('.');
return 0;
}


flush_out(output)
 FILE *output;
{
close(output);		/* doesn't do much now.. */
}



