/*****************************************************************
 * Articles/Notes, Misc. other functions overlay
 *
 *	File: MEMISC.C
 *
 *	Metal and Metal Message System are Trademarks and
 *	      Copyright (c) 1984, 1985  Tim Gary
 *	     	      All Rights Reserved.
 *
 ******************************************************************
 *
 * 1.31a  10/13/85 Release version.  Changes:
 *		   go_os() routine called from cpm()..
 *		   deleted 'readrange' routine (moved to MEREAD.C)
 *		   hangup() called when done (bye,g)
 * 1.30xx 6/23/85  Cosmetic change in getrange text.
 * 1.30xx 6/19/85  A very few changes in feature(), cpm(), etc..
 * 1.30xx 5/05/85  Comments routine fixed.
 * 1.30xx 3/07/85  Fixed for chaining to BYE program on exit..
 * 1.30xx 3/03/85  ZCPR stuff added..
 * 1.20b 01/18/85  Showtime put here..
 * 1.20b 01/16/85  Recursive use of notes/features allowed...
 * 1.20b 01/06/85  Allow 'Q' as in 'K' for read silent mode.
 * 1.20a 11/11/84  Comments messages made more universal, and Goodbye
 *		  routine made to not display info if  G;N thing
 *		  typed.
 * 1.20a 11/07/84  Comments routine fixed for two CONSECUTIVE CR's
 *		  to stop.
 * 1.10e 11/01/84  Getrange now allows to read dead msgs.
 * 1.10e 10/29/84  Added chat(), cpm() and goodbye() to this overlay.
 *
 * 1.10c 10/12/84  Created from MEFEAT.C  4 parameters passed
 *		   to all of these routines.
 *
 ******************************************************************/

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "megen.h"	/* general defines		*/
#include "meglob.h"	/* global variable definitions	*/
#include "meovfn.h"	/* overlay function numbers	*/
#include "mefiles.h"	/* file names			*/

#include "ctype.h"

/**********************************************************
 * Overlay main program, dispatches to contained routines.
 **********************************************************/

ovmain(routine,p1,p2,p3,p4)
 int routine,p1,p2,p3,p4;
{
switch(routine)
	{
	case FEATURE:
		return feature(p1,(char *)0,1);
	case CHAT:
		return chat(p1);
	case GOODBYE:
		return goodbye(p1);
	case GOCPM:
		return cpm(p1);
	case SHOWTIME:
		return showtime();
	case APPINFOG:
		return appinfog();
	default:
		send("\nUnknown routine called for.\n");
		break;
	}
} /* ovmain */


/*****************************************
 * Show current time, and time on system *
 *****************************************/

extern char last_time[],last_date[];

showtime()
{
if (O.RTC)
	{
	char ttime[TIMELEN+1],tutime[TIMELEN+1];
	int mins;	/* mins on system */
	strcpy(tutime,user.time);
	timefix(tutime);
	readclock();
	strcpy(ttime,time);
	timefix(ttime);
	mins=timecomp(time,user.time,date,user.date);
	sprintf(buffer,"\nToday is %s.  The time is %s.\nYou've been on since %s (%d minutes).\n",date,ttime,tutime,mins);
	send(buffer);
	}
  else send("\nNo clock installed on this system.\n");
}


/******************************************************************
 * Articles function to list files in the Articles/Features ('A')
 * or Notes ('N') index file.  Index file has a fixed format of:
 *	chars 1-17  = filename/location of file (C format)
 *	chars 19-end of line = Description of file (displayed
 *			       in the index
 * Each line must have at least 19 chars in it.  A standard text
 * editor may be used to create the index file.  Each line is
 * the index for one file.  A line may NOT exceed 128 chars.
 * A maximum of 25 articles may be contained in the index files.
 * If the line begins with a ';', it is considered a comment line
 * and will be ignored..
 * If the line starts with a * then the line is printed during
 * the menu display.
 ******************************************************************/

feature(ch,file_name,level)
 int ch;
 char *file_name;
 int level;			/* level number */
{
char *in[25];	/* pointer array to each filename */
char level_name[MAXLINE];
register int i,n;
char tot,*tp,*space;
FILE *indfile,*tf;
int ret_flag;

ret_flag=NULL;

space=malloc(450);		/* up to 25 files of 18 chars each name */
if (!space) return ERROR;	/* error, return to previos level */
for (i=0; i<25; i++) in[i]=space+(18*i);	/* setup pointer array */

tot=0;
if (level==1) strcpy(level_name,"main");
 else *level_name='\0';

do {

if ( (indfile=open((ch=='I' ? ITEMFILE : ch=='F' ? FEATFILE : ch=='N' ? NOTEFILE : ch=='A' ? ARTFILE : file_name ),0)) == NULL)
 	{
	send("\nSorry, nothing in menu.\n");
	ret_flag=ERROR;
	break;		/* free space, and return ERROR flag */
	}

read(indfile,1);

for (i=0; i<25; ++i)
	{
	int file_flag;
	do {
	   file_flag=FALSE;	/* flag for valid file to type.. */
	   if (fgets(buffer,indfile)==ERROR) break;
	   for (tp=buffer; *tp=='\n' || *tp=='\r'; tp++);    /* ignore cr/lf */
	   if (!ustrncmp(tp,";MENU ",6))
		    strcpy(level_name,tp+6);	/* new level name */
	   if (*tp==';') continue;
	   if (*tp=='*')		/* display line in menu		*/
		{
		printf("\n%s",tp+1);
		continue;
		}
	   if (*tp<' ' || strlen(tp)<20) break;	/* logical or phys. eof? */
	   sscanf(buffer,"%18s",in[i]);
	   sprintf(buffer,"\n%2d. %s",i+1,tp+18);
	   if (!strloc) if (send(buffer)==ERROR) break;	/* allow abort */
	   file_flag=TRUE;	/* only ok at bottom of loop */
	   } while (!file_flag);
	if (!file_flag) break;	/* true abort of menu... */
	}	/* for */

close(indfile);		/* That's all we need here for now */

if (i==0)	/* nothing found */
	{
	ret_flag=ERROR;
	break;
	}

if (tot<i) tot=i;	/* tot=total # of items.. */

if (!strloc)
	{
	putchar('\n');
	if (user.parm.expert==POFF)
		{			/* novice explaination */
		sprintf(buffer,"\nPress the RETURN key\nto %s.",
			level!=1 ? "return to PREVIOUS menu level" :
				   "return to Message System command mode");
		send(buffer);
		if (level!=1) send("\nEnter 0 to return to Metal command mode.");
		}
	 else if (level!=1) send("\nEnter 0 to abort command\n\
RETURN to goto previous menu level.");
	}

sprintf(buffer,"\n\n[%d][%s] Select which menu item number? ",level,level_name);
ask(buffer,buffer,2,UPLOW);
if (*buffer=='\0') break;	/* ret_flag default is NULL */

n=atoi(buffer);
if (!isdigit(*buffer) ||  n>tot) continue;
if (n==0)
	{
	ret_flag=TRUE;
	break;
	}

if ((tf=open(in[n-1],0))!=ERROR)	/* open file, test for ';MENU' */
	{
	read(tf,1);
	fgets(buffer,tf);
	close(tf);
	if (!ustrncmp(buffer,";MENU",5))
		{			/* another menu, do recursive.. */
		ret_flag=feature(0,in[n-1],level+1);	/* recursive */
		if (ret_flag==TRUE) break;		/* massive withdrawl */
		}
	  else type(in[n-1]);	/*  type the file if not menu */
	}
   else send("\nSorry, that item is empty.\n");

} while (1);	/* just a loop forever */

free(space);
return ret_flag;
}


/**********************
 * Comments help info *
 **********************/

comm_help()
{
static char *c_text[] = {
	"\nYou may leave a private comment to Sysop now.\n",
	"\nAn answer other than Yes or No will abort the",
	"\ncurrent command.\n",

/*	"\nRemember:  If you expect a reply to a question,",
	"\nit is much better to use the 'Comment' command",
	"\ninstead of leaving comments here!\n",		*/

	0 };
if (!strloc) dis_text(c_text);
}


/************************************
 * Ask user if he wishes to leave comments to sysop
 ************************************/

askcomments(str)
 char *str;
{
/* register FILE *comments;
int cr_flag=FALSE;		*/

if (user.parm.expert!=PON) comm_help();

do	{
   if (!str) ask("\nLeave private comments to the Sysop (y/n)? ",buffer,2,UP);
     else ask(str,buffer,2,UP);
   if (*buffer=='?') comm_help();
	}
	while (*buffer=='?');	/* while he's still confused.. */

if (*buffer=='Y')
   {		/* enter comments now */

	ovovload(OVSEND,2,0);
   }


   else if (*buffer!='N')
		{
		send("\n[Returning..]\n");
		return ERROR;	/* didn't want to leave */
		}

return NULL;
}



/*******************
 * chat with sysop *
 *******************/

chat(mode)
 int mode;
{
register int a,cfast;
register char temp;
int col;		/* current column count for auto wrap */

if (mode)
	{		/* display user if no 25th status line */
	putchar('\n');
	if (!O.STATUSLINE) printf("%s %s is ",user.first,user.last);
	 else wustat("  [CHAT]");
	send("Calling for Sysop  ");
	globalchar='\0';
	for (temp=0; temp<25; temp++)
		{
		if (send("\07 .\07 .\07 .")==ERROR) return;	/* bell */
		for (cfast=0; cfast<1000; cfast++)
			if (breakkey()) return;
			 else if ((a=globalchar)==0x1b)	/* ESC hit by sysop? */
				{
				wustat(0);	/* put back just user info */
				send("\nThe Sysop is available, please go ahead...\n");
				break;
				}
		if (send("\b\07\b\b\07\b\b\07")==ERROR) return;	/* backup most of the way */
		if (a==0x1b) break;	/* ESCAPE is Sysop's "I'm here" char */
		}
	if (!a)	
		{
      		send("\nThe Sysop is currently not available.\n");
		askcomments("\nWould you like to leave private comments\
\nto the System Operator? ");
		return;
		}
	} /* end mode check... if mode=0 then just start chat mode */
globalchar=0;	/* for next pass through */
send("\n\n** [^K to abort chat] **\n\n");

col=1;	/* first column */
while((cfast=getchar())!=11)		/* while not ^K */
	{
	if (cfast=='\r')
		{
		col=1;
		putchar('\n');
		}
	 else if (cfast=='\b' || cfast==0x7f)
		  {
		  --col;
		  send(" \b");
		  }
	  else {
	       if ( ( ++col>user.parm.width-7 &&
		     (isspace(cfast) || ispunct(cfast)) )
		  || (col>user.parm.width-1) )
			{
			col=1;
			send("\n");	/* force CRLF */
			}
		}
	}
putchar('\n');
}


/* Write user status line info (name, stat, time called, city).. */

wustat(s)
 char *s;
{
char buf[128];
sprintf(buf,"%8s -- %s %s - '%c' %s -- %s",s ? s : "",user.first,
	user.last,user.status,time,user.city);
writestat(buf);
}


/*******************
 * jump to CP/M... *
 *******************/

cpm(mode)
 register int mode;	/* if mode=1 then ask if leave comments */
{
#ifdef Z3
char **msgbuff;
#endif

if (O.user_types[user.type].maxuser==0 ||
	!index("+snxabc",user.status) )
	{ send("\nOnly registered users have access to the Files area."); return; }

/* if (mode==1)	
	if (askcomments(0)==ERROR) return; */	/* didn't want to leave */

#ifdef SFASFAS		/* comment out block */

if (user.parm.expert!=PON) type(CPMINFO);

*tout=O.user_types[user.type].timeout;
*maxuser=O.user_types[user.type].maxuser;
if (O.ZCPR) if (O.user_types[user.type].zcprflag==YES)
		if (O.ZCPR!=3) *O.SECURELOC=255;
		  else *(z3env->wheel)=255;
#ifdef Z3
msgbuff=z3env->msg+0x48;
*msgbuff=(char *)0;
#endif

#ifndef MULTI_USER
 *(char *)0=0xc3;
#endif

sprintf(buffer,"\nYou have access thru user %d%d:\n\n\
[Entering Operating System]",*maxdrive,*maxuser);

send(buffer);
exit(0);		/* enter OS	*/
#endif /* null out */

go_os(1);

}


/*******************************
 * Leave the system
 *******************************/

goodbye(mode)
 register int mode;
{
/* if (mode==1)	*/ /* if 'g' entered. else no comments */
/*	if (askcomments(0)==ERROR) return; */	/* didn't want to leave */
hangup(YES);	/* display copyright and hangup.. */
}

/****************************
*  add to the APPINFO file
*****************************/

appinfog()
{
if(user.status==SYSOP) 
	{
register FILE *appinfo;
int cr_flag=FALSE;

	appinfo=open(APPINFO,F_RW | F_LOCK);
	toeof(appinfo);	/* go to end of file */
	if (getrec(appinfo)>0)
		{
		setrrec(appinfo,-1);	/* backup */
		read(appinfo,0);
		while (getc(appinfo)!=EOF);
		setbuf(appinfo,getbuf(appinfo)-1);	/* point to eof */
		}
	printf(buffer);
do	{
	send("->");
	getl(buffer,UPLOW+MSGLINE);
		fputs(buffer,appinfo);
		putc('\n',appinfo);
	if (*buffer=='\0')
		{
		if (!cr_flag) cr_flag=TRUE;
		   else break;
		}
	   else cr_flag=FALSE;
	}
	 while (1);

	putc(0x1a,appinfo);	/* CP/M EOF */
	while (!eobuf(appinfo)) putc('\0',appinfo); /* fill rest with null*/
	write(appinfo,0);      /* last minute cleanup */
	close(appinfo);
	}

return NULL;

  }


/* EOF MEMISC.C */

