;..................................................................
;
;  File:	MEINITB5.ASM
;  Written by:	Kevin Murphy / Tim Gary
;  Date:	10/02/85
;  Version:	1.03
;  Based on:	MEINIT.ASM
;  Written by:	Tim Gary
;
;  This routine will pass a number of useful pieces of information
;  from METAL (131XX28 or later) to BYE (501 or later)
;  This is done via the extended BDOS calls in the latest versions of BYE.
;  The data is proccessed and transfered to the LCDATA buffer in BYE.
;      >>>> Thanks to Tim Gary, a real gem of an idea <<<<
;
;  1) Edit your BYE equates as follows
;
;  ->NO25TH	EQU	YES
;  ->READLC	EQU	NO
;
;  ->Now reassemble BYE, the rest is up to METAL
;
;  2) What info is passed ?
;
;   - Users first and last name
;   - Users stataus level (+,s,n,x,X,a,b,c)
;   - Users password
;   - Users location (city & state)
;     (these 4 will be displayed by the ^W in bye now)
;   - Max-time allowed on system is written into BYE, so that the Max-time
;     you set in METAL is also true in BYE
;   - User number, the user number is passed to BYE via locations
;     LCDATA + 76, and LCDATA + 77. They may be read in bye or an
;     application program to ease file ops and so on
;   - also notice that I clear the KMODEM/XMODEM upload/download counters
;..............................................................................
;
;  Installing B5MEINIT.....
;
;  Use ASM or another to create a hex file.
;
;  Then.......
;
;  DDT METAL.COM
;  -IB5MEINIT.HEX
;  -R
;  -^C
;  SAVE xx METAL.COM
;
;  MLOAD may also be used if you prefer
;
;.............................................................................
;
;
;  File: MEINIT.ASM
;
;  This file can be used as a starting point for an initialization
; routine file Metal/Z-Msg versions 1.31 and later..
;
;  This is an entirely optional insert file.
;
;  An initialization routine is handy for setting up other remote
; access system programs (eg. bye).  The following information is
; passed to this routine from the message system:
;
;	. Whether or not BYE is active
;	. a pointer to the 'user structure' which contains the user
;	  name, where they are from, etc..
;	. a pointer to the 'user status' parameter block coresponding
;	  to the current user.	This will give things like the max
;	  amount of time allowed on the system, max user, max drive, etc..
;
;   The init routine is called after the user name and password have
; been verified by the system.
;
; *** This routine must not excede 251 bytes in length ***
;				   ===

	ORG	384H		; Fixed location to put it at..

	DB	0FFH		; Flag to tell message system init routine
				; Is installed...
BYE:	DB	00		; Passed flag if bye is active..
USER:	DW	0000		; Pointer to user structure
STATUS:	DW	0000		; Pointer to user status info
	DB	00,00,00,00,00,00 ; Reserved for later..
;
;
; The following are offsets from 'user' above
;
UNUMBER	EQU	0	; User number (also seek pos into users file) (2 bytes)
UFIRST	EQU	2	; First name of user	      (0 terminated string)
ULAST	EQU	17	; Last name of user	      (0 terminated string)
UPASS	EQU	38	; Password		      (0 terminated string)
UDATE	EQU	47	; Date last logged on	      (0 terminated string)
UTIME	EQU	56	; Time last logged on	      (0 terminated string)
UCITY	EQU	65	; City of user		      (0 terminated string)
ULASTRD	EQU	94	; Message at last login 	      (2 bytes)
USTATUS	EQU	96	; User status character (+snXxabc)    (1 byte)
UJMPOS	EQU	99	; Auto jump to OS on login? ('1'=yes) (1 byte)
UBELL	EQU	101	; Bell enabled? ('1'=yes)	      (1 byte)
URP	EQU	102	; Auto read on login? ('1'=yes)       (1 byte)
UNULLS	EQU	104	; Nulls 			      (1 byte)
UHEIGHT	EQU	105	; Terminal height		      (1 byte)
UWIDTH	EQU	106	; Terminal width		      (1 byte)
UUPLOAD	EQU	109	; Upload file count   (2 byte) --not used yet--
UDNLOAD	EQU	111	; Download file count (2 byte) --not used yet--
UMINS	EQU	113	; Minutes on today    (1 byte) --not used yet--
UCALLS	EQU	117	; Unsigned number of calls	      (2 byte)
UDEF	EQU	124	; You can actually use these locs..   (124-127)
;
; The following offsets are from 'status' above...
;
SSTATUS	EQU	0	; Status char (+snXxabc)
SMAXDRV	EQU	1	; Max drive
SMAXUSR	EQU	2	; Max user
SACTTOUT EQU	3	; Activity timeout in mins (timeout if not typing)
SKILLFLG EQU	4	; Kill messages flag..
SZCPRFLG EQU	5	; Wheel privs?
SREADPRV EQU	6	; Read private msgs?
SPOSTMSG EQU	7	; Allowed to post messages?
STIMEOUT EQU	8	; Logoff timeout in minutes
SZ3FLAGS EQU	9	; 2 byte commands file flag (zcpr3 only)
;
; --------
; B5MEINIT special equates..
; --------
;........................
;
; These constants never change
;
NO	EQU	0
YES	EQU	NOT NO
;
BDOS	EQU	0005		; Define the BDOS jump
;
GETLCDATA EQU	80		; Bye bdos code to get pointer to lcdata
SETMAXTIM EQU	81		; Bye set max time
;
;........................
;
KMD	EQU	YES		; Yes if useing kmd upload/download counters
;
UPLOAD	EQU	0054H		; Location of kmd/xmodem upload counter
DOWNLOAD EQU	0055H		; Location of kmd/xmodem download counter
;
;
; End of equates
;
;........................
;
; Start of the code...

	PUSH	H		; Save everything, cause Tim says so
	PUSH	D		; Better safe than sorry
	PUSH	B
	PUSH	PSW
;
;
;..............................
;
; Make sure BYE is home
; We use this method to insure that we have BYE501 or later/else BYE337
; or later.....else this is all going to barf !!!
;
	MVI	E,241		; Use extended BDOS check
	MVI	C,32		; Ask for user #241
	CALL	BDOS
	CPI	77		; Are we alive in BYE ?
	JNZ	METOUT		; Nope, oopps... exit
;
;
;.............................
;
	MVI	C,GETLCDATA	; Get LCDATA address from BYE
	CALL	BDOS
	MOV	A,M		; Get the first character
	CPI	' '		; Is it a space
	JNZ	METOUT		; Nope... we have been here before.. exit
	XCHG			; Swap the LCDATA pointer into DE
	LHLD	USER
	LXI	B,UFIRST	; Point to first name
	DAD	B		; Add offset to user pointer
	CALL	REDO		; Copy it into buffer, and add ending space
	LHLD	USER		; Get user pointer again
	LXI	B,ULAST		; And copy over last name..
	DAD	B
	CALL	REDO
;
;
;..............................
;
; Enclose the users status symbol in
; "( )" so it is real pretty
;
	XCHG			; Get current lcdata location into HL
	MVI	M,' '		; Insert a space in the proccessed data
	INX	H		; Goto next position
	MVI	M,'('		; Insert "("
	INX	H
	XCHG			; Put current lcdata pos back into DE
	LHLD	USER		; Get user pointer again
	LXI	B,USTATUS	; Offset to status char
	DAD	B
	MOV	A,M		; Put the character in reg A, this is the
				; Users status character
	XCHG			; Get current lcdata into HL again..
	MOV	M,A		; Insert stat char
	INX	H
	MVI	M,')'		; Insert ")"
	INX	H
	MVI	M,' '		; Add a space
	INX	H
	MVI	M,'-'		; Inerst a dash to seperate status from password
	INX	H
	MVI	M,' '
	INX	H
	XCHG			; Current lcdata back to DE
	LHLD	USER
	LXI	B,UPASS		; Point to the password
	DAD	B
	CALL	REDO		; And copy it over
;
; Make things pretty...
;
	XCHG			; Current lcdata pointer back to HL
	MVI	M,' '
	INX	H
	MVI	M,'-'
	INX	H
	MVI	M,'>'
	INX	H
	MVI	M,' '
	INX	H
	XCHG			; Current lcdata back to DE..
	LHLD	USER
	LXI	B,UCITY		; Point to city..
	DAD	B
	CALL	REDO		; And copy it over..
	XRA	A		; Clear a (null)
	STAX	D		; Save it into current lcdata pointer
;
;
;...........................
;
; Put the user number in the last 2 bytes of LCDATA buffer
; protect it with a leading null
;
; We do this last incase it was a long one and it took up
; our space, we'll just over write, and cut of the who data
;
	MVI	C,GETLCDATA	; Get LCDATA address again
	CALL	BDOS
	LXI	B,75		; Point to 75 bytes into the lcdata area
	DAD	B
	MVI	M,0		; Put a NULL at lcdata+75
	INX	H
	XCHG			; DE now has pointer to lcdata+75
	LHLD	USER		; Get pointer to user number
	MOV	A,M		; Get user number (1st byte)
	STAX	D		; These go into lcdata+76....
	INX	D
	INX	H
	MOV	A,M		; Get second byte of user number
	STAX	D
;
;
;............................
;
; Set max time allowed on system
;
	LHLD	STATUS		; Get pointer to user status area
	LXI	B,STIMEOUT	; Point to timeout in minutes
	DAD	B
	MOV	E,M		; And put in e
	MVI	C,SETMAXTIM	; Use extended BDOS to set the max time allowed
	CALL	BDOS
;
;
;................................
;
; Zero the KMODEM/XMODEM upload/download counters

	 IF	KMD		; If KMD  counters are used
	XRA	A		; Zero out A reg
	STA	UPLOAD		; Zero the upload counter
	STA	DOWNLOAD	; Zero the download counter
	 ENDIF
;
	JMP	METOUT		; Thats it so exit back to real METAL
;
;
;..........................
;
REDO:	MOV	A,M		; Get a character from the metal buffer
	ORA	A		; Is it a null???
	JZ	SPNXT		; Yep.. insert a space and return to sender
	STAX	D		; Nope, then put it in the LCDATA buffer
	INX	D		; Advance the pointer for LCDATA
	INX	H		; Advance the pointer for METAL
	JMP	REDO		; Else keep looping
;
;
;.............................
;
SPNXT:	MVI	A,' '		; Put a space in reg A
	STAX	D		; Insert it in the LCDATA buffer
	INX	D		; Advance the LCDATA pointer
	RET			; Return to sender
;
;
;..............................
;
METOUT:	POP	PSW		; Restore everything
	POP	B
	POP	D
	POP	H
;
;
	RET			; Simple return ends routine
;
;   The RET (above) is the last byte of the routine
;   and it's address must be 047fh or less ----
;   (you can TYPE the B5MEINIT.PRN file after assembley
;   to check this)
;
;   END  of B5MEINIT.ASM
;...............................
;.
