/******************************************************************************
 * 	This is the main METAL/Z-MSG module
 *
 *	Name: METAL.C or Z-MSG.C	VERSION 1.30xx
 *
 *			Copyright (c) 1984  Tim Gary
 *			     All rights reserved.
 *
 *	This is a commercial product, and is for use by a single system
 *	and user.  Copies may be made for backup purposes ONLY.
 *
 ******************************************************************************
 *
 * 1.30xx 7/01/85  Print and echo flags saved/restored now..
 * 1.30xx 6/19/85  G_restore, etc done here to avoid ANY memory conflicts..
 * 1.30xx 6/15/85  Apply/Comments pass diff. 'func' vals, time expired fixed.
 * 1.30xx 6/09/85  Moved memory allocation settop routine here.  Etc..
 * 1.30xx 5/26/85  Make sure non expert mode set for welcome message, etc..
 * 1.30xx 5/25/85  Modified to find highest location for msg allocation, so
 *		  extra memory won't be needed for an alias (for msg).
 * 1.30xx 5/02/85  Turned Z3BUG off, Z3MSG_OFFSET define added.
 * 1.30xx 5/01/85  Fixed for renaming of MESUMM TO MESTUFF.
 * 1.30xx 4/28/85  Slight Z3 debug stuff added..
 * 1.30xx 4/26/85  Fix for saving z3 command line..
 * 1.30xx 3/13/85  Fix for return from OS...
 * 1.30xx 3/07/85  BBSNAME stuff added..
 * 1.30xx 3/03/85  Continued with z3setup..
 * 1.30xx 2/20/85  Start changes for Z3 multi command lines, etc..
 * 1.20b 01/18/85  Showtime seperated to overlay..
 * 1.20b 01/14/85  Prompt shows time on system so far.
 * 1.20b 01/11/85  More clock support added at prompts, etc..
 * 1.20b 01/05/85  Bug fixes, add fast change to sysop stat from CP/M.
 * 1.20a 11/04/84  Alias to apply command is COMMENT.
 * 1.10e 11/03/84  Added APPLY command.
 * 1.10e 10/31/84  Functions moved out of this routine, overlays functions
 *		  added, new UNKILL command (also RESTORE=same thing).
 * 1.10c 10/12/84  Some routines moved to MEMISC overlay to conserve space.
 *
 * 1.10b 10/04/84  Chat fixed for xx columns, auto return..
 * 1.10b 10/01/84  Spelling error fixed.  Other cosmetics.
 *
 * 1.10a  9/27/84  More cosmetic changes.
 * 1.10a  9/08/84  Chat routines expanded to include user name, and if
 *		  sysop is not around, ask if they would like to leave
 *		  private comments to the sysop.
 * 1.10a  9/01/84  Continued work on overlays.
 * 1.10a  8/24/84  JUST STARTING OVERLAY VERSION.
 *
 * 1.01a  7/02/84  Multi-user lastcalr implemented.
 * 1.01a  6/27/84  Multi user OS support cont..  
 * 1.01a  6/10/84  Fixes for Aztec C 1.06.  Added Link to mutil command,
 *		  also started provisions for Multi-user OS's..
 *
 * 1.0b   4/22/84  Problem with mult commands fixed (introduced 9 days ago)
 * 1.0b   4/20/84  Fixed 'U' bug (command changed user.lastread..)
 * 1.0b   4/13/84  Added upper/lower case name ability.  3 User defined
 *		   files may be displayed.  '!' command now restores original
 *		   user status when turning off sysop status.  'Articles'
 *		   command added to allow printing of various text files.
 *
 * 1.0a	  2/15/84  Lastcalr file changed, benefit: pretty xmodem log, and
 *		   user parameters 'stick' when the user changes them and exits
 *		   to CP/M, and then returns.  NOCPM fix.
 *
 *****************************************************************************/

/* #define Z3BUG   */ /* for duration of debugging Z3 stuff in this file */

#define MAIN		/* this is for the .h files */

#include "xpm.h"	/* CPMIO header file for i/o operations.*/
#include "hmh.h"	/* METAL header, variable types, etc	*/
#include "hmconfg.h"	/* options/config declarations		*/
#include "ctype.h"

/* these need to be declared so the structure will work */

int type(),readmsgs(),expert(),whoisthis();

/* now for the main command structure with abbreviations, and routines */

struct cmdtype maincomtab[] = {
/*	Command Name	Function	Parameter	Overlay	    */
/*	--------------	------------	------------	----------  */
	"AD","D",	ADDUSER,	0,		OVSTUFF,
	"AP","PLY",	1,		0,		OVSEND,
	"A","RTICLES",	FEATURE,	'A',		OVMISC,
	"B","ULLETINS",	type,		BULLETIN,	0,
	"BYE","\0",	GOODBYE,	NO,		OVMISC,
	"CA","LLERS",	CALLS,		0,		OVINFREQ,
	"CH","AT",	CHAT,		YES,		OVMISC,
	"CO","MMENT",	2,		0,		OVSEND,
	"C","PM",	GOCPM,		YES,		OVMISC,
	"ED","IT",	EDITUSER,	0,		OVUSER,
	"E","NTER",	0,		0,		OVSEND,
	"EX","PERT",	EXPERT,		0,		OVSTUFF,
	"F","EATURES",	FEATURE,	'A',		OVMISC,
	"G","OODBYE",	GOODBYE,	YES,		OVMISC,
	"H","ELP",	type,		HELP,		0,
	"J","UMP",	GOCPM,		NO,		OVMISC,
	"K","ILL",	KILL,		0,		OVKILL,
	"L","IST",	READUSERS,	NOPRINT,	OVINFREQ,
	"M","ESSAGES?",	MSGALERT,	0,		OVINFREQ,
	"N","OTES",	FEATURE,	'N',		OVMISC,
	"O","THERSYS",	type,		OTHERSYS,	0,
	"PR","INT",	READUSERS,	PRINT,		OVINFREQ,
	"PU","RGE",	PURGE,		0,		OVSYSOP,
	"Q","UICKSUM",	SUMM,		NO,		OVSTUFF,
	"R","EAD",	readmsgs,	'\0',		0,
	"REP","LY",	0,		-1,		OVSEND,
	"RES","TORE",	UNKILL,		0,		OVKILL,
	"RN","S",	readmsgs,	'P',		0,
	"RP","\0",	readmsgs,	'P',		0,
	"RS","\0",	readmsgs,	'S',		0,
	"RR","S",	readmsgs,	'R',		0,
	"ST","ATS",	STATS,		0,		OVINFREQ,
	"S","UMMARY",	SUMM,		YES,		OVSTUFF,
	"T","IME",	SHOWTIME,	0,		OVMISC,
	"UN","KILL",	UNKILL,		0,		OVKILL,
	"U","SERPARMS",	SAVEUSER,	0,		OVINFREQ,
	"W","ELCOME",	type,		WELCOME,	0,
	"WH","O",	WHO,		0,		OVSTUFF,
	"X","PERT",	EXPERT,		0,		OVSTUFF,
	"Y","ELL",	CHAT,		YES,		OVMISC,
	"Z","\0",	CALLS,		0,		OVINFREQ,
	"#","\0",	STATS,		0,		OVINFREQ,
	"?","\0",	type,		HELP,		0,
	"-","\0",	WHO,		0,		OVSTUFF,
	"!","\0",	SOSTAT,		0,		OVSYSOP,
	"+","\0",	READCOMM,	0,		OVSYSOP,
	"//","\0",	CHAT,		NO,		OVMISC,
	0,0,0,0,0
	};

/**********************************************************************/

/**************************
 * start the main program *
 **************************/

main(argc,argv)
 int argc;
 char *argv[];
{
char temp[40];

/* do initial stuff in another area...  Must be the VERY FIRST thing here */

init(argc,argv);


/***************************
 * main command input loop *
 ***************************/

while(1)				/* one giant endless loop.. */
	{
	sprintf(temp,"%s%s: ",
		user.parm.expert!=PON ? "(Enter '?' for help)  "
		 : "",user.status==SYSOP ? "Sysop" : "Command");

	if (get_cmd(temp,maincomtab)==ERROR)	/* ERROR=bad command */
		{
		send("I didn't follow that, try '?' for help!");

   /*		switch (message.number&3)
			{
			case 0:	send("Oh really!\n");
				break;
			case 1: send("I beg your pardon!\n");
				break;
			case 2: send("Say what?\n");
				break;
			default: send("Your typing's a little rusty!\n");
				break;
			}
    */
		strloc=0;	/* sorry, but one error aborts rest.. */
		}	/* error in command */
	}	/* main while loop */

}	/* MAIN loop */ 	 	


/*********************************************
 * Init stuff.. Sets top of program pointer
 * for overlays.  Checks to see if init
 * overaly is to be loaded.  Does g_restore if
 * return from zcpr command...
 *********************************************/

init(argc,argv)
 int argc;
 char *argv[];
{
char **m_buff;

settop(OVRSPACE);	/* alloc space for overlays */

/* if z3 stuff, make sure there's room for protection code here */
if (O.ZCPR==3) z3_hp=settop(sizeof(struct g_prot)+10);

msg=settop((O.MAXTOTMSGS*8)+16);	/* space for the message array */

user.parm.expert=POFF;	/* make sure user is novice class */
findbye();	/* get bye addresses.. */

#ifdef Z3
/* setup z3 pointer if being used */

if (O.ZCPR==3)
	{
	z3env=0x100;	/* point to initial 'internal' descriptor */
	if (z3env->class==1) z3env=z3env->expath; /* if ext., point there */
	*(z3env->wheel)=0;	/* no wheel */
	m_buff=(z3env->msg)+Z3MSG_OFFSET;

#ifdef Z3BUG
	printf("\nZ3 is being used, and z3env is located at %xh.\n",
		(unsigned)z3env);
	printf("\nZ3 message buffer (@ %xh) has a value of %xh.\n",
		(unsigned)m_buff,(unsigned)*m_buff);
#endif

	if (*m_buff!=(char *)0 && argc>1)
		{
		argc=-1;		/* MUST do this to flag silent stuff */
		g_restore(*m_buff);
#ifdef Z3BUG
		printf("\nBack from g_restore.  User name=%s %s.\n",
			user.first,user.last);
#endif
		*m_buff=(char *)0;	/* clear this */
		}
	}
	else	/* falls through */
#endif	/* Z3 */
	  if (O.ZCPR) *O.SECURELOC=0;	/* make sure system is safe */

if (argc>1) argc=ovloader(OVMENTER,argc,argv);

if (argc==1)
	{
	ovloader(OVINFREQ,INIT,argc);	/* initialize the works.. */

/* if auto read option ON, then do this.. */
	if (user.parm.rp==POFF)
		{
		send("[Auto Read]\n");
		readmsgs('P');	/* do a RP */
		}
	}

*maxuser=O.user_types[user.type].maxuser;	/* fix this */
new_page();	/* reset line count */

} /* init */


/* Restore global variables */

g_restore(glob_loc)
 char *glob_loc;
{
struct g_prot *gh_p;	/* header pointer */
struct g_save *gp;	/* global variables pointer */
int size;

gh_p=glob_loc;		/* header loc */
glob_loc=gh_p->g_vars;	/* skip to real fields */

#ifdef Z3BUG
printf("\nglob_loc now=%x   gh_p=%x\n",glob_loc,gh_p);
#endif

movmem(glob_loc,&user,sizeof(user));
glob_loc+=sizeof(user);
gp=glob_loc;	/* get misc. variables area */

#ifdef Z3BUG
printf("\nUser #%d  '%s %s'\n",user.number,user.first,user.last);
printf("gp=%x, gp->glbstr=%x  glbstr=%x\n",gp,gp->glbstr,glbstr);
#endif

movmem(gp->glbstr,glbstr,MAXLINE+1);	/* restore command line */

#ifdef Z3BUG
printf("after glbstr move, name='%s %s'\n",user.first,user.last);
#endif

/* msg=gp->msg;	*/	/* restore msg variable pointer */
strloc=gp->strloc;
globalch=gp->globalch;
print_flag=gp->print_flag;
echo_flag=gp->echo_flag;
sepstr=gp->sepstr;
fmsg=gp->fmsg;
lmsg=gp->lmsg;
mindex=gp->mindex;
msgcount=gp->msgcount;
privmsgs=gp->privmsgs;
nextmsg=gp->nextmsg;
totalmsgs=gp->totalmsgs;
callnum=gp->callnum;
strcpy(date,gp->date);
strcpy(time,gp->time);
strcpy(last_date,gp->last_date);
strcpy(last_time,gp->last_time);
height=gp->height;

#ifdef Z3BUG
printf("\nname='%s %s'...gp=%xh\n",user.first,user.last,gp);
#endif

movmem(gp->path,z3env->expath,(unsigned)(2*z3env->expaths));
movmem(&(gp->cmdbuf),z3env->cl,(unsigned)(z3env->cls+4) );

} /* g_restore */


/********************************************
 * Get a line of input, and do command if a *
 * match is found....			    *
 ********************************************/

get_cmd(str,cmdlist)
 char *str;
 struct cmdtype *cmdlist;
{
register struct cmdtype *ind;		/* index to go through list */
register char *chind;			/* character index	    */
char s_time[TIMELEN+10];
char temp[MAXLINE+1];

sepstr=' ';	/* allow space seperator */
do {
   if (O.RTC)
	{
	int mins,tm;
	readclock();	/* get time */
	mins=timecomp(time,user.time,date,user.date);
	sprintf(s_time,"[%d min.] ",mins);
	tm=O.user_types[user.type].minutes;
	if (tm && mins>tm)
		{
		send("\n[Time Limit Expired]\n");
		if (!strcmp(BYE,"NONE"))
			{
			char *zero=0;
			*zero=0xcd;
			exit(0);
			}
		  else linkbye();
		}
	}
     else *s_time='\0';

   sprintf(temp,"\n%s%s",s_time,str);	/* add current time to string */
   ask(temp,buffer,MAXLINE,UP);	/* print prompt, and get line */
   if (*buffer=='/' && buffer[1]!='/')
	{
	strloc=0;	/* nullify rest of line */
	*buffer='\0';
	continue;
	}
   } while (*buffer=='\0');

sepstr='\0';	/* turn this off */

for (ind=cmdlist; ind->abbr; ind++)
	{
	if (!strncmp(buffer,ind->abbr,strlen(ind->abbr)))
		{	/* matched abbreviation */
		chind=buffer+strlen(ind->abbr);
		if (!strncmp(chind,ind->full,strlen(chind)))
			{
			if (ind->ovname==0) (*ind->func)(ind->value);
			  else ovloader(ind->ovname,ind->func,ind->value);
			break;	/* get out of all these nested tests */
			}
		} 	/* abbr. match test */
	}  /* search loop */

if (ind->abbr) return NULL;	/* NULL=command found */

#ifdef Z3
if (O.ZCPR==3)			/* if ZCPR3 is in use */
	{
	strcpy(temp,buffer);
	return ovloader(OVZ3,CMD,temp);	/* do alias command if found */
	}
   else	/* 'fall' through to return ERROR */
#endif

return ERROR;	/* command not found */

}  /* get_cmd */


char ostat=0;	/* these need to be externs here, since overlays */
char otype=0;	/* don't like statics (they don't stick)	 */


/*****************************
 * Check if user matches the passed string
 *****************************/

thisis(s)
 register char *s;
{
char bs[FNAMELEN+LNAMELEN+2];

sprintf(buffer,"%s %s",user.first,user.last);
strcpy(bs,s);  upcase(bs);	/* make passed string upper case only */

if (!ustrcmp(buffer,s) || (user.status==SYSOP && usindex("SYSOP",bs)))
	return TRUE;

return FALSE;
}


/****************************************
 * da..du..du..da..dat's all folks....	*
 ****************************************/

