/*
** psin, pcos, and ptan -- fast trig routines
**	Return the sin, cos, or tan (in integer form) of the argument angle
**	(which is expressed in old PSLs).
**	512 old PSLs == pi radians, (equivalent to Bang10, or BIR10).
**	Results scaled so that 1024 = 1.0
*/

#define	PI		0x0200
#define	PI_OVER_TWO	0x0100

short	sintab[]	= {
	0,	6,	13,	19,	25,	31,	38,	44,
	50,	57,	63,	69,	75,	82,	88,	94,
	100,	107,	113,	119,	125,	132,	138,	144,
	150,	156,	163,	169,	175,	181,	187,	194,
	200,	206,	212,	218,	224,	230,	237,	243,
	249,	255,	261,	267,	273,	279,	285,	291,
	297,	303,	309,	315,	321,	327,	333,	339,
	345,	351,	357,	363,	369,	374,	380,	386,
	392,	398,	403,	409,	415,	421,	426,	432,
	438,	443,	449,	455,	460,	466,	472,	477,
	483,	488,	494,	499,	505,	510,	516,	521,
	526,	532,	537,	543,	548,	553,	558,	564,
	569,	574,	579,	584,	590,	595,	600,	605,
	610,	615,	620,	625,	630,	635,	640,	645,
	650,	654,	659,	664,	669,	674,	678,	683,
	688,	692,	697,	702,	706,	711,	715,	720,
	724,	729,	733,	737,	742,	746,	750,	755,
	759,	763,	767,	771,	775,	779,	784,	788,
	792,	796,	799,	803,	807,	811,	815,	819,
	822,	826,	830,	834,	837,	841,	844,	848,
	851,	855,	858,	862,	865,	868,	872,	875,
	878,	882,	885,	888,	891,	894,	897,	900,
	903,	906,	909,	912,	915,	917,	920,	923,
	926,	928,	931,	934,	936,	939,	941,	944,
	946,	948,	951,	953,	955,	958,	960,	962,
	964,	966,	968,	970,	972,	974,	976,	978,
	980,	982,	983,	985,	987,	989,	990,	992,
	993,	995,	996,	998,	999,	1000,	1002,	1003,
	1004,	1006,	1007,	1008,	1009,	1010,	1011,	1012,
	1013,	1014,	1015,	1016,	1016,	1017,	1018,	1018,
	1019,	1020,	1020,	1021,	1021,	1022,	1022,	1022,
	1023,	1023,	1023,	1024,	1024,	1024,	1024,	1024,
	1024,
};

psin(angle)
register int angle;
{
	register int sign;

	sign = angle & PI;			/* pick quadrant */
	angle &= (PI - 1);			/* mod PI */
	angle = angle & PI_OVER_TWO ? PI - angle : angle;
	return(sign? -sintab[angle] : sintab[angle]);
}

pcos(angle)
int angle;
{
	return(psin(angle + PI_OVER_TWO));
}

ptan(angle)
int angle;
{
	if ((angle & (PI - 1)) == PI_OVER_TWO) 
		return(32767);
	return(psin(angle) / psin(angle + PI_OVER_TWO));
}
